// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class DeleteRelationalDatabaseRequest private constructor(builder: Builder) {
    /**
     * The name of the database snapshot created if `skip final snapshot` is `false`, which is the default value for that parameter.
     *
     * Specifying this parameter and also specifying the `skip final snapshot` parameter to `true` results in an error.
     *
     * Constraints:
     * + Must contain from 2 to 255 alphanumeric characters, or hyphens.
     * + The first and last character must be a letter or number.
     */
    public val finalRelationalDatabaseSnapshotName: kotlin.String? = builder.finalRelationalDatabaseSnapshotName
    /**
     * The name of the database that you are deleting.
     */
    public val relationalDatabaseName: kotlin.String? = builder.relationalDatabaseName
    /**
     * Determines whether a final database snapshot is created before your database is deleted. If `true` is specified, no database snapshot is created. If `false` is specified, a database snapshot is created before your database is deleted.
     *
     * You must specify the `final relational database snapshot name` parameter if the `skip final snapshot` parameter is `false`.
     *
     * Default: `false`
     */
    public val skipFinalSnapshot: kotlin.Boolean? = builder.skipFinalSnapshot

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.DeleteRelationalDatabaseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteRelationalDatabaseRequest(")
        append("finalRelationalDatabaseSnapshotName=$finalRelationalDatabaseSnapshotName,")
        append("relationalDatabaseName=$relationalDatabaseName,")
        append("skipFinalSnapshot=$skipFinalSnapshot)")
    }

    override fun hashCode(): kotlin.Int {
        var result = finalRelationalDatabaseSnapshotName?.hashCode() ?: 0
        result = 31 * result + (relationalDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (skipFinalSnapshot?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteRelationalDatabaseRequest

        if (finalRelationalDatabaseSnapshotName != other.finalRelationalDatabaseSnapshotName) return false
        if (relationalDatabaseName != other.relationalDatabaseName) return false
        if (skipFinalSnapshot != other.skipFinalSnapshot) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.DeleteRelationalDatabaseRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the database snapshot created if `skip final snapshot` is `false`, which is the default value for that parameter.
         *
         * Specifying this parameter and also specifying the `skip final snapshot` parameter to `true` results in an error.
         *
         * Constraints:
         * + Must contain from 2 to 255 alphanumeric characters, or hyphens.
         * + The first and last character must be a letter or number.
         */
        public var finalRelationalDatabaseSnapshotName: kotlin.String? = null
        /**
         * The name of the database that you are deleting.
         */
        public var relationalDatabaseName: kotlin.String? = null
        /**
         * Determines whether a final database snapshot is created before your database is deleted. If `true` is specified, no database snapshot is created. If `false` is specified, a database snapshot is created before your database is deleted.
         *
         * You must specify the `final relational database snapshot name` parameter if the `skip final snapshot` parameter is `false`.
         *
         * Default: `false`
         */
        public var skipFinalSnapshot: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.DeleteRelationalDatabaseRequest) : this() {
            this.finalRelationalDatabaseSnapshotName = x.finalRelationalDatabaseSnapshotName
            this.relationalDatabaseName = x.relationalDatabaseName
            this.skipFinalSnapshot = x.skipFinalSnapshot
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.DeleteRelationalDatabaseRequest = DeleteRelationalDatabaseRequest(this)
    }
}
