// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the creation state of the canonical name (CNAME) records that are automatically added by Amazon Lightsail to the DNS of a domain to validate domain ownership for an SSL/TLS certificate.
 *
 * When you create an SSL/TLS certificate for a Lightsail resource, you must add a set of CNAME records to the DNS of the domains for the certificate to validate that you own the domains. Lightsail can automatically add the CNAME records to the DNS of the domain if the DNS zone for the domain exists within your Lightsail account. If automatic record addition fails, or if you manage the DNS of your domain using a third-party service, then you must manually add the CNAME records to the DNS of your domain. For more information, see [Verify an SSL/TLS certificate in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/verify-tls-ssl-certificate-using-dns-cname-https) in the *Amazon Lightsail Developer Guide*.
 */
public class DnsRecordCreationState private constructor(builder: Builder) {
    /**
     * The status code for the automated DNS record creation.
     *
     * Following are the possible values:
     * + `SUCCEEDED` - The validation records were successfully added to the domain.
     * + `STARTED` - The automatic DNS record creation has started.
     * + `FAILED` - The validation records failed to be added to the domain.
     */
    public val code: aws.sdk.kotlin.services.lightsail.model.DnsRecordCreationStateCode? = builder.code
    /**
     * The message that describes the reason for the status code.
     */
    public val message: kotlin.String? = builder.message

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.DnsRecordCreationState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DnsRecordCreationState(")
        append("code=$code,")
        append("message=$message)")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DnsRecordCreationState

        if (code != other.code) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.DnsRecordCreationState = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The status code for the automated DNS record creation.
         *
         * Following are the possible values:
         * + `SUCCEEDED` - The validation records were successfully added to the domain.
         * + `STARTED` - The automatic DNS record creation has started.
         * + `FAILED` - The validation records failed to be added to the domain.
         */
        public var code: aws.sdk.kotlin.services.lightsail.model.DnsRecordCreationStateCode? = null
        /**
         * The message that describes the reason for the status code.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.DnsRecordCreationState) : this() {
            this.code = x.code
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.DnsRecordCreationState = DnsRecordCreationState(this)
    }
}
