// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class GetBucketsRequest private constructor(builder: Builder) {
    /**
     * The name of the bucket for which to return information.
     *
     * When omitted, the response includes all of your buckets in the Amazon Web Services Region where the request is made.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * A Boolean value that indicates whether to include Lightsail instances that were given access to the bucket using the [SetResourceAccessForBucket](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html) action.
     */
    public val includeConnectedResources: kotlin.Boolean? = builder.includeConnectedResources
    /**
     * The token to advance to the next page of results from your request.
     *
     * To get a page token, perform an initial `GetBuckets` request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.
     */
    public val pageToken: kotlin.String? = builder.pageToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.GetBucketsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetBucketsRequest(")
        append("bucketName=$bucketName,")
        append("includeConnectedResources=$includeConnectedResources,")
        append("pageToken=$pageToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (includeConnectedResources?.hashCode() ?: 0)
        result = 31 * result + (pageToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetBucketsRequest

        if (bucketName != other.bucketName) return false
        if (includeConnectedResources != other.includeConnectedResources) return false
        if (pageToken != other.pageToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.GetBucketsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the bucket for which to return information.
         *
         * When omitted, the response includes all of your buckets in the Amazon Web Services Region where the request is made.
         */
        public var bucketName: kotlin.String? = null
        /**
         * A Boolean value that indicates whether to include Lightsail instances that were given access to the bucket using the [SetResourceAccessForBucket](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html) action.
         */
        public var includeConnectedResources: kotlin.Boolean? = null
        /**
         * The token to advance to the next page of results from your request.
         *
         * To get a page token, perform an initial `GetBuckets` request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.
         */
        public var pageToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.GetBucketsRequest) : this() {
            this.bucketName = x.bucketName
            this.includeConnectedResources = x.includeConnectedResources
            this.pageToken = x.pageToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.GetBucketsRequest = GetBucketsRequest(this)
    }
}
