// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the Amazon Elastic Compute Cloud instance and related resources to be created using the `create cloud formation stack` operation.
 */
public class InstanceEntry private constructor(builder: Builder) {
    /**
     * The Availability Zone for the new Amazon EC2 instance.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The instance type (e.g., `t2.micro`) to use for the new Amazon EC2 instance.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The port configuration to use for the new Amazon EC2 instance.
     *
     * The following configuration options are available:
     * + `DEFAULT` - Use the default firewall settings from the Lightsail instance blueprint. If this is specified, then IPv4 and IPv6 will be configured for the new instance that is created in Amazon EC2.
     * + `INSTANCE` - Use the configured firewall settings from the source Lightsail instance. If this is specified, the new instance that is created in Amazon EC2 will be configured to match the configuration of the source Lightsail instance. For example, if the source instance is configured for dual-stack (IPv4 and IPv6), then IPv4 and IPv6 will be configured for the new instance that is created in Amazon EC2. If the source instance is configured for IPv4 only, then only IPv4 will be configured for the new instance that is created in Amazon EC2.
     * + `NONE` - Use the default Amazon EC2 security group. If this is specified, then only IPv4 will be configured for the new instance that is created in Amazon EC2.
     * + `CLOSED` - All ports closed. If this is specified, then only IPv4 will be configured for the new instance that is created in Amazon EC2.
     *
     * If you configured `lightsail-connect` as a `cidrListAliases` on your instance, or if you chose to allow the Lightsail browser-based SSH or RDP clients to connect to your instance, that configuration is not carried over to your new Amazon EC2 instance.
     */
    public val portInfoSource: aws.sdk.kotlin.services.lightsail.model.PortInfoSourceType? = builder.portInfoSource
    /**
     * The name of the export snapshot record, which contains the exported Lightsail instance snapshot that will be used as the source of the new Amazon EC2 instance.
     *
     * Use the `get export snapshot records` operation to get a list of export snapshot records that you can use to create a CloudFormation stack.
     */
    public val sourceName: kotlin.String? = builder.sourceName
    /**
     * A launch script you can create that configures a server with additional user data. For example, you might want to run `apt-get -y update`.
     *
     * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and CentOS use `yum`, Debian and Ubuntu use `apt-get`, and FreeBSD uses `pkg`.
     */
    public val userData: kotlin.String? = builder.userData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.InstanceEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceEntry(")
        append("availabilityZone=$availabilityZone,")
        append("instanceType=$instanceType,")
        append("portInfoSource=$portInfoSource,")
        append("sourceName=$sourceName,")
        append("userData=$userData)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (portInfoSource?.hashCode() ?: 0)
        result = 31 * result + (sourceName?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceEntry

        if (availabilityZone != other.availabilityZone) return false
        if (instanceType != other.instanceType) return false
        if (portInfoSource != other.portInfoSource) return false
        if (sourceName != other.sourceName) return false
        if (userData != other.userData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.InstanceEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Availability Zone for the new Amazon EC2 instance.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The instance type (e.g., `t2.micro`) to use for the new Amazon EC2 instance.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The port configuration to use for the new Amazon EC2 instance.
         *
         * The following configuration options are available:
         * + `DEFAULT` - Use the default firewall settings from the Lightsail instance blueprint. If this is specified, then IPv4 and IPv6 will be configured for the new instance that is created in Amazon EC2.
         * + `INSTANCE` - Use the configured firewall settings from the source Lightsail instance. If this is specified, the new instance that is created in Amazon EC2 will be configured to match the configuration of the source Lightsail instance. For example, if the source instance is configured for dual-stack (IPv4 and IPv6), then IPv4 and IPv6 will be configured for the new instance that is created in Amazon EC2. If the source instance is configured for IPv4 only, then only IPv4 will be configured for the new instance that is created in Amazon EC2.
         * + `NONE` - Use the default Amazon EC2 security group. If this is specified, then only IPv4 will be configured for the new instance that is created in Amazon EC2.
         * + `CLOSED` - All ports closed. If this is specified, then only IPv4 will be configured for the new instance that is created in Amazon EC2.
         *
         * If you configured `lightsail-connect` as a `cidrListAliases` on your instance, or if you chose to allow the Lightsail browser-based SSH or RDP clients to connect to your instance, that configuration is not carried over to your new Amazon EC2 instance.
         */
        public var portInfoSource: aws.sdk.kotlin.services.lightsail.model.PortInfoSourceType? = null
        /**
         * The name of the export snapshot record, which contains the exported Lightsail instance snapshot that will be used as the source of the new Amazon EC2 instance.
         *
         * Use the `get export snapshot records` operation to get a list of export snapshot records that you can use to create a CloudFormation stack.
         */
        public var sourceName: kotlin.String? = null
        /**
         * A launch script you can create that configures a server with additional user data. For example, you might want to run `apt-get -y update`.
         *
         * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and CentOS use `yum`, Debian and Ubuntu use `apt-get`, and FreeBSD uses `pkg`.
         */
        public var userData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.InstanceEntry) : this() {
            this.availabilityZone = x.availabilityZone
            this.instanceType = x.instanceType
            this.portInfoSource = x.portInfoSource
            this.sourceName = x.sourceName
            this.userData = x.userData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.InstanceEntry = InstanceEntry(this)
    }
}
