// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes information about ports for an Amazon Lightsail instance.
 */
public class InstancePortInfo private constructor(builder: Builder) {
    /**
     * The access direction (`inbound` or `outbound`).
     *
     * Lightsail currently supports only `inbound` access direction.
     */
    public val accessDirection: aws.sdk.kotlin.services.lightsail.model.AccessDirection? = builder.accessDirection
    /**
     * The location from which access is allowed. For example, `Anywhere (0.0.0.0/0)`, or `Custom` if a specific IP address or range of IP addresses is allowed.
     */
    public val accessFrom: kotlin.String? = builder.accessFrom
    /**
     * The type of access (`Public` or `Private`).
     */
    public val accessType: aws.sdk.kotlin.services.lightsail.model.PortAccessType? = builder.accessType
    /**
     * An alias that defines access for a preconfigured range of IP addresses.
     *
     * The only alias currently supported is `lightsail-connect`, which allows IP addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your instance.
     */
    public val cidrListAliases: List<String>? = builder.cidrListAliases
    /**
     * The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol.
     *
     * The `ipv6Cidrs` parameter lists the IPv6 addresses that are allowed to connect to an instance.
     *
     * For more information about CIDR block notation, see [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation) on *Wikipedia*.
     */
    public val cidrs: List<String>? = builder.cidrs
    /**
     * The common name of the port information.
     */
    public val commonName: kotlin.String? = builder.commonName
    /**
     * The first port in a range of open ports on an instance.
     *
     * Allowed ports:
     * + TCP and UDP - `0` to `65535`
     * + ICMP - The ICMP type for IPv4 addresses. For example, specify `8` as the `fromPort` (ICMP type), and `-1` as the `toPort` (ICMP code), to enable ICMP Ping. For more information, see [Control Messages](https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages) on *Wikipedia*.
     * + ICMPv6 - The ICMP type for IPv6 addresses. For example, specify `128` as the `fromPort` (ICMPv6 type), and `0` as `toPort` (ICMPv6 code). For more information, see [Internet Control Message Protocol for IPv6](https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6).
     */
    public val fromPort: kotlin.Int = builder.fromPort
    /**
     * The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol. Only devices with an IPv6 address can connect to an instance through IPv6; otherwise, IPv4 should be used.
     *
     * The `cidrs` parameter lists the IPv4 addresses that are allowed to connect to an instance.
     *
     * For more information about CIDR block notation, see [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation) on *Wikipedia*.
     */
    public val ipv6Cidrs: List<String>? = builder.ipv6Cidrs
    /**
     * The IP protocol name.
     *
     * The name can be one of the following:
     * + `tcp` - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery of streamed data between applications running on hosts communicating by an IP network. If you have an application that doesn't require reliable data stream service, use UDP instead.
     * + `all` - All transport layer protocol types. For more general information, see [Transport layer](https://en.wikipedia.org/wiki/Transport_layer) on *Wikipedia*.
     * + `udp` - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up transmission channels or data paths. Applications that don't require reliable data stream service can use UDP, which provides a connectionless datagram service that emphasizes reduced latency over reliability. If you do require reliable data stream service, use TCP instead.
     * + `icmp` - Internet Control Message Protocol (ICMP) is used to send error messages and operational information indicating success or failure when communicating with an instance. For example, an error is indicated when an instance could not be reached. When you specify `icmp` as the `protocol`, you must specify the ICMP type using the `fromPort` parameter, and ICMP code using the `toPort` parameter.
     */
    public val protocol: aws.sdk.kotlin.services.lightsail.model.NetworkProtocol? = builder.protocol
    /**
     * The last port in a range of open ports on an instance.
     *
     * Allowed ports:
     * + TCP and UDP - `0` to `65535`
     * + ICMP - The ICMP code for IPv4 addresses. For example, specify `8` as the `fromPort` (ICMP type), and `-1` as the `toPort` (ICMP code), to enable ICMP Ping. For more information, see [Control Messages](https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages) on *Wikipedia*.
     * + ICMPv6 - The ICMP code for IPv6 addresses. For example, specify `128` as the `fromPort` (ICMPv6 type), and `0` as `toPort` (ICMPv6 code). For more information, see [Internet Control Message Protocol for IPv6](https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6).
     */
    public val toPort: kotlin.Int = builder.toPort

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.InstancePortInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstancePortInfo(")
        append("accessDirection=$accessDirection,")
        append("accessFrom=$accessFrom,")
        append("accessType=$accessType,")
        append("cidrListAliases=$cidrListAliases,")
        append("cidrs=$cidrs,")
        append("commonName=$commonName,")
        append("fromPort=$fromPort,")
        append("ipv6Cidrs=$ipv6Cidrs,")
        append("protocol=$protocol,")
        append("toPort=$toPort)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessDirection?.hashCode() ?: 0
        result = 31 * result + (accessFrom?.hashCode() ?: 0)
        result = 31 * result + (accessType?.hashCode() ?: 0)
        result = 31 * result + (cidrListAliases?.hashCode() ?: 0)
        result = 31 * result + (cidrs?.hashCode() ?: 0)
        result = 31 * result + (commonName?.hashCode() ?: 0)
        result = 31 * result + (fromPort)
        result = 31 * result + (ipv6Cidrs?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (toPort)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstancePortInfo

        if (accessDirection != other.accessDirection) return false
        if (accessFrom != other.accessFrom) return false
        if (accessType != other.accessType) return false
        if (cidrListAliases != other.cidrListAliases) return false
        if (cidrs != other.cidrs) return false
        if (commonName != other.commonName) return false
        if (fromPort != other.fromPort) return false
        if (ipv6Cidrs != other.ipv6Cidrs) return false
        if (protocol != other.protocol) return false
        if (toPort != other.toPort) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.InstancePortInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The access direction (`inbound` or `outbound`).
         *
         * Lightsail currently supports only `inbound` access direction.
         */
        public var accessDirection: aws.sdk.kotlin.services.lightsail.model.AccessDirection? = null
        /**
         * The location from which access is allowed. For example, `Anywhere (0.0.0.0/0)`, or `Custom` if a specific IP address or range of IP addresses is allowed.
         */
        public var accessFrom: kotlin.String? = null
        /**
         * The type of access (`Public` or `Private`).
         */
        public var accessType: aws.sdk.kotlin.services.lightsail.model.PortAccessType? = null
        /**
         * An alias that defines access for a preconfigured range of IP addresses.
         *
         * The only alias currently supported is `lightsail-connect`, which allows IP addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your instance.
         */
        public var cidrListAliases: List<String>? = null
        /**
         * The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol.
         *
         * The `ipv6Cidrs` parameter lists the IPv6 addresses that are allowed to connect to an instance.
         *
         * For more information about CIDR block notation, see [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation) on *Wikipedia*.
         */
        public var cidrs: List<String>? = null
        /**
         * The common name of the port information.
         */
        public var commonName: kotlin.String? = null
        /**
         * The first port in a range of open ports on an instance.
         *
         * Allowed ports:
         * + TCP and UDP - `0` to `65535`
         * + ICMP - The ICMP type for IPv4 addresses. For example, specify `8` as the `fromPort` (ICMP type), and `-1` as the `toPort` (ICMP code), to enable ICMP Ping. For more information, see [Control Messages](https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages) on *Wikipedia*.
         * + ICMPv6 - The ICMP type for IPv6 addresses. For example, specify `128` as the `fromPort` (ICMPv6 type), and `0` as `toPort` (ICMPv6 code). For more information, see [Internet Control Message Protocol for IPv6](https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6).
         */
        public var fromPort: kotlin.Int = 0
        /**
         * The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol. Only devices with an IPv6 address can connect to an instance through IPv6; otherwise, IPv4 should be used.
         *
         * The `cidrs` parameter lists the IPv4 addresses that are allowed to connect to an instance.
         *
         * For more information about CIDR block notation, see [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation) on *Wikipedia*.
         */
        public var ipv6Cidrs: List<String>? = null
        /**
         * The IP protocol name.
         *
         * The name can be one of the following:
         * + `tcp` - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery of streamed data between applications running on hosts communicating by an IP network. If you have an application that doesn't require reliable data stream service, use UDP instead.
         * + `all` - All transport layer protocol types. For more general information, see [Transport layer](https://en.wikipedia.org/wiki/Transport_layer) on *Wikipedia*.
         * + `udp` - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up transmission channels or data paths. Applications that don't require reliable data stream service can use UDP, which provides a connectionless datagram service that emphasizes reduced latency over reliability. If you do require reliable data stream service, use TCP instead.
         * + `icmp` - Internet Control Message Protocol (ICMP) is used to send error messages and operational information indicating success or failure when communicating with an instance. For example, an error is indicated when an instance could not be reached. When you specify `icmp` as the `protocol`, you must specify the ICMP type using the `fromPort` parameter, and ICMP code using the `toPort` parameter.
         */
        public var protocol: aws.sdk.kotlin.services.lightsail.model.NetworkProtocol? = null
        /**
         * The last port in a range of open ports on an instance.
         *
         * Allowed ports:
         * + TCP and UDP - `0` to `65535`
         * + ICMP - The ICMP code for IPv4 addresses. For example, specify `8` as the `fromPort` (ICMP type), and `-1` as the `toPort` (ICMP code), to enable ICMP Ping. For more information, see [Control Messages](https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages) on *Wikipedia*.
         * + ICMPv6 - The ICMP code for IPv6 addresses. For example, specify `128` as the `fromPort` (ICMPv6 type), and `0` as `toPort` (ICMPv6 code). For more information, see [Internet Control Message Protocol for IPv6](https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6).
         */
        public var toPort: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.InstancePortInfo) : this() {
            this.accessDirection = x.accessDirection
            this.accessFrom = x.accessFrom
            this.accessType = x.accessType
            this.cidrListAliases = x.cidrListAliases
            this.cidrs = x.cidrs
            this.commonName = x.commonName
            this.fromPort = x.fromPort
            this.ipv6Cidrs = x.ipv6Cidrs
            this.protocol = x.protocol
            this.toPort = x.toPort
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.InstancePortInfo = InstancePortInfo(this)
    }
}
