// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon Lightsail content delivery network (CDN) distribution.
 */
public class LightsailDistribution private constructor(builder: Builder) {
    /**
     * Indicates whether the bundle that is currently applied to your distribution, specified using the `distributionName` parameter, can be changed to another bundle.
     *
     * Use the `UpdateDistributionBundle` action to change your distribution's bundle.
     */
    public val ableToUpdateBundle: kotlin.Boolean? = builder.ableToUpdateBundle
    /**
     * The alternate domain names of the distribution.
     */
    public val alternativeDomainNames: List<String>? = builder.alternativeDomainNames
    /**
     * The Amazon Resource Name (ARN) of the distribution.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The ID of the bundle currently applied to the distribution.
     */
    public val bundleId: kotlin.String? = builder.bundleId
    /**
     * An object that describes the cache behavior settings of the distribution.
     */
    public val cacheBehaviorSettings: aws.sdk.kotlin.services.lightsail.model.CacheSettings? = builder.cacheBehaviorSettings
    /**
     * An array of objects that describe the per-path cache behavior of the distribution.
     */
    public val cacheBehaviors: List<CacheBehaviorPerPath>? = builder.cacheBehaviors
    /**
     * The name of the SSL/TLS certificate attached to the distribution, if any.
     */
    public val certificateName: kotlin.String? = builder.certificateName
    /**
     * The timestamp when the distribution was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An object that describes the default cache behavior of the distribution.
     */
    public val defaultCacheBehavior: aws.sdk.kotlin.services.lightsail.model.CacheBehavior? = builder.defaultCacheBehavior
    /**
     * The domain name of the distribution.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The IP address type of the distribution.
     *
     * The possible values are `ipv4` for IPv4 only, and `dualstack` for IPv4 and IPv6.
     */
    public val ipAddressType: aws.sdk.kotlin.services.lightsail.model.IpAddressType? = builder.ipAddressType
    /**
     * Indicates whether the distribution is enabled.
     */
    public val isEnabled: kotlin.Boolean? = builder.isEnabled
    /**
     * An object that describes the location of the distribution, such as the Amazon Web Services Region and Availability Zone.
     *
     * Lightsail distributions are global resources that can reference an origin in any Amazon Web Services Region, and distribute its content globally. However, all distributions are located in the `us-east-1` Region.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The name of the distribution.
     */
    public val name: kotlin.String? = builder.name
    /**
     * An object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer.
     *
     * The distribution pulls, caches, and serves content from the origin.
     */
    public val origin: aws.sdk.kotlin.services.lightsail.model.Origin? = builder.origin
    /**
     * The public DNS of the origin.
     */
    public val originPublicDns: kotlin.String? = builder.originPublicDns
    /**
     * The Lightsail resource type (e.g., `Distribution`).
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * The status of the distribution.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The support code. Include this code in your email to support when you have questions about your Lightsail distribution. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode
    /**
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.LightsailDistribution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LightsailDistribution(")
        append("ableToUpdateBundle=$ableToUpdateBundle,")
        append("alternativeDomainNames=$alternativeDomainNames,")
        append("arn=$arn,")
        append("bundleId=$bundleId,")
        append("cacheBehaviorSettings=$cacheBehaviorSettings,")
        append("cacheBehaviors=$cacheBehaviors,")
        append("certificateName=$certificateName,")
        append("createdAt=$createdAt,")
        append("defaultCacheBehavior=$defaultCacheBehavior,")
        append("domainName=$domainName,")
        append("ipAddressType=$ipAddressType,")
        append("isEnabled=$isEnabled,")
        append("location=$location,")
        append("name=$name,")
        append("origin=$origin,")
        append("originPublicDns=$originPublicDns,")
        append("resourceType=$resourceType,")
        append("status=$status,")
        append("supportCode=$supportCode,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ableToUpdateBundle?.hashCode() ?: 0
        result = 31 * result + (alternativeDomainNames?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (bundleId?.hashCode() ?: 0)
        result = 31 * result + (cacheBehaviorSettings?.hashCode() ?: 0)
        result = 31 * result + (cacheBehaviors?.hashCode() ?: 0)
        result = 31 * result + (certificateName?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (defaultCacheBehavior?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (isEnabled?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (origin?.hashCode() ?: 0)
        result = 31 * result + (originPublicDns?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LightsailDistribution

        if (ableToUpdateBundle != other.ableToUpdateBundle) return false
        if (alternativeDomainNames != other.alternativeDomainNames) return false
        if (arn != other.arn) return false
        if (bundleId != other.bundleId) return false
        if (cacheBehaviorSettings != other.cacheBehaviorSettings) return false
        if (cacheBehaviors != other.cacheBehaviors) return false
        if (certificateName != other.certificateName) return false
        if (createdAt != other.createdAt) return false
        if (defaultCacheBehavior != other.defaultCacheBehavior) return false
        if (domainName != other.domainName) return false
        if (ipAddressType != other.ipAddressType) return false
        if (isEnabled != other.isEnabled) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (origin != other.origin) return false
        if (originPublicDns != other.originPublicDns) return false
        if (resourceType != other.resourceType) return false
        if (status != other.status) return false
        if (supportCode != other.supportCode) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.LightsailDistribution = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the bundle that is currently applied to your distribution, specified using the `distributionName` parameter, can be changed to another bundle.
         *
         * Use the `UpdateDistributionBundle` action to change your distribution's bundle.
         */
        public var ableToUpdateBundle: kotlin.Boolean? = null
        /**
         * The alternate domain names of the distribution.
         */
        public var alternativeDomainNames: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the distribution.
         */
        public var arn: kotlin.String? = null
        /**
         * The ID of the bundle currently applied to the distribution.
         */
        public var bundleId: kotlin.String? = null
        /**
         * An object that describes the cache behavior settings of the distribution.
         */
        public var cacheBehaviorSettings: aws.sdk.kotlin.services.lightsail.model.CacheSettings? = null
        /**
         * An array of objects that describe the per-path cache behavior of the distribution.
         */
        public var cacheBehaviors: List<CacheBehaviorPerPath>? = null
        /**
         * The name of the SSL/TLS certificate attached to the distribution, if any.
         */
        public var certificateName: kotlin.String? = null
        /**
         * The timestamp when the distribution was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that describes the default cache behavior of the distribution.
         */
        public var defaultCacheBehavior: aws.sdk.kotlin.services.lightsail.model.CacheBehavior? = null
        /**
         * The domain name of the distribution.
         */
        public var domainName: kotlin.String? = null
        /**
         * The IP address type of the distribution.
         *
         * The possible values are `ipv4` for IPv4 only, and `dualstack` for IPv4 and IPv6.
         */
        public var ipAddressType: aws.sdk.kotlin.services.lightsail.model.IpAddressType? = null
        /**
         * Indicates whether the distribution is enabled.
         */
        public var isEnabled: kotlin.Boolean? = null
        /**
         * An object that describes the location of the distribution, such as the Amazon Web Services Region and Availability Zone.
         *
         * Lightsail distributions are global resources that can reference an origin in any Amazon Web Services Region, and distribute its content globally. However, all distributions are located in the `us-east-1` Region.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The name of the distribution.
         */
        public var name: kotlin.String? = null
        /**
         * An object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer.
         *
         * The distribution pulls, caches, and serves content from the origin.
         */
        public var origin: aws.sdk.kotlin.services.lightsail.model.Origin? = null
        /**
         * The public DNS of the origin.
         */
        public var originPublicDns: kotlin.String? = null
        /**
         * The Lightsail resource type (e.g., `Distribution`).
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * The status of the distribution.
         */
        public var status: kotlin.String? = null
        /**
         * The support code. Include this code in your email to support when you have questions about your Lightsail distribution. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null
        /**
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.LightsailDistribution) : this() {
            this.ableToUpdateBundle = x.ableToUpdateBundle
            this.alternativeDomainNames = x.alternativeDomainNames
            this.arn = x.arn
            this.bundleId = x.bundleId
            this.cacheBehaviorSettings = x.cacheBehaviorSettings
            this.cacheBehaviors = x.cacheBehaviors
            this.certificateName = x.certificateName
            this.createdAt = x.createdAt
            this.defaultCacheBehavior = x.defaultCacheBehavior
            this.domainName = x.domainName
            this.ipAddressType = x.ipAddressType
            this.isEnabled = x.isEnabled
            this.location = x.location
            this.name = x.name
            this.origin = x.origin
            this.originPublicDns = x.originPublicDns
            this.resourceType = x.resourceType
            this.status = x.status
            this.supportCode = x.supportCode
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.LightsailDistribution = LightsailDistribution(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.CacheSettings] inside the given [block]
         */
        public fun cacheBehaviorSettings(block: aws.sdk.kotlin.services.lightsail.model.CacheSettings.Builder.() -> kotlin.Unit) {
            this.cacheBehaviorSettings = aws.sdk.kotlin.services.lightsail.model.CacheSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.CacheBehavior] inside the given [block]
         */
        public fun defaultCacheBehavior(block: aws.sdk.kotlin.services.lightsail.model.CacheBehavior.Builder.() -> kotlin.Unit) {
            this.defaultCacheBehavior = aws.sdk.kotlin.services.lightsail.model.CacheBehavior.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.Origin] inside the given [block]
         */
        public fun origin(block: aws.sdk.kotlin.services.lightsail.model.Origin.Builder.() -> kotlin.Unit) {
            this.origin = aws.sdk.kotlin.services.lightsail.model.Origin.invoke(block)
        }
    }
}
