// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a load balancer.
 */
public class LoadBalancer private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the load balancer.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A string to string map of the configuration options for your load balancer. Valid values are listed below.
     */
    public val configurationOptions: Map<String, String>? = builder.configurationOptions
    /**
     * The date when your load balancer was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The DNS name of your Lightsail load balancer.
     */
    public val dnsName: kotlin.String? = builder.dnsName
    /**
     * The path you specified to perform your health checks. If no path is specified, the load balancer tries to make a request to the default (root) page.
     */
    public val healthCheckPath: kotlin.String? = builder.healthCheckPath
    /**
     * A Boolean value that indicates whether HTTPS redirection is enabled for the load balancer.
     */
    public val httpsRedirectionEnabled: kotlin.Boolean? = builder.httpsRedirectionEnabled
    /**
     * An array of InstanceHealthSummary objects describing the health of the load balancer.
     */
    public val instanceHealthSummary: List<InstanceHealthSummary>? = builder.instanceHealthSummary
    /**
     * The port where the load balancer will direct traffic to your Lightsail instances. For HTTP traffic, it's port 80. For HTTPS traffic, it's port 443.
     */
    public val instancePort: kotlin.Int? = builder.instancePort
    /**
     * The IP address type of the load balancer.
     *
     * The possible values are `ipv4` for IPv4 only, and `dualstack` for IPv4 and IPv6.
     */
    public val ipAddressType: aws.sdk.kotlin.services.lightsail.model.IpAddressType? = builder.ipAddressType
    /**
     * The AWS Region where your load balancer was created (e.g., `us-east-2a`). Lightsail automatically creates your load balancer across Availability Zones.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The name of the load balancer (e.g., `my-load-balancer`).
     */
    public val name: kotlin.String? = builder.name
    /**
     * The protocol you have enabled for your load balancer. Valid values are below.
     *
     * You can't just have `HTTP_HTTPS`, but you can have just `HTTP`.
     */
    public val protocol: aws.sdk.kotlin.services.lightsail.model.LoadBalancerProtocol? = builder.protocol
    /**
     * An array of public port settings for your load balancer. For HTTP, use port 80. For HTTPS, use port 443.
     */
    public val publicPorts: List<Int>? = builder.publicPorts
    /**
     * The resource type (e.g., `LoadBalancer`.
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * The status of your load balancer. Valid values are below.
     */
    public val state: aws.sdk.kotlin.services.lightsail.model.LoadBalancerState? = builder.state
    /**
     * The support code. Include this code in your email to support when you have questions about your Lightsail load balancer. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode
    /**
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * An array of LoadBalancerTlsCertificateSummary objects that provide additional information about the SSL/TLS certificates. For example, if `true`, the certificate is attached to the load balancer.
     */
    public val tlsCertificateSummaries: List<LoadBalancerTlsCertificateSummary>? = builder.tlsCertificateSummaries
    /**
     * The name of the TLS security policy for the load balancer.
     */
    public val tlsPolicyName: kotlin.String? = builder.tlsPolicyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.LoadBalancer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoadBalancer(")
        append("arn=$arn,")
        append("configurationOptions=$configurationOptions,")
        append("createdAt=$createdAt,")
        append("dnsName=$dnsName,")
        append("healthCheckPath=$healthCheckPath,")
        append("httpsRedirectionEnabled=$httpsRedirectionEnabled,")
        append("instanceHealthSummary=$instanceHealthSummary,")
        append("instancePort=$instancePort,")
        append("ipAddressType=$ipAddressType,")
        append("location=$location,")
        append("name=$name,")
        append("protocol=$protocol,")
        append("publicPorts=$publicPorts,")
        append("resourceType=$resourceType,")
        append("state=$state,")
        append("supportCode=$supportCode,")
        append("tags=$tags,")
        append("tlsCertificateSummaries=$tlsCertificateSummaries,")
        append("tlsPolicyName=$tlsPolicyName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (configurationOptions?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (healthCheckPath?.hashCode() ?: 0)
        result = 31 * result + (httpsRedirectionEnabled?.hashCode() ?: 0)
        result = 31 * result + (instanceHealthSummary?.hashCode() ?: 0)
        result = 31 * result + (instancePort ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (publicPorts?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tlsCertificateSummaries?.hashCode() ?: 0)
        result = 31 * result + (tlsPolicyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoadBalancer

        if (arn != other.arn) return false
        if (configurationOptions != other.configurationOptions) return false
        if (createdAt != other.createdAt) return false
        if (dnsName != other.dnsName) return false
        if (healthCheckPath != other.healthCheckPath) return false
        if (httpsRedirectionEnabled != other.httpsRedirectionEnabled) return false
        if (instanceHealthSummary != other.instanceHealthSummary) return false
        if (instancePort != other.instancePort) return false
        if (ipAddressType != other.ipAddressType) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (protocol != other.protocol) return false
        if (publicPorts != other.publicPorts) return false
        if (resourceType != other.resourceType) return false
        if (state != other.state) return false
        if (supportCode != other.supportCode) return false
        if (tags != other.tags) return false
        if (tlsCertificateSummaries != other.tlsCertificateSummaries) return false
        if (tlsPolicyName != other.tlsPolicyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.LoadBalancer = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the load balancer.
         */
        public var arn: kotlin.String? = null
        /**
         * A string to string map of the configuration options for your load balancer. Valid values are listed below.
         */
        public var configurationOptions: Map<String, String>? = null
        /**
         * The date when your load balancer was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The DNS name of your Lightsail load balancer.
         */
        public var dnsName: kotlin.String? = null
        /**
         * The path you specified to perform your health checks. If no path is specified, the load balancer tries to make a request to the default (root) page.
         */
        public var healthCheckPath: kotlin.String? = null
        /**
         * A Boolean value that indicates whether HTTPS redirection is enabled for the load balancer.
         */
        public var httpsRedirectionEnabled: kotlin.Boolean? = null
        /**
         * An array of InstanceHealthSummary objects describing the health of the load balancer.
         */
        public var instanceHealthSummary: List<InstanceHealthSummary>? = null
        /**
         * The port where the load balancer will direct traffic to your Lightsail instances. For HTTP traffic, it's port 80. For HTTPS traffic, it's port 443.
         */
        public var instancePort: kotlin.Int? = null
        /**
         * The IP address type of the load balancer.
         *
         * The possible values are `ipv4` for IPv4 only, and `dualstack` for IPv4 and IPv6.
         */
        public var ipAddressType: aws.sdk.kotlin.services.lightsail.model.IpAddressType? = null
        /**
         * The AWS Region where your load balancer was created (e.g., `us-east-2a`). Lightsail automatically creates your load balancer across Availability Zones.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The name of the load balancer (e.g., `my-load-balancer`).
         */
        public var name: kotlin.String? = null
        /**
         * The protocol you have enabled for your load balancer. Valid values are below.
         *
         * You can't just have `HTTP_HTTPS`, but you can have just `HTTP`.
         */
        public var protocol: aws.sdk.kotlin.services.lightsail.model.LoadBalancerProtocol? = null
        /**
         * An array of public port settings for your load balancer. For HTTP, use port 80. For HTTPS, use port 443.
         */
        public var publicPorts: List<Int>? = null
        /**
         * The resource type (e.g., `LoadBalancer`.
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * The status of your load balancer. Valid values are below.
         */
        public var state: aws.sdk.kotlin.services.lightsail.model.LoadBalancerState? = null
        /**
         * The support code. Include this code in your email to support when you have questions about your Lightsail load balancer. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null
        /**
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null
        /**
         * An array of LoadBalancerTlsCertificateSummary objects that provide additional information about the SSL/TLS certificates. For example, if `true`, the certificate is attached to the load balancer.
         */
        public var tlsCertificateSummaries: List<LoadBalancerTlsCertificateSummary>? = null
        /**
         * The name of the TLS security policy for the load balancer.
         */
        public var tlsPolicyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.LoadBalancer) : this() {
            this.arn = x.arn
            this.configurationOptions = x.configurationOptions
            this.createdAt = x.createdAt
            this.dnsName = x.dnsName
            this.healthCheckPath = x.healthCheckPath
            this.httpsRedirectionEnabled = x.httpsRedirectionEnabled
            this.instanceHealthSummary = x.instanceHealthSummary
            this.instancePort = x.instancePort
            this.ipAddressType = x.ipAddressType
            this.location = x.location
            this.name = x.name
            this.protocol = x.protocol
            this.publicPorts = x.publicPorts
            this.resourceType = x.resourceType
            this.state = x.state
            this.supportCode = x.supportCode
            this.tags = x.tags
            this.tlsCertificateSummaries = x.tlsCertificateSummaries
            this.tlsPolicyName = x.tlsPolicyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.LoadBalancer = LoadBalancer(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }
    }
}
