// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes a database bundle. A bundle describes the performance specifications of the database.
 */
public class RelationalDatabaseBundle private constructor(builder: Builder) {
    /**
     * The ID for the database bundle.
     */
    public val bundleId: kotlin.String? = builder.bundleId
    /**
     * The number of virtual CPUs (vCPUs) for the database bundle.
     */
    public val cpuCount: kotlin.Int? = builder.cpuCount
    /**
     * The size of the disk for the database bundle.
     */
    public val diskSizeInGb: kotlin.Int? = builder.diskSizeInGb
    /**
     * A Boolean value indicating whether the database bundle is active.
     */
    public val isActive: kotlin.Boolean? = builder.isActive
    /**
     * A Boolean value indicating whether the database bundle is encrypted.
     */
    public val isEncrypted: kotlin.Boolean? = builder.isEncrypted
    /**
     * The name for the database bundle.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The cost of the database bundle in US currency.
     */
    public val price: kotlin.Float? = builder.price
    /**
     * The amount of RAM in GB (for example, `2.0`) for the database bundle.
     */
    public val ramSizeInGb: kotlin.Float? = builder.ramSizeInGb
    /**
     * The data transfer rate per month in GB for the database bundle.
     */
    public val transferPerMonthInGb: kotlin.Int? = builder.transferPerMonthInGb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseBundle = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RelationalDatabaseBundle(")
        append("bundleId=$bundleId,")
        append("cpuCount=$cpuCount,")
        append("diskSizeInGb=$diskSizeInGb,")
        append("isActive=$isActive,")
        append("isEncrypted=$isEncrypted,")
        append("name=$name,")
        append("price=$price,")
        append("ramSizeInGb=$ramSizeInGb,")
        append("transferPerMonthInGb=$transferPerMonthInGb)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bundleId?.hashCode() ?: 0
        result = 31 * result + (cpuCount ?: 0)
        result = 31 * result + (diskSizeInGb ?: 0)
        result = 31 * result + (isActive?.hashCode() ?: 0)
        result = 31 * result + (isEncrypted?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (price?.hashCode() ?: 0)
        result = 31 * result + (ramSizeInGb?.hashCode() ?: 0)
        result = 31 * result + (transferPerMonthInGb ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RelationalDatabaseBundle

        if (bundleId != other.bundleId) return false
        if (cpuCount != other.cpuCount) return false
        if (diskSizeInGb != other.diskSizeInGb) return false
        if (isActive != other.isActive) return false
        if (isEncrypted != other.isEncrypted) return false
        if (name != other.name) return false
        if (price != other.price) return false
        if (ramSizeInGb != other.ramSizeInGb) return false
        if (transferPerMonthInGb != other.transferPerMonthInGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseBundle = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID for the database bundle.
         */
        public var bundleId: kotlin.String? = null
        /**
         * The number of virtual CPUs (vCPUs) for the database bundle.
         */
        public var cpuCount: kotlin.Int? = null
        /**
         * The size of the disk for the database bundle.
         */
        public var diskSizeInGb: kotlin.Int? = null
        /**
         * A Boolean value indicating whether the database bundle is active.
         */
        public var isActive: kotlin.Boolean? = null
        /**
         * A Boolean value indicating whether the database bundle is encrypted.
         */
        public var isEncrypted: kotlin.Boolean? = null
        /**
         * The name for the database bundle.
         */
        public var name: kotlin.String? = null
        /**
         * The cost of the database bundle in US currency.
         */
        public var price: kotlin.Float? = null
        /**
         * The amount of RAM in GB (for example, `2.0`) for the database bundle.
         */
        public var ramSizeInGb: kotlin.Float? = null
        /**
         * The data transfer rate per month in GB for the database bundle.
         */
        public var transferPerMonthInGb: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseBundle) : this() {
            this.bundleId = x.bundleId
            this.cpuCount = x.cpuCount
            this.diskSizeInGb = x.diskSizeInGb
            this.isActive = x.isActive
            this.isEncrypted = x.isEncrypted
            this.name = x.name
            this.price = x.price
            this.ramSizeInGb = x.ramSizeInGb
            this.transferPerMonthInGb = x.transferPerMonthInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseBundle = RelationalDatabaseBundle(this)
    }
}
