// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lightsail.model.GetInstancePortStatesResponse
import aws.sdk.kotlin.services.lightsail.model.InstancePortState
import aws.sdk.kotlin.services.lightsail.model.LightsailException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetInstancePortStatesOperationDeserializer: HttpDeserialize<GetInstancePortStatesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetInstancePortStatesResponse {
        if (!response.status.isSuccess()) {
            throwGetInstancePortStatesError(context, response)
        }
        val builder = GetInstancePortStatesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetInstancePortStatesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetInstancePortStatesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LightsailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AccountSetupInProgressException" -> AccountSetupInProgressExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationFailureException" -> OperationFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthenticatedException" -> UnauthenticatedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LightsailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetInstancePortStatesOperationBody(builder: GetInstancePortStatesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PORTSTATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("portStates"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PORTSTATES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PORTSTATES_DESCRIPTOR.index -> builder.portStates =
                    deserializer.deserializeList(PORTSTATES_DESCRIPTOR) {
                        val col0 = mutableListOf<InstancePortState>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInstancePortStateDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
