// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes an add-on that is enabled for an Amazon Lightsail resource.
 */
public class AddOn private constructor(builder: Builder) {
    /**
     * The name of the add-on.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The next daily time an automatic snapshot will be created.
     *
     * The time shown is in `HH:00` format, and in Coordinated Universal Time (UTC).
     *
     * The snapshot is automatically created between the time shown and up to 45 minutes after.
     */
    public val nextSnapshotTimeOfDay: kotlin.String? = builder.nextSnapshotTimeOfDay
    /**
     * The daily time when an automatic snapshot is created.
     *
     * The time shown is in `HH:00` format, and in Coordinated Universal Time (UTC).
     *
     * The snapshot is automatically created between the time shown and up to 45 minutes after.
     */
    public val snapshotTimeOfDay: kotlin.String? = builder.snapshotTimeOfDay
    /**
     * The status of the add-on.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.AddOn = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddOn(")
        append("name=$name,")
        append("nextSnapshotTimeOfDay=$nextSnapshotTimeOfDay,")
        append("snapshotTimeOfDay=$snapshotTimeOfDay,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (nextSnapshotTimeOfDay?.hashCode() ?: 0)
        result = 31 * result + (snapshotTimeOfDay?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddOn

        if (name != other.name) return false
        if (nextSnapshotTimeOfDay != other.nextSnapshotTimeOfDay) return false
        if (snapshotTimeOfDay != other.snapshotTimeOfDay) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.AddOn = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the add-on.
         */
        public var name: kotlin.String? = null
        /**
         * The next daily time an automatic snapshot will be created.
         *
         * The time shown is in `HH:00` format, and in Coordinated Universal Time (UTC).
         *
         * The snapshot is automatically created between the time shown and up to 45 minutes after.
         */
        public var nextSnapshotTimeOfDay: kotlin.String? = null
        /**
         * The daily time when an automatic snapshot is created.
         *
         * The time shown is in `HH:00` format, and in Coordinated Universal Time (UTC).
         *
         * The snapshot is automatically created between the time shown and up to 45 minutes after.
         */
        public var snapshotTimeOfDay: kotlin.String? = null
        /**
         * The status of the add-on.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.AddOn) : this() {
            this.name = x.name
            this.nextSnapshotTimeOfDay = x.nextSnapshotTimeOfDay
            this.snapshotTimeOfDay = x.snapshotTimeOfDay
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.AddOn = AddOn(this)
    }
}
