// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon Lightsail bucket.
 */
public class Bucket private constructor(builder: Builder) {
    /**
     * Indicates whether the bundle that is currently applied to a bucket can be changed to another bundle.
     *
     * You can update a bucket's bundle only one time within a monthly Amazon Web Services billing cycle.
     *
     * Use the [UpdateBucketBundle](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateBucketBundle.html) action to change a bucket's bundle.
     */
    public val ableToUpdateBundle: kotlin.Boolean? = builder.ableToUpdateBundle
    /**
     * An object that describes the access log configuration for the bucket.
     */
    public val accessLogConfig: aws.sdk.kotlin.services.lightsail.model.BucketAccessLogConfig? = builder.accessLogConfig
    /**
     * An object that describes the access rules of the bucket.
     */
    public val accessRules: aws.sdk.kotlin.services.lightsail.model.AccessRules? = builder.accessRules
    /**
     * The Amazon Resource Name (ARN) of the bucket.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The ID of the bundle currently applied to the bucket.
     *
     * A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket.
     *
     * Use the [UpdateBucketBundle](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateBucketBundle.html) action to change the bundle of a bucket.
     */
    public val bundleId: kotlin.String? = builder.bundleId
    /**
     * The timestamp when the distribution was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An object that describes the location of the bucket, such as the Amazon Web Services Region and Availability Zone.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The name of the bucket.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates whether object versioning is enabled for the bucket.
     *
     * The following options can be configured:
     * + `Enabled` - Object versioning is enabled.
     * + `Suspended` - Object versioning was previously enabled but is currently suspended. Existing object versions are retained.
     * + `NeverEnabled` - Object versioning has never been enabled.
     */
    public val objectVersioning: kotlin.String? = builder.objectVersioning
    /**
     * An array of strings that specify the Amazon Web Services account IDs that have read-only access to the bucket.
     */
    public val readonlyAccessAccounts: List<String>? = builder.readonlyAccessAccounts
    /**
     * The Lightsail resource type of the bucket (for example, `Bucket`).
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * An array of objects that describe Lightsail instances that have access to the bucket.
     *
     * Use the [SetResourceAccessForBucket](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html) action to update the instances that have access to a bucket.
     */
    public val resourcesReceivingAccess: List<ResourceReceivingAccess>? = builder.resourcesReceivingAccess
    /**
     * An object that describes the state of the bucket.
     */
    public val state: aws.sdk.kotlin.services.lightsail.model.BucketState? = builder.state
    /**
     * The support code for a bucket. Include this code in your email to support when you have questions about a Lightsail bucket. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode
    /**
     * The tag keys and optional values for the bucket. For more information, see [Tags in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags) in the *Amazon Lightsail Developer Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The URL of the bucket.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.Bucket = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Bucket(")
        append("ableToUpdateBundle=$ableToUpdateBundle,")
        append("accessLogConfig=$accessLogConfig,")
        append("accessRules=$accessRules,")
        append("arn=$arn,")
        append("bundleId=$bundleId,")
        append("createdAt=$createdAt,")
        append("location=$location,")
        append("name=$name,")
        append("objectVersioning=$objectVersioning,")
        append("readonlyAccessAccounts=$readonlyAccessAccounts,")
        append("resourceType=$resourceType,")
        append("resourcesReceivingAccess=$resourcesReceivingAccess,")
        append("state=$state,")
        append("supportCode=$supportCode,")
        append("tags=$tags,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ableToUpdateBundle?.hashCode() ?: 0
        result = 31 * result + (accessLogConfig?.hashCode() ?: 0)
        result = 31 * result + (accessRules?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (bundleId?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (objectVersioning?.hashCode() ?: 0)
        result = 31 * result + (readonlyAccessAccounts?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (resourcesReceivingAccess?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Bucket

        if (ableToUpdateBundle != other.ableToUpdateBundle) return false
        if (accessLogConfig != other.accessLogConfig) return false
        if (accessRules != other.accessRules) return false
        if (arn != other.arn) return false
        if (bundleId != other.bundleId) return false
        if (createdAt != other.createdAt) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (objectVersioning != other.objectVersioning) return false
        if (readonlyAccessAccounts != other.readonlyAccessAccounts) return false
        if (resourceType != other.resourceType) return false
        if (resourcesReceivingAccess != other.resourcesReceivingAccess) return false
        if (state != other.state) return false
        if (supportCode != other.supportCode) return false
        if (tags != other.tags) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.Bucket = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the bundle that is currently applied to a bucket can be changed to another bundle.
         *
         * You can update a bucket's bundle only one time within a monthly Amazon Web Services billing cycle.
         *
         * Use the [UpdateBucketBundle](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateBucketBundle.html) action to change a bucket's bundle.
         */
        public var ableToUpdateBundle: kotlin.Boolean? = null
        /**
         * An object that describes the access log configuration for the bucket.
         */
        public var accessLogConfig: aws.sdk.kotlin.services.lightsail.model.BucketAccessLogConfig? = null
        /**
         * An object that describes the access rules of the bucket.
         */
        public var accessRules: aws.sdk.kotlin.services.lightsail.model.AccessRules? = null
        /**
         * The Amazon Resource Name (ARN) of the bucket.
         */
        public var arn: kotlin.String? = null
        /**
         * The ID of the bundle currently applied to the bucket.
         *
         * A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket.
         *
         * Use the [UpdateBucketBundle](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateBucketBundle.html) action to change the bundle of a bucket.
         */
        public var bundleId: kotlin.String? = null
        /**
         * The timestamp when the distribution was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that describes the location of the bucket, such as the Amazon Web Services Region and Availability Zone.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The name of the bucket.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates whether object versioning is enabled for the bucket.
         *
         * The following options can be configured:
         * + `Enabled` - Object versioning is enabled.
         * + `Suspended` - Object versioning was previously enabled but is currently suspended. Existing object versions are retained.
         * + `NeverEnabled` - Object versioning has never been enabled.
         */
        public var objectVersioning: kotlin.String? = null
        /**
         * An array of strings that specify the Amazon Web Services account IDs that have read-only access to the bucket.
         */
        public var readonlyAccessAccounts: List<String>? = null
        /**
         * The Lightsail resource type of the bucket (for example, `Bucket`).
         */
        public var resourceType: kotlin.String? = null
        /**
         * An array of objects that describe Lightsail instances that have access to the bucket.
         *
         * Use the [SetResourceAccessForBucket](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html) action to update the instances that have access to a bucket.
         */
        public var resourcesReceivingAccess: List<ResourceReceivingAccess>? = null
        /**
         * An object that describes the state of the bucket.
         */
        public var state: aws.sdk.kotlin.services.lightsail.model.BucketState? = null
        /**
         * The support code for a bucket. Include this code in your email to support when you have questions about a Lightsail bucket. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null
        /**
         * The tag keys and optional values for the bucket. For more information, see [Tags in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags) in the *Amazon Lightsail Developer Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * The URL of the bucket.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.Bucket) : this() {
            this.ableToUpdateBundle = x.ableToUpdateBundle
            this.accessLogConfig = x.accessLogConfig
            this.accessRules = x.accessRules
            this.arn = x.arn
            this.bundleId = x.bundleId
            this.createdAt = x.createdAt
            this.location = x.location
            this.name = x.name
            this.objectVersioning = x.objectVersioning
            this.readonlyAccessAccounts = x.readonlyAccessAccounts
            this.resourceType = x.resourceType
            this.resourcesReceivingAccess = x.resourcesReceivingAccess
            this.state = x.state
            this.supportCode = x.supportCode
            this.tags = x.tags
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.Bucket = Bucket(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.BucketAccessLogConfig] inside the given [block]
         */
        public fun accessLogConfig(block: aws.sdk.kotlin.services.lightsail.model.BucketAccessLogConfig.Builder.() -> kotlin.Unit) {
            this.accessLogConfig = aws.sdk.kotlin.services.lightsail.model.BucketAccessLogConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.AccessRules] inside the given [block]
         */
        public fun accessRules(block: aws.sdk.kotlin.services.lightsail.model.AccessRules.Builder.() -> kotlin.Unit) {
            this.accessRules = aws.sdk.kotlin.services.lightsail.model.AccessRules.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.BucketState] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.lightsail.model.BucketState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.lightsail.model.BucketState.invoke(block)
        }
    }
}
