// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the state of an Amazon Lightsail bucket.
 */
public class BucketState private constructor(builder: Builder) {
    /**
     * The state code of the bucket.
     *
     * The following codes are possible:
     * + `OK` - The bucket is in a running state.
     * + `Unknown` - Creation of the bucket might have timed-out. You might want to delete the bucket and create a new one.
     */
    public val code: kotlin.String? = builder.code
    /**
     * A message that describes the state of the bucket.
     */
    public val message: kotlin.String? = builder.message

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.BucketState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BucketState(")
        append("code=$code,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BucketState

        if (code != other.code) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.BucketState = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The state code of the bucket.
         *
         * The following codes are possible:
         * + `OK` - The bucket is in a running state.
         * + `Unknown` - Creation of the bucket might have timed-out. You might want to delete the bucket and create a new one.
         */
        public var code: kotlin.String? = null
        /**
         * A message that describes the state of the bucket.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.BucketState) : this() {
            this.code = x.code
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.BucketState = BucketState(this)
    }
}
