// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the cache settings of an Amazon Lightsail content delivery network (CDN) distribution.
 *
 * These settings apply only to your distribution's `cacheBehaviors` (including the `defaultCacheBehavior`) that have a `behavior` of `cache`.
 */
public class CacheSettings private constructor(builder: Builder) {
    /**
     * The HTTP methods that are processed and forwarded to the distribution's origin.
     *
     * You can specify the following options:
     * + `GET,HEAD` - The distribution forwards the `GET` and `HEAD` methods.
     * + `GET,HEAD,OPTIONS` - The distribution forwards the `GET`, `HEAD`, and `OPTIONS` methods.
     * + `GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE` - The distribution forwards the `GET`, `HEAD`, `OPTIONS`, `PUT`, `PATCH`, `POST`, and `DELETE` methods.
     *
     * If you specify the third option, you might need to restrict access to your distribution's origin so users can't perform operations that you don't want them to. For example, you might not want users to have permission to delete objects from your origin.
     */
    public val allowedHttpMethods: kotlin.String? = builder.allowedHttpMethods
    /**
     * The HTTP method responses that are cached by your distribution.
     *
     * You can specify the following options:
     * + `GET,HEAD` - The distribution caches responses to the `GET` and `HEAD` methods.
     * + `GET,HEAD,OPTIONS` - The distribution caches responses to the `GET`, `HEAD`, and `OPTIONS` methods.
     */
    public val cachedHttpMethods: kotlin.String? = builder.cachedHttpMethods
    /**
     * The default amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the content has been updated.
     *
     * The value specified applies only when the origin does not add HTTP headers such as `Cache-Control max-age`, `Cache-Control s-maxage`, and `Expires` to objects.
     */
    public val defaultTtl: kotlin.Long? = builder.defaultTtl
    /**
     * An object that describes the cookies that are forwarded to the origin. Your content is cached based on the cookies that are forwarded.
     */
    public val forwardedCookies: aws.sdk.kotlin.services.lightsail.model.CookieObject? = builder.forwardedCookies
    /**
     * An object that describes the headers that are forwarded to the origin. Your content is cached based on the headers that are forwarded.
     */
    public val forwardedHeaders: aws.sdk.kotlin.services.lightsail.model.HeaderObject? = builder.forwardedHeaders
    /**
     * An object that describes the query strings that are forwarded to the origin. Your content is cached based on the query strings that are forwarded.
     */
    public val forwardedQueryStrings: aws.sdk.kotlin.services.lightsail.model.QueryStringObject? = builder.forwardedQueryStrings
    /**
     * The maximum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
     *
     * The value specified applies only when the origin adds HTTP headers such as `Cache-Control max-age`, `Cache-Control s-maxage`, and `Expires` to objects.
     */
    public val maximumTtl: kotlin.Long? = builder.maximumTtl
    /**
     * The minimum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
     *
     * A value of `0` must be specified for `minimumTTL` if the distribution is configured to forward all headers to the origin.
     */
    public val minimumTtl: kotlin.Long? = builder.minimumTtl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CacheSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CacheSettings(")
        append("allowedHttpMethods=$allowedHttpMethods,")
        append("cachedHttpMethods=$cachedHttpMethods,")
        append("defaultTtl=$defaultTtl,")
        append("forwardedCookies=$forwardedCookies,")
        append("forwardedHeaders=$forwardedHeaders,")
        append("forwardedQueryStrings=$forwardedQueryStrings,")
        append("maximumTtl=$maximumTtl,")
        append("minimumTtl=$minimumTtl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedHttpMethods?.hashCode() ?: 0
        result = 31 * result + (cachedHttpMethods?.hashCode() ?: 0)
        result = 31 * result + (defaultTtl?.hashCode() ?: 0)
        result = 31 * result + (forwardedCookies?.hashCode() ?: 0)
        result = 31 * result + (forwardedHeaders?.hashCode() ?: 0)
        result = 31 * result + (forwardedQueryStrings?.hashCode() ?: 0)
        result = 31 * result + (maximumTtl?.hashCode() ?: 0)
        result = 31 * result + (minimumTtl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CacheSettings

        if (allowedHttpMethods != other.allowedHttpMethods) return false
        if (cachedHttpMethods != other.cachedHttpMethods) return false
        if (defaultTtl != other.defaultTtl) return false
        if (forwardedCookies != other.forwardedCookies) return false
        if (forwardedHeaders != other.forwardedHeaders) return false
        if (forwardedQueryStrings != other.forwardedQueryStrings) return false
        if (maximumTtl != other.maximumTtl) return false
        if (minimumTtl != other.minimumTtl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CacheSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The HTTP methods that are processed and forwarded to the distribution's origin.
         *
         * You can specify the following options:
         * + `GET,HEAD` - The distribution forwards the `GET` and `HEAD` methods.
         * + `GET,HEAD,OPTIONS` - The distribution forwards the `GET`, `HEAD`, and `OPTIONS` methods.
         * + `GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE` - The distribution forwards the `GET`, `HEAD`, `OPTIONS`, `PUT`, `PATCH`, `POST`, and `DELETE` methods.
         *
         * If you specify the third option, you might need to restrict access to your distribution's origin so users can't perform operations that you don't want them to. For example, you might not want users to have permission to delete objects from your origin.
         */
        public var allowedHttpMethods: kotlin.String? = null
        /**
         * The HTTP method responses that are cached by your distribution.
         *
         * You can specify the following options:
         * + `GET,HEAD` - The distribution caches responses to the `GET` and `HEAD` methods.
         * + `GET,HEAD,OPTIONS` - The distribution caches responses to the `GET`, `HEAD`, and `OPTIONS` methods.
         */
        public var cachedHttpMethods: kotlin.String? = null
        /**
         * The default amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the content has been updated.
         *
         * The value specified applies only when the origin does not add HTTP headers such as `Cache-Control max-age`, `Cache-Control s-maxage`, and `Expires` to objects.
         */
        public var defaultTtl: kotlin.Long? = null
        /**
         * An object that describes the cookies that are forwarded to the origin. Your content is cached based on the cookies that are forwarded.
         */
        public var forwardedCookies: aws.sdk.kotlin.services.lightsail.model.CookieObject? = null
        /**
         * An object that describes the headers that are forwarded to the origin. Your content is cached based on the headers that are forwarded.
         */
        public var forwardedHeaders: aws.sdk.kotlin.services.lightsail.model.HeaderObject? = null
        /**
         * An object that describes the query strings that are forwarded to the origin. Your content is cached based on the query strings that are forwarded.
         */
        public var forwardedQueryStrings: aws.sdk.kotlin.services.lightsail.model.QueryStringObject? = null
        /**
         * The maximum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
         *
         * The value specified applies only when the origin adds HTTP headers such as `Cache-Control max-age`, `Cache-Control s-maxage`, and `Expires` to objects.
         */
        public var maximumTtl: kotlin.Long? = null
        /**
         * The minimum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
         *
         * A value of `0` must be specified for `minimumTTL` if the distribution is configured to forward all headers to the origin.
         */
        public var minimumTtl: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CacheSettings) : this() {
            this.allowedHttpMethods = x.allowedHttpMethods
            this.cachedHttpMethods = x.cachedHttpMethods
            this.defaultTtl = x.defaultTtl
            this.forwardedCookies = x.forwardedCookies
            this.forwardedHeaders = x.forwardedHeaders
            this.forwardedQueryStrings = x.forwardedQueryStrings
            this.maximumTtl = x.maximumTtl
            this.minimumTtl = x.minimumTtl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CacheSettings = CacheSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.CookieObject] inside the given [block]
         */
        public fun forwardedCookies(block: aws.sdk.kotlin.services.lightsail.model.CookieObject.Builder.() -> kotlin.Unit) {
            this.forwardedCookies = aws.sdk.kotlin.services.lightsail.model.CookieObject.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.HeaderObject] inside the given [block]
         */
        public fun forwardedHeaders(block: aws.sdk.kotlin.services.lightsail.model.HeaderObject.Builder.() -> kotlin.Unit) {
            this.forwardedHeaders = aws.sdk.kotlin.services.lightsail.model.HeaderObject.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.QueryStringObject] inside the given [block]
         */
        public fun forwardedQueryStrings(block: aws.sdk.kotlin.services.lightsail.model.QueryStringObject.Builder.() -> kotlin.Unit) {
            this.forwardedQueryStrings = aws.sdk.kotlin.services.lightsail.model.QueryStringObject.invoke(block)
        }
    }
}
