// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the full details of an Amazon Lightsail SSL/TLS certificate.
 *
 * To get a summary of a certificate, use the `GetCertificates` action and ommit `includeCertificateDetails` from your request. The response will include only the certificate Amazon Resource Name (ARN), certificate name, domain name, and tags.
 */
public class Certificate private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the certificate.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The timestamp when the certificate was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The domain name of the certificate.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * An array of objects that describe the domain validation records of the certificate.
     */
    public val domainValidationRecords: List<DomainValidationRecord>? = builder.domainValidationRecords
    /**
     * The renewal eligibility of the certificate.
     */
    public val eligibleToRenew: kotlin.String? = builder.eligibleToRenew
    /**
     * The number of Lightsail resources that the certificate is attached to.
     */
    public val inUseResourceCount: kotlin.Int = builder.inUseResourceCount
    /**
     * The timestamp when the certificate was issued.
     */
    public val issuedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.issuedAt
    /**
     * The certificate authority that issued the certificate.
     */
    public val issuerCa: kotlin.String? = builder.issuerCa
    /**
     * The algorithm used to generate the key pair (the public and private key) of the certificate.
     */
    public val keyAlgorithm: kotlin.String? = builder.keyAlgorithm
    /**
     * The name of the certificate (e.g., `my-certificate`).
     */
    public val name: kotlin.String? = builder.name
    /**
     * The timestamp when the certificate expires.
     */
    public val notAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.notAfter
    /**
     * The timestamp when the certificate is first valid.
     */
    public val notBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.notBefore
    /**
     * An object that describes the status of the certificate renewal managed by Lightsail.
     */
    public val renewalSummary: aws.sdk.kotlin.services.lightsail.model.RenewalSummary? = builder.renewalSummary
    /**
     * The validation failure reason, if any, of the certificate.
     *
     * The following failure reasons are possible:
     * + **`NO_AVAILABLE_CONTACTS`** - This failure applies to email validation, which is not available for Lightsail certificates.
     * + **`ADDITIONAL_VERIFICATION_REQUIRED`** - Lightsail requires additional information to process this certificate request. This can happen as a fraud-protection measure, such as when the domain ranks within the Alexa top 1000 websites. To provide the required information, use the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/home) to contact Amazon Web Services Support.You cannot request a certificate for Amazon-owned domain names such as those ending in amazonaws.com, cloudfront.net, or elasticbeanstalk.com.
     * + **`DOMAIN_NOT_ALLOWED`** - One or more of the domain names in the certificate request was reported as an unsafe domain by [VirusTotal](https://www.virustotal.com/gui/home/url). To correct the problem, search for your domain name on the [VirusTotal](https://www.virustotal.com/gui/home/url) website. If your domain is reported as suspicious, see [Google Help for Hacked Websites](https://developers.google.com/web/fundamentals/security/hacked) to learn what you can do.If you believe that the result is a false positive, notify the organization that is reporting the domain. VirusTotal is an aggregate of several antivirus and URL scanners and cannot remove your domain from a block list itself. After you correct the problem and the VirusTotal registry has been updated, request a new certificate.If you see this error and your domain is not included in the VirusTotal list, visit the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/home) and create a case.
     * + **`INVALID_PUBLIC_DOMAIN`** - One or more of the domain names in the certificate request is not valid. Typically, this is because a domain name in the request is not a valid top-level domain. Try to request a certificate again, correcting any spelling errors or typos that were in the failed request, and ensure that all domain names in the request are for valid top-level domains. For example, you cannot request a certificate for `example.invalidpublicdomain` because `invalidpublicdomain` is not a valid top-level domain.
     * + **`OTHER`** - Typically, this failure occurs when there is a typographical error in one or more of the domain names in the certificate request. Try to request a certificate again, correcting any spelling errors or typos that were in the failed request.
     */
    public val requestFailureReason: kotlin.String? = builder.requestFailureReason
    /**
     * The reason the certificate was revoked. This value is present only when the certificate status is `REVOKED`.
     */
    public val revocationReason: kotlin.String? = builder.revocationReason
    /**
     * The timestamp when the certificate was revoked. This value is present only when the certificate status is `REVOKED`.
     */
    public val revokedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.revokedAt
    /**
     * The serial number of the certificate.
     */
    public val serialNumber: kotlin.String? = builder.serialNumber
    /**
     * The validation status of the certificate.
     */
    public val status: aws.sdk.kotlin.services.lightsail.model.CertificateStatus? = builder.status
    /**
     * An array of strings that specify the alternate domains (e.g., `example2.com`) and subdomains (e.g., `blog.example.com`) of the certificate.
     */
    public val subjectAlternativeNames: List<String>? = builder.subjectAlternativeNames
    /**
     * The support code. Include this code in your email to support when you have questions about your Lightsail certificate. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode
    /**
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.Certificate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Certificate(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("domainName=$domainName,")
        append("domainValidationRecords=$domainValidationRecords,")
        append("eligibleToRenew=$eligibleToRenew,")
        append("inUseResourceCount=$inUseResourceCount,")
        append("issuedAt=$issuedAt,")
        append("issuerCa=$issuerCa,")
        append("keyAlgorithm=$keyAlgorithm,")
        append("name=$name,")
        append("notAfter=$notAfter,")
        append("notBefore=$notBefore,")
        append("renewalSummary=$renewalSummary,")
        append("requestFailureReason=$requestFailureReason,")
        append("revocationReason=$revocationReason,")
        append("revokedAt=$revokedAt,")
        append("serialNumber=$serialNumber,")
        append("status=$status,")
        append("subjectAlternativeNames=$subjectAlternativeNames,")
        append("supportCode=$supportCode,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainValidationRecords?.hashCode() ?: 0)
        result = 31 * result + (eligibleToRenew?.hashCode() ?: 0)
        result = 31 * result + (inUseResourceCount)
        result = 31 * result + (issuedAt?.hashCode() ?: 0)
        result = 31 * result + (issuerCa?.hashCode() ?: 0)
        result = 31 * result + (keyAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notAfter?.hashCode() ?: 0)
        result = 31 * result + (notBefore?.hashCode() ?: 0)
        result = 31 * result + (renewalSummary?.hashCode() ?: 0)
        result = 31 * result + (requestFailureReason?.hashCode() ?: 0)
        result = 31 * result + (revocationReason?.hashCode() ?: 0)
        result = 31 * result + (revokedAt?.hashCode() ?: 0)
        result = 31 * result + (serialNumber?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subjectAlternativeNames?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Certificate

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (domainName != other.domainName) return false
        if (domainValidationRecords != other.domainValidationRecords) return false
        if (eligibleToRenew != other.eligibleToRenew) return false
        if (inUseResourceCount != other.inUseResourceCount) return false
        if (issuedAt != other.issuedAt) return false
        if (issuerCa != other.issuerCa) return false
        if (keyAlgorithm != other.keyAlgorithm) return false
        if (name != other.name) return false
        if (notAfter != other.notAfter) return false
        if (notBefore != other.notBefore) return false
        if (renewalSummary != other.renewalSummary) return false
        if (requestFailureReason != other.requestFailureReason) return false
        if (revocationReason != other.revocationReason) return false
        if (revokedAt != other.revokedAt) return false
        if (serialNumber != other.serialNumber) return false
        if (status != other.status) return false
        if (subjectAlternativeNames != other.subjectAlternativeNames) return false
        if (supportCode != other.supportCode) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.Certificate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the certificate.
         */
        public var arn: kotlin.String? = null
        /**
         * The timestamp when the certificate was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The domain name of the certificate.
         */
        public var domainName: kotlin.String? = null
        /**
         * An array of objects that describe the domain validation records of the certificate.
         */
        public var domainValidationRecords: List<DomainValidationRecord>? = null
        /**
         * The renewal eligibility of the certificate.
         */
        public var eligibleToRenew: kotlin.String? = null
        /**
         * The number of Lightsail resources that the certificate is attached to.
         */
        public var inUseResourceCount: kotlin.Int = 0
        /**
         * The timestamp when the certificate was issued.
         */
        public var issuedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The certificate authority that issued the certificate.
         */
        public var issuerCa: kotlin.String? = null
        /**
         * The algorithm used to generate the key pair (the public and private key) of the certificate.
         */
        public var keyAlgorithm: kotlin.String? = null
        /**
         * The name of the certificate (e.g., `my-certificate`).
         */
        public var name: kotlin.String? = null
        /**
         * The timestamp when the certificate expires.
         */
        public var notAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp when the certificate is first valid.
         */
        public var notBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that describes the status of the certificate renewal managed by Lightsail.
         */
        public var renewalSummary: aws.sdk.kotlin.services.lightsail.model.RenewalSummary? = null
        /**
         * The validation failure reason, if any, of the certificate.
         *
         * The following failure reasons are possible:
         * + **`NO_AVAILABLE_CONTACTS`** - This failure applies to email validation, which is not available for Lightsail certificates.
         * + **`ADDITIONAL_VERIFICATION_REQUIRED`** - Lightsail requires additional information to process this certificate request. This can happen as a fraud-protection measure, such as when the domain ranks within the Alexa top 1000 websites. To provide the required information, use the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/home) to contact Amazon Web Services Support.You cannot request a certificate for Amazon-owned domain names such as those ending in amazonaws.com, cloudfront.net, or elasticbeanstalk.com.
         * + **`DOMAIN_NOT_ALLOWED`** - One or more of the domain names in the certificate request was reported as an unsafe domain by [VirusTotal](https://www.virustotal.com/gui/home/url). To correct the problem, search for your domain name on the [VirusTotal](https://www.virustotal.com/gui/home/url) website. If your domain is reported as suspicious, see [Google Help for Hacked Websites](https://developers.google.com/web/fundamentals/security/hacked) to learn what you can do.If you believe that the result is a false positive, notify the organization that is reporting the domain. VirusTotal is an aggregate of several antivirus and URL scanners and cannot remove your domain from a block list itself. After you correct the problem and the VirusTotal registry has been updated, request a new certificate.If you see this error and your domain is not included in the VirusTotal list, visit the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/home) and create a case.
         * + **`INVALID_PUBLIC_DOMAIN`** - One or more of the domain names in the certificate request is not valid. Typically, this is because a domain name in the request is not a valid top-level domain. Try to request a certificate again, correcting any spelling errors or typos that were in the failed request, and ensure that all domain names in the request are for valid top-level domains. For example, you cannot request a certificate for `example.invalidpublicdomain` because `invalidpublicdomain` is not a valid top-level domain.
         * + **`OTHER`** - Typically, this failure occurs when there is a typographical error in one or more of the domain names in the certificate request. Try to request a certificate again, correcting any spelling errors or typos that were in the failed request.
         */
        public var requestFailureReason: kotlin.String? = null
        /**
         * The reason the certificate was revoked. This value is present only when the certificate status is `REVOKED`.
         */
        public var revocationReason: kotlin.String? = null
        /**
         * The timestamp when the certificate was revoked. This value is present only when the certificate status is `REVOKED`.
         */
        public var revokedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The serial number of the certificate.
         */
        public var serialNumber: kotlin.String? = null
        /**
         * The validation status of the certificate.
         */
        public var status: aws.sdk.kotlin.services.lightsail.model.CertificateStatus? = null
        /**
         * An array of strings that specify the alternate domains (e.g., `example2.com`) and subdomains (e.g., `blog.example.com`) of the certificate.
         */
        public var subjectAlternativeNames: List<String>? = null
        /**
         * The support code. Include this code in your email to support when you have questions about your Lightsail certificate. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null
        /**
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.Certificate) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.domainName = x.domainName
            this.domainValidationRecords = x.domainValidationRecords
            this.eligibleToRenew = x.eligibleToRenew
            this.inUseResourceCount = x.inUseResourceCount
            this.issuedAt = x.issuedAt
            this.issuerCa = x.issuerCa
            this.keyAlgorithm = x.keyAlgorithm
            this.name = x.name
            this.notAfter = x.notAfter
            this.notBefore = x.notBefore
            this.renewalSummary = x.renewalSummary
            this.requestFailureReason = x.requestFailureReason
            this.revocationReason = x.revocationReason
            this.revokedAt = x.revokedAt
            this.serialNumber = x.serialNumber
            this.status = x.status
            this.subjectAlternativeNames = x.subjectAlternativeNames
            this.supportCode = x.supportCode
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.Certificate = Certificate(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.RenewalSummary] inside the given [block]
         */
        public fun renewalSummary(block: aws.sdk.kotlin.services.lightsail.model.RenewalSummary.Builder.() -> kotlin.Unit) {
            this.renewalSummary = aws.sdk.kotlin.services.lightsail.model.RenewalSummary.invoke(block)
        }
    }
}
