// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a contact method.
 *
 * A contact method is a way to send you notifications. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
 */
public class ContactMethod private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the contact method.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The destination of the contact method, such as an email address or a mobile phone number.
     */
    public val contactEndpoint: kotlin.String? = builder.contactEndpoint
    /**
     * The timestamp when the contact method was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An object that describes the location of the contact method, such as the Amazon Web Services Region and Availability Zone.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The name of the contact method.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The protocol of the contact method, such as email or SMS (text messaging).
     */
    public val protocol: aws.sdk.kotlin.services.lightsail.model.ContactProtocol? = builder.protocol
    /**
     * The Lightsail resource type (e.g., `ContactMethod`).
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * The current status of the contact method.
     *
     * A contact method has the following possible status:
     * + `PendingVerification` - The contact method has not yet been verified, and the verification has not yet expired.
     * + `Valid` - The contact method has been verified.
     * + `InValid` - An attempt was made to verify the contact method, but the verification has expired.
     */
    public val status: aws.sdk.kotlin.services.lightsail.model.ContactMethodStatus? = builder.status
    /**
     * The support code. Include this code in your email to support when you have questions about your Lightsail contact method. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.ContactMethod = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContactMethod(")
        append("arn=$arn,")
        append("contactEndpoint=$contactEndpoint,")
        append("createdAt=$createdAt,")
        append("location=$location,")
        append("name=$name,")
        append("protocol=$protocol,")
        append("resourceType=$resourceType,")
        append("status=$status,")
        append("supportCode=$supportCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (contactEndpoint?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContactMethod

        if (arn != other.arn) return false
        if (contactEndpoint != other.contactEndpoint) return false
        if (createdAt != other.createdAt) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (protocol != other.protocol) return false
        if (resourceType != other.resourceType) return false
        if (status != other.status) return false
        if (supportCode != other.supportCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.ContactMethod = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the contact method.
         */
        public var arn: kotlin.String? = null
        /**
         * The destination of the contact method, such as an email address or a mobile phone number.
         */
        public var contactEndpoint: kotlin.String? = null
        /**
         * The timestamp when the contact method was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that describes the location of the contact method, such as the Amazon Web Services Region and Availability Zone.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The name of the contact method.
         */
        public var name: kotlin.String? = null
        /**
         * The protocol of the contact method, such as email or SMS (text messaging).
         */
        public var protocol: aws.sdk.kotlin.services.lightsail.model.ContactProtocol? = null
        /**
         * The Lightsail resource type (e.g., `ContactMethod`).
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * The current status of the contact method.
         *
         * A contact method has the following possible status:
         * + `PendingVerification` - The contact method has not yet been verified, and the verification has not yet expired.
         * + `Valid` - The contact method has been verified.
         * + `InValid` - An attempt was made to verify the contact method, but the verification has expired.
         */
        public var status: aws.sdk.kotlin.services.lightsail.model.ContactMethodStatus? = null
        /**
         * The support code. Include this code in your email to support when you have questions about your Lightsail contact method. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.ContactMethod) : this() {
            this.arn = x.arn
            this.contactEndpoint = x.contactEndpoint
            this.createdAt = x.createdAt
            this.location = x.location
            this.name = x.name
            this.protocol = x.protocol
            this.resourceType = x.resourceType
            this.status = x.status
            this.supportCode = x.supportCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.ContactMethod = ContactMethod(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }
    }
}
