// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon Lightsail container service.
 */
public class ContainerService private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the container service.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The name of the container service.
     */
    public val containerServiceName: kotlin.String? = builder.containerServiceName
    /**
     * The timestamp when the container service was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An object that describes the current container deployment of the container service.
     */
    public val currentDeployment: aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeployment? = builder.currentDeployment
    /**
     * A Boolean value indicating whether the container service is disabled.
     */
    public val isDisabled: kotlin.Boolean? = builder.isDisabled
    /**
     * An object that describes the location of the container service, such as the Amazon Web Services Region and Availability Zone.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * An object that describes the next deployment of the container service.
     *
     * This value is `null` when there is no deployment in a `pending` state.
     */
    public val nextDeployment: aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeployment? = builder.nextDeployment
    /**
     * The power specification of the container service.
     *
     * The power specifies the amount of RAM, the number of vCPUs, and the base price of the container service.
     */
    public val power: aws.sdk.kotlin.services.lightsail.model.ContainerServicePowerName? = builder.power
    /**
     * The ID of the power of the container service.
     */
    public val powerId: kotlin.String? = builder.powerId
    /**
     * The principal ARN of the container service.
     *
     * The principal ARN can be used to create a trust relationship between your standard Amazon Web Services account and your Lightsail container service. This allows you to give your service permission to access resources in your standard Amazon Web Services account.
     */
    public val principalArn: kotlin.String? = builder.principalArn
    /**
     * The private domain name of the container service.
     *
     * The private domain name is accessible only by other resources within the default virtual private cloud (VPC) of your Lightsail account.
     */
    public val privateDomainName: kotlin.String? = builder.privateDomainName
    /**
     * An object that describes the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories.
     *
     * For more information, see [Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access) in the *Amazon Lightsail Developer Guide*.
     */
    public val privateRegistryAccess: aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccess? = builder.privateRegistryAccess
    /**
     * The public domain name of the container service, such as `example.com` and `www.example.com`.
     *
     * You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service.
     *
     * If you don't specify public domain names, then you can use the default domain of the container service.
     *
     * You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the `CreateCertificate` action to create a certificate for the public domain names you want to use with your container service.
     *
     * See `CreateContainerService` or `UpdateContainerService` for information about how to specify public domain names for your Lightsail container service.
     */
    public val publicDomainNames: Map<String, List<String>>? = builder.publicDomainNames
    /**
     * The Lightsail resource type of the container service (i.e., `ContainerService`).
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * The scale specification of the container service.
     *
     * The scale specifies the allocated compute nodes of the container service.
     */
    public val scale: kotlin.Int? = builder.scale
    /**
     * The current state of the container service.
     *
     * The following container service states are possible:
     * + `PENDING` - The container service is being created.
     * + `READY` - The container service is running but it does not have an active container deployment.
     * + `DEPLOYING` - The container service is launching a container deployment.
     * + `RUNNING` - The container service is running and it has an active container deployment.
     * + `UPDATING` - The container service capacity or its custom domains are being updated.
     * + `DELETING` - The container service is being deleted.
     * + `DISABLED` - The container service is disabled, and its active deployment and containers, if any, are shut down.
     */
    public val state: aws.sdk.kotlin.services.lightsail.model.ContainerServiceState? = builder.state
    /**
     * An object that describes the current state of the container service.
     *
     * The state detail is populated only when a container service is in a `PENDING`, `DEPLOYING`, or `UPDATING` state.
     */
    public val stateDetail: aws.sdk.kotlin.services.lightsail.model.ContainerServiceStateDetail? = builder.stateDetail
    /**
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The publicly accessible URL of the container service.
     *
     * If no public endpoint is specified in the `currentDeployment`, this URL returns a 404 response.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.ContainerService = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerService(")
        append("arn=$arn,")
        append("containerServiceName=$containerServiceName,")
        append("createdAt=$createdAt,")
        append("currentDeployment=$currentDeployment,")
        append("isDisabled=$isDisabled,")
        append("location=$location,")
        append("nextDeployment=$nextDeployment,")
        append("power=$power,")
        append("powerId=$powerId,")
        append("principalArn=$principalArn,")
        append("privateDomainName=$privateDomainName,")
        append("privateRegistryAccess=$privateRegistryAccess,")
        append("publicDomainNames=$publicDomainNames,")
        append("resourceType=$resourceType,")
        append("scale=$scale,")
        append("state=$state,")
        append("stateDetail=$stateDetail,")
        append("tags=$tags,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (containerServiceName?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (currentDeployment?.hashCode() ?: 0)
        result = 31 * result + (isDisabled?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (nextDeployment?.hashCode() ?: 0)
        result = 31 * result + (power?.hashCode() ?: 0)
        result = 31 * result + (powerId?.hashCode() ?: 0)
        result = 31 * result + (principalArn?.hashCode() ?: 0)
        result = 31 * result + (privateDomainName?.hashCode() ?: 0)
        result = 31 * result + (privateRegistryAccess?.hashCode() ?: 0)
        result = 31 * result + (publicDomainNames?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (scale ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateDetail?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerService

        if (arn != other.arn) return false
        if (containerServiceName != other.containerServiceName) return false
        if (createdAt != other.createdAt) return false
        if (currentDeployment != other.currentDeployment) return false
        if (isDisabled != other.isDisabled) return false
        if (location != other.location) return false
        if (nextDeployment != other.nextDeployment) return false
        if (power != other.power) return false
        if (powerId != other.powerId) return false
        if (principalArn != other.principalArn) return false
        if (privateDomainName != other.privateDomainName) return false
        if (privateRegistryAccess != other.privateRegistryAccess) return false
        if (publicDomainNames != other.publicDomainNames) return false
        if (resourceType != other.resourceType) return false
        if (scale != other.scale) return false
        if (state != other.state) return false
        if (stateDetail != other.stateDetail) return false
        if (tags != other.tags) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.ContainerService = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the container service.
         */
        public var arn: kotlin.String? = null
        /**
         * The name of the container service.
         */
        public var containerServiceName: kotlin.String? = null
        /**
         * The timestamp when the container service was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that describes the current container deployment of the container service.
         */
        public var currentDeployment: aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeployment? = null
        /**
         * A Boolean value indicating whether the container service is disabled.
         */
        public var isDisabled: kotlin.Boolean? = null
        /**
         * An object that describes the location of the container service, such as the Amazon Web Services Region and Availability Zone.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * An object that describes the next deployment of the container service.
         *
         * This value is `null` when there is no deployment in a `pending` state.
         */
        public var nextDeployment: aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeployment? = null
        /**
         * The power specification of the container service.
         *
         * The power specifies the amount of RAM, the number of vCPUs, and the base price of the container service.
         */
        public var power: aws.sdk.kotlin.services.lightsail.model.ContainerServicePowerName? = null
        /**
         * The ID of the power of the container service.
         */
        public var powerId: kotlin.String? = null
        /**
         * The principal ARN of the container service.
         *
         * The principal ARN can be used to create a trust relationship between your standard Amazon Web Services account and your Lightsail container service. This allows you to give your service permission to access resources in your standard Amazon Web Services account.
         */
        public var principalArn: kotlin.String? = null
        /**
         * The private domain name of the container service.
         *
         * The private domain name is accessible only by other resources within the default virtual private cloud (VPC) of your Lightsail account.
         */
        public var privateDomainName: kotlin.String? = null
        /**
         * An object that describes the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories.
         *
         * For more information, see [Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access) in the *Amazon Lightsail Developer Guide*.
         */
        public var privateRegistryAccess: aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccess? = null
        /**
         * The public domain name of the container service, such as `example.com` and `www.example.com`.
         *
         * You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service.
         *
         * If you don't specify public domain names, then you can use the default domain of the container service.
         *
         * You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the `CreateCertificate` action to create a certificate for the public domain names you want to use with your container service.
         *
         * See `CreateContainerService` or `UpdateContainerService` for information about how to specify public domain names for your Lightsail container service.
         */
        public var publicDomainNames: Map<String, List<String>>? = null
        /**
         * The Lightsail resource type of the container service (i.e., `ContainerService`).
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * The scale specification of the container service.
         *
         * The scale specifies the allocated compute nodes of the container service.
         */
        public var scale: kotlin.Int? = null
        /**
         * The current state of the container service.
         *
         * The following container service states are possible:
         * + `PENDING` - The container service is being created.
         * + `READY` - The container service is running but it does not have an active container deployment.
         * + `DEPLOYING` - The container service is launching a container deployment.
         * + `RUNNING` - The container service is running and it has an active container deployment.
         * + `UPDATING` - The container service capacity or its custom domains are being updated.
         * + `DELETING` - The container service is being deleted.
         * + `DISABLED` - The container service is disabled, and its active deployment and containers, if any, are shut down.
         */
        public var state: aws.sdk.kotlin.services.lightsail.model.ContainerServiceState? = null
        /**
         * An object that describes the current state of the container service.
         *
         * The state detail is populated only when a container service is in a `PENDING`, `DEPLOYING`, or `UPDATING` state.
         */
        public var stateDetail: aws.sdk.kotlin.services.lightsail.model.ContainerServiceStateDetail? = null
        /**
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null
        /**
         * The publicly accessible URL of the container service.
         *
         * If no public endpoint is specified in the `currentDeployment`, this URL returns a 404 response.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.ContainerService) : this() {
            this.arn = x.arn
            this.containerServiceName = x.containerServiceName
            this.createdAt = x.createdAt
            this.currentDeployment = x.currentDeployment
            this.isDisabled = x.isDisabled
            this.location = x.location
            this.nextDeployment = x.nextDeployment
            this.power = x.power
            this.powerId = x.powerId
            this.principalArn = x.principalArn
            this.privateDomainName = x.privateDomainName
            this.privateRegistryAccess = x.privateRegistryAccess
            this.publicDomainNames = x.publicDomainNames
            this.resourceType = x.resourceType
            this.scale = x.scale
            this.state = x.state
            this.stateDetail = x.stateDetail
            this.tags = x.tags
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.ContainerService = ContainerService(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeployment] inside the given [block]
         */
        public fun currentDeployment(block: aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeployment.Builder.() -> kotlin.Unit) {
            this.currentDeployment = aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeployment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeployment] inside the given [block]
         */
        public fun nextDeployment(block: aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeployment.Builder.() -> kotlin.Unit) {
            this.nextDeployment = aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeployment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccess] inside the given [block]
         */
        public fun privateRegistryAccess(block: aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccess.Builder.() -> kotlin.Unit) {
            this.privateRegistryAccess = aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccess.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ContainerServiceStateDetail] inside the given [block]
         */
        public fun stateDetail(block: aws.sdk.kotlin.services.lightsail.model.ContainerServiceStateDetail.Builder.() -> kotlin.Unit) {
            this.stateDetail = aws.sdk.kotlin.services.lightsail.model.ContainerServiceStateDetail.invoke(block)
        }
    }
}
