// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the activation status of the role that you can use to grant an Amazon Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
 *
 * When activated, Lightsail creates an Identity and Access Management (IAM) role for the specified Lightsail container service. You can use the ARN of the role to create a trust relationship between your Lightsail container service and an Amazon ECR private repository in your Amazon Web Services account. This allows your container service to pull images from Amazon ECR private repositories. For more information, see [Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access) in the *Amazon Lightsail Developer Guide*.
 */
public class ContainerServiceEcrImagePullerRole private constructor(builder: Builder) {
    /**
     * A Boolean value that indicates whether the role is activated.
     */
    public val isActive: kotlin.Boolean? = builder.isActive
    /**
     * The Amazon Resource Name (ARN) of the role, if it is activated.
     */
    public val principalArn: kotlin.String? = builder.principalArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.ContainerServiceEcrImagePullerRole = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerServiceEcrImagePullerRole(")
        append("isActive=$isActive,")
        append("principalArn=$principalArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isActive?.hashCode() ?: 0
        result = 31 * result + (principalArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerServiceEcrImagePullerRole

        if (isActive != other.isActive) return false
        if (principalArn != other.principalArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.ContainerServiceEcrImagePullerRole = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A Boolean value that indicates whether the role is activated.
         */
        public var isActive: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the role, if it is activated.
         */
        public var principalArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.ContainerServiceEcrImagePullerRole) : this() {
            this.isActive = x.isActive
            this.principalArn = x.principalArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.ContainerServiceEcrImagePullerRole = ContainerServiceEcrImagePullerRole(this)
    }
}
