// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the health check configuration of an Amazon Lightsail container service.
 */
public class ContainerServiceHealthCheckConfig private constructor(builder: Builder) {
    /**
     * The number of consecutive health checks successes required before moving the container to the `Healthy` state. The default value is `2`.
     */
    public val healthyThreshold: kotlin.Int? = builder.healthyThreshold
    /**
     * The approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. The default value is `5`.
     */
    public val intervalSeconds: kotlin.Int? = builder.intervalSeconds
    /**
     * The path on the container on which to perform the health check. The default value is `/`.
     */
    public val path: kotlin.String? = builder.path
    /**
     * The HTTP codes to use when checking for a successful response from a container. You can specify values between `200` and `499`. You can specify multiple values (for example, `200,202`) or a range of values (for example, `200-299`).
     */
    public val successCodes: kotlin.String? = builder.successCodes
    /**
     * The amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. The default value is `2`.
     */
    public val timeoutSeconds: kotlin.Int? = builder.timeoutSeconds
    /**
     * The number of consecutive health check failures required before moving the container to the `Unhealthy` state. The default value is `2`.
     */
    public val unhealthyThreshold: kotlin.Int? = builder.unhealthyThreshold

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.ContainerServiceHealthCheckConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerServiceHealthCheckConfig(")
        append("healthyThreshold=$healthyThreshold,")
        append("intervalSeconds=$intervalSeconds,")
        append("path=$path,")
        append("successCodes=$successCodes,")
        append("timeoutSeconds=$timeoutSeconds,")
        append("unhealthyThreshold=$unhealthyThreshold")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthyThreshold ?: 0
        result = 31 * result + (intervalSeconds ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (successCodes?.hashCode() ?: 0)
        result = 31 * result + (timeoutSeconds ?: 0)
        result = 31 * result + (unhealthyThreshold ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerServiceHealthCheckConfig

        if (healthyThreshold != other.healthyThreshold) return false
        if (intervalSeconds != other.intervalSeconds) return false
        if (path != other.path) return false
        if (successCodes != other.successCodes) return false
        if (timeoutSeconds != other.timeoutSeconds) return false
        if (unhealthyThreshold != other.unhealthyThreshold) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.ContainerServiceHealthCheckConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of consecutive health checks successes required before moving the container to the `Healthy` state. The default value is `2`.
         */
        public var healthyThreshold: kotlin.Int? = null
        /**
         * The approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. The default value is `5`.
         */
        public var intervalSeconds: kotlin.Int? = null
        /**
         * The path on the container on which to perform the health check. The default value is `/`.
         */
        public var path: kotlin.String? = null
        /**
         * The HTTP codes to use when checking for a successful response from a container. You can specify values between `200` and `499`. You can specify multiple values (for example, `200,202`) or a range of values (for example, `200-299`).
         */
        public var successCodes: kotlin.String? = null
        /**
         * The amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. The default value is `2`.
         */
        public var timeoutSeconds: kotlin.Int? = null
        /**
         * The number of consecutive health check failures required before moving the container to the `Unhealthy` state. The default value is `2`.
         */
        public var unhealthyThreshold: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.ContainerServiceHealthCheckConfig) : this() {
            this.healthyThreshold = x.healthyThreshold
            this.intervalSeconds = x.intervalSeconds
            this.path = x.path
            this.successCodes = x.successCodes
            this.timeoutSeconds = x.timeoutSeconds
            this.unhealthyThreshold = x.unhealthyThreshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.ContainerServiceHealthCheckConfig = ContainerServiceHealthCheckConfig(this)
    }
}
