// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class CopySnapshotRequest private constructor(builder: Builder) {
    /**
     * The date of the source automatic snapshot to copy. Use the `get auto snapshots` operation to identify the dates of the available automatic snapshots.
     *
     * Constraints:
     * + Must be specified in `YYYY-MM-DD` format.
     * + This parameter cannot be defined together with the `use latest restorable auto snapshot` parameter. The `restore date` and `use latest restorable auto snapshot` parameters are mutually exclusive.
     * + Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots).
     */
    public val restoreDate: kotlin.String? = builder.restoreDate
    /**
     * The Amazon Web Services Region where the source manual or automatic snapshot is located.
     */
    public val sourceRegion: aws.sdk.kotlin.services.lightsail.model.RegionName? = builder.sourceRegion
    /**
     * The name of the source instance or disk from which the source automatic snapshot was created.
     *
     * Constraint:
     * + Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots).
     */
    public val sourceResourceName: kotlin.String? = builder.sourceResourceName
    /**
     * The name of the source manual snapshot to copy.
     *
     * Constraint:
     * + Define this parameter only when copying a manual snapshot as another manual snapshot.
     */
    public val sourceSnapshotName: kotlin.String? = builder.sourceSnapshotName
    /**
     * The name of the new manual snapshot to be created as a copy.
     */
    public val targetSnapshotName: kotlin.String? = builder.targetSnapshotName
    /**
     * A Boolean value to indicate whether to use the latest available automatic snapshot of the specified source instance or disk.
     *
     * Constraints:
     * + This parameter cannot be defined together with the `restore date` parameter. The `use latest restorable auto snapshot` and `restore date` parameters are mutually exclusive.
     * + Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots).
     */
    public val useLatestRestorableAutoSnapshot: kotlin.Boolean? = builder.useLatestRestorableAutoSnapshot

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CopySnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopySnapshotRequest(")
        append("restoreDate=$restoreDate,")
        append("sourceRegion=$sourceRegion,")
        append("sourceResourceName=$sourceResourceName,")
        append("sourceSnapshotName=$sourceSnapshotName,")
        append("targetSnapshotName=$targetSnapshotName,")
        append("useLatestRestorableAutoSnapshot=$useLatestRestorableAutoSnapshot")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = restoreDate?.hashCode() ?: 0
        result = 31 * result + (sourceRegion?.hashCode() ?: 0)
        result = 31 * result + (sourceResourceName?.hashCode() ?: 0)
        result = 31 * result + (sourceSnapshotName?.hashCode() ?: 0)
        result = 31 * result + (targetSnapshotName?.hashCode() ?: 0)
        result = 31 * result + (useLatestRestorableAutoSnapshot?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopySnapshotRequest

        if (restoreDate != other.restoreDate) return false
        if (sourceRegion != other.sourceRegion) return false
        if (sourceResourceName != other.sourceResourceName) return false
        if (sourceSnapshotName != other.sourceSnapshotName) return false
        if (targetSnapshotName != other.targetSnapshotName) return false
        if (useLatestRestorableAutoSnapshot != other.useLatestRestorableAutoSnapshot) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CopySnapshotRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date of the source automatic snapshot to copy. Use the `get auto snapshots` operation to identify the dates of the available automatic snapshots.
         *
         * Constraints:
         * + Must be specified in `YYYY-MM-DD` format.
         * + This parameter cannot be defined together with the `use latest restorable auto snapshot` parameter. The `restore date` and `use latest restorable auto snapshot` parameters are mutually exclusive.
         * + Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots).
         */
        public var restoreDate: kotlin.String? = null
        /**
         * The Amazon Web Services Region where the source manual or automatic snapshot is located.
         */
        public var sourceRegion: aws.sdk.kotlin.services.lightsail.model.RegionName? = null
        /**
         * The name of the source instance or disk from which the source automatic snapshot was created.
         *
         * Constraint:
         * + Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots).
         */
        public var sourceResourceName: kotlin.String? = null
        /**
         * The name of the source manual snapshot to copy.
         *
         * Constraint:
         * + Define this parameter only when copying a manual snapshot as another manual snapshot.
         */
        public var sourceSnapshotName: kotlin.String? = null
        /**
         * The name of the new manual snapshot to be created as a copy.
         */
        public var targetSnapshotName: kotlin.String? = null
        /**
         * A Boolean value to indicate whether to use the latest available automatic snapshot of the specified source instance or disk.
         *
         * Constraints:
         * + This parameter cannot be defined together with the `restore date` parameter. The `use latest restorable auto snapshot` and `restore date` parameters are mutually exclusive.
         * + Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots).
         */
        public var useLatestRestorableAutoSnapshot: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CopySnapshotRequest) : this() {
            this.restoreDate = x.restoreDate
            this.sourceRegion = x.sourceRegion
            this.sourceResourceName = x.sourceResourceName
            this.sourceSnapshotName = x.sourceSnapshotName
            this.targetSnapshotName = x.targetSnapshotName
            this.useLatestRestorableAutoSnapshot = x.useLatestRestorableAutoSnapshot
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CopySnapshotRequest = CopySnapshotRequest(this)
    }
}
