// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class CreateContainerServiceRequest private constructor(builder: Builder) {
    /**
     * An object that describes a deployment for the container service.
     *
     * A deployment specifies the containers that will be launched on the container service and their settings, such as the ports to open, the environment variables to apply, and the launch command to run. It also specifies the container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or HTTPS port to use, and the health check configuration.
     */
    public val deployment: aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeploymentRequest? = builder.deployment
    /**
     * The power specification for the container service.
     *
     * The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service. The `power` and `scale` of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the `power` with the `scale` (the number of nodes) of the service.
     *
     * Use the `GetContainerServicePowers` action to get a list of power options that you can specify using this parameter, and their base monthly cost.
     */
    public val power: aws.sdk.kotlin.services.lightsail.model.ContainerServicePowerName? = builder.power
    /**
     * An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories.
     *
     * For more information, see [Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access) in the *Amazon Lightsail Developer Guide*.
     */
    public val privateRegistryAccess: aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccessRequest? = builder.privateRegistryAccess
    /**
     * The public domain names to use with the container service, such as `example.com` and `www.example.com`.
     *
     * You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service.
     *
     * If you don't specify public domain names, then you can use the default domain of the container service.
     *
     * You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the `CreateCertificate` action to create a certificate for the public domain names you want to use with your container service.
     *
     * You can specify public domain names using a string to array map as shown in the example later on this page.
     */
    public val publicDomainNames: Map<String, List<String>>? = builder.publicDomainNames
    /**
     * The scale specification for the container service.
     *
     * The scale specifies the allocated compute nodes of the container service. The `power` and `scale` of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the `power` with the `scale` (the number of nodes) of the service.
     */
    public val scale: kotlin.Int? = builder.scale
    /**
     * The name for the container service.
     *
     * The name that you specify for your container service will make up part of its default domain. The default domain of a container service is typically `https://<ServiceName>.<RandomGUID>.<AWSRegion>.cs.amazonlightsail.com`. If the name of your container service is `container-service-1`, and it's located in the US East (Ohio) Amazon Web Services Region (`us-east-2`), then the domain for your container service will be like the following example: `https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com`
     *
     * The following are the requirements for container service names:
     * + Must be unique within each Amazon Web Services Region in your Lightsail account.
     * + Must contain 1 to 63 characters.
     * + Must contain only alphanumeric characters and hyphens.
     * + A hyphen (-) can separate words but cannot be at the start or end of the name.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * The tag keys and optional values to add to the container service during create.
     *
     * Use the `TagResource` action to tag a resource after it's created.
     *
     * For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CreateContainerServiceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateContainerServiceRequest(")
        append("deployment=$deployment,")
        append("power=$power,")
        append("privateRegistryAccess=$privateRegistryAccess,")
        append("publicDomainNames=$publicDomainNames,")
        append("scale=$scale,")
        append("serviceName=$serviceName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deployment?.hashCode() ?: 0
        result = 31 * result + (power?.hashCode() ?: 0)
        result = 31 * result + (privateRegistryAccess?.hashCode() ?: 0)
        result = 31 * result + (publicDomainNames?.hashCode() ?: 0)
        result = 31 * result + (scale ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateContainerServiceRequest

        if (deployment != other.deployment) return false
        if (power != other.power) return false
        if (privateRegistryAccess != other.privateRegistryAccess) return false
        if (publicDomainNames != other.publicDomainNames) return false
        if (scale != other.scale) return false
        if (serviceName != other.serviceName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CreateContainerServiceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that describes a deployment for the container service.
         *
         * A deployment specifies the containers that will be launched on the container service and their settings, such as the ports to open, the environment variables to apply, and the launch command to run. It also specifies the container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or HTTPS port to use, and the health check configuration.
         */
        public var deployment: aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeploymentRequest? = null
        /**
         * The power specification for the container service.
         *
         * The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service. The `power` and `scale` of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the `power` with the `scale` (the number of nodes) of the service.
         *
         * Use the `GetContainerServicePowers` action to get a list of power options that you can specify using this parameter, and their base monthly cost.
         */
        public var power: aws.sdk.kotlin.services.lightsail.model.ContainerServicePowerName? = null
        /**
         * An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories.
         *
         * For more information, see [Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access) in the *Amazon Lightsail Developer Guide*.
         */
        public var privateRegistryAccess: aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccessRequest? = null
        /**
         * The public domain names to use with the container service, such as `example.com` and `www.example.com`.
         *
         * You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service.
         *
         * If you don't specify public domain names, then you can use the default domain of the container service.
         *
         * You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the `CreateCertificate` action to create a certificate for the public domain names you want to use with your container service.
         *
         * You can specify public domain names using a string to array map as shown in the example later on this page.
         */
        public var publicDomainNames: Map<String, List<String>>? = null
        /**
         * The scale specification for the container service.
         *
         * The scale specifies the allocated compute nodes of the container service. The `power` and `scale` of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the `power` with the `scale` (the number of nodes) of the service.
         */
        public var scale: kotlin.Int? = null
        /**
         * The name for the container service.
         *
         * The name that you specify for your container service will make up part of its default domain. The default domain of a container service is typically `https://<ServiceName>.<RandomGUID>.<AWSRegion>.cs.amazonlightsail.com`. If the name of your container service is `container-service-1`, and it's located in the US East (Ohio) Amazon Web Services Region (`us-east-2`), then the domain for your container service will be like the following example: `https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com`
         *
         * The following are the requirements for container service names:
         * + Must be unique within each Amazon Web Services Region in your Lightsail account.
         * + Must contain 1 to 63 characters.
         * + Must contain only alphanumeric characters and hyphens.
         * + A hyphen (-) can separate words but cannot be at the start or end of the name.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The tag keys and optional values to add to the container service during create.
         *
         * Use the `TagResource` action to tag a resource after it's created.
         *
         * For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CreateContainerServiceRequest) : this() {
            this.deployment = x.deployment
            this.power = x.power
            this.privateRegistryAccess = x.privateRegistryAccess
            this.publicDomainNames = x.publicDomainNames
            this.scale = x.scale
            this.serviceName = x.serviceName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CreateContainerServiceRequest = CreateContainerServiceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeploymentRequest] inside the given [block]
         */
        public fun deployment(block: aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeploymentRequest.Builder.() -> kotlin.Unit) {
            this.deployment = aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeploymentRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccessRequest] inside the given [block]
         */
        public fun privateRegistryAccess(block: aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccessRequest.Builder.() -> kotlin.Unit) {
            this.privateRegistryAccess = aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccessRequest.invoke(block)
        }
    }
}
