// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class CreateLoadBalancerRequest private constructor(builder: Builder) {
    /**
     * The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g., `www.example.com`, `example.com`, `m.example.com`, `blog.example.com`).
     */
    public val certificateAlternativeNames: List<String>? = builder.certificateAlternativeNames
    /**
     * The domain name with which your certificate is associated (e.g., `example.com`).
     *
     * If you specify `certificateDomainName`, then `certificateName` is required (and vice-versa).
     */
    public val certificateDomainName: kotlin.String? = builder.certificateDomainName
    /**
     * The name of the SSL/TLS certificate.
     *
     * If you specify `certificateName`, then `certificateDomainName` is required (and vice-versa).
     */
    public val certificateName: kotlin.String? = builder.certificateName
    /**
     * The path you provided to perform the load balancer health check. If you didn't specify a health check path, Lightsail uses the root path of your website (e.g., `"/"`).
     *
     * You may want to specify a custom health check path other than the root of your application if your home page loads slowly or has a lot of media or scripting on it.
     */
    public val healthCheckPath: kotlin.String? = builder.healthCheckPath
    /**
     * The instance port where you're creating your load balancer.
     */
    public val instancePort: kotlin.Int = builder.instancePort
    /**
     * The IP address type for the load balancer.
     *
     * The possible values are `ipv4` for IPv4 only, and `dualstack` for IPv4 and IPv6.
     *
     * The default value is `dualstack`.
     */
    public val ipAddressType: aws.sdk.kotlin.services.lightsail.model.IpAddressType? = builder.ipAddressType
    /**
     * The name of your load balancer.
     */
    public val loadBalancerName: kotlin.String? = builder.loadBalancerName
    /**
     * The tag keys and optional values to add to the resource during create.
     *
     * Use the `TagResource` action to tag a resource after it's created.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The name of the TLS policy to apply to the load balancer.
     *
     * Use the [GetLoadBalancerTlsPolicies](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetLoadBalancerTlsPolicies.html) action to get a list of TLS policy names that you can specify.
     *
     * For more information about load balancer TLS policies, see [Configuring TLS security policies on your Amazon Lightsail load balancers](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configure-load-balancer-tls-security-policy) in the *Amazon Lightsail Developer Guide*.
     */
    public val tlsPolicyName: kotlin.String? = builder.tlsPolicyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CreateLoadBalancerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLoadBalancerRequest(")
        append("certificateAlternativeNames=$certificateAlternativeNames,")
        append("certificateDomainName=$certificateDomainName,")
        append("certificateName=$certificateName,")
        append("healthCheckPath=$healthCheckPath,")
        append("instancePort=$instancePort,")
        append("ipAddressType=$ipAddressType,")
        append("loadBalancerName=$loadBalancerName,")
        append("tags=$tags,")
        append("tlsPolicyName=$tlsPolicyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAlternativeNames?.hashCode() ?: 0
        result = 31 * result + (certificateDomainName?.hashCode() ?: 0)
        result = 31 * result + (certificateName?.hashCode() ?: 0)
        result = 31 * result + (healthCheckPath?.hashCode() ?: 0)
        result = 31 * result + (instancePort)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tlsPolicyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLoadBalancerRequest

        if (certificateAlternativeNames != other.certificateAlternativeNames) return false
        if (certificateDomainName != other.certificateDomainName) return false
        if (certificateName != other.certificateName) return false
        if (healthCheckPath != other.healthCheckPath) return false
        if (instancePort != other.instancePort) return false
        if (ipAddressType != other.ipAddressType) return false
        if (loadBalancerName != other.loadBalancerName) return false
        if (tags != other.tags) return false
        if (tlsPolicyName != other.tlsPolicyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CreateLoadBalancerRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g., `www.example.com`, `example.com`, `m.example.com`, `blog.example.com`).
         */
        public var certificateAlternativeNames: List<String>? = null
        /**
         * The domain name with which your certificate is associated (e.g., `example.com`).
         *
         * If you specify `certificateDomainName`, then `certificateName` is required (and vice-versa).
         */
        public var certificateDomainName: kotlin.String? = null
        /**
         * The name of the SSL/TLS certificate.
         *
         * If you specify `certificateName`, then `certificateDomainName` is required (and vice-versa).
         */
        public var certificateName: kotlin.String? = null
        /**
         * The path you provided to perform the load balancer health check. If you didn't specify a health check path, Lightsail uses the root path of your website (e.g., `"/"`).
         *
         * You may want to specify a custom health check path other than the root of your application if your home page loads slowly or has a lot of media or scripting on it.
         */
        public var healthCheckPath: kotlin.String? = null
        /**
         * The instance port where you're creating your load balancer.
         */
        public var instancePort: kotlin.Int = 0
        /**
         * The IP address type for the load balancer.
         *
         * The possible values are `ipv4` for IPv4 only, and `dualstack` for IPv4 and IPv6.
         *
         * The default value is `dualstack`.
         */
        public var ipAddressType: aws.sdk.kotlin.services.lightsail.model.IpAddressType? = null
        /**
         * The name of your load balancer.
         */
        public var loadBalancerName: kotlin.String? = null
        /**
         * The tag keys and optional values to add to the resource during create.
         *
         * Use the `TagResource` action to tag a resource after it's created.
         */
        public var tags: List<Tag>? = null
        /**
         * The name of the TLS policy to apply to the load balancer.
         *
         * Use the [GetLoadBalancerTlsPolicies](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetLoadBalancerTlsPolicies.html) action to get a list of TLS policy names that you can specify.
         *
         * For more information about load balancer TLS policies, see [Configuring TLS security policies on your Amazon Lightsail load balancers](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configure-load-balancer-tls-security-policy) in the *Amazon Lightsail Developer Guide*.
         */
        public var tlsPolicyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CreateLoadBalancerRequest) : this() {
            this.certificateAlternativeNames = x.certificateAlternativeNames
            this.certificateDomainName = x.certificateDomainName
            this.certificateName = x.certificateName
            this.healthCheckPath = x.healthCheckPath
            this.instancePort = x.instancePort
            this.ipAddressType = x.ipAddressType
            this.loadBalancerName = x.loadBalancerName
            this.tags = x.tags
            this.tlsPolicyName = x.tlsPolicyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CreateLoadBalancerRequest = CreateLoadBalancerRequest(this)
    }
}
