// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class CreateLoadBalancerTlsCertificateRequest private constructor(builder: Builder) {
    /**
     * An array of strings listing alternative domains and subdomains for your SSL/TLS certificate. Lightsail will de-dupe the names for you. You can have a maximum of 9 alternative names (in addition to the 1 primary domain). We do not support wildcards (e.g., `*.example.com`).
     */
    public val certificateAlternativeNames: List<String>? = builder.certificateAlternativeNames
    /**
     * The domain name (e.g., `example.com`) for your SSL/TLS certificate.
     */
    public val certificateDomainName: kotlin.String? = builder.certificateDomainName
    /**
     * The SSL/TLS certificate name.
     *
     * You can have up to 10 certificates in your account at one time. Each Lightsail load balancer can have up to 2 certificates associated with it at one time. There is also an overall limit to the number of certificates that can be issue in a 365-day period. For more information, see [Limits](http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html).
     */
    public val certificateName: kotlin.String? = builder.certificateName
    /**
     * The load balancer name where you want to create the SSL/TLS certificate.
     */
    public val loadBalancerName: kotlin.String? = builder.loadBalancerName
    /**
     * The tag keys and optional values to add to the resource during create.
     *
     * Use the `TagResource` action to tag a resource after it's created.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLoadBalancerTlsCertificateRequest(")
        append("certificateAlternativeNames=$certificateAlternativeNames,")
        append("certificateDomainName=$certificateDomainName,")
        append("certificateName=$certificateName,")
        append("loadBalancerName=$loadBalancerName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAlternativeNames?.hashCode() ?: 0
        result = 31 * result + (certificateDomainName?.hashCode() ?: 0)
        result = 31 * result + (certificateName?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLoadBalancerTlsCertificateRequest

        if (certificateAlternativeNames != other.certificateAlternativeNames) return false
        if (certificateDomainName != other.certificateDomainName) return false
        if (certificateName != other.certificateName) return false
        if (loadBalancerName != other.loadBalancerName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of strings listing alternative domains and subdomains for your SSL/TLS certificate. Lightsail will de-dupe the names for you. You can have a maximum of 9 alternative names (in addition to the 1 primary domain). We do not support wildcards (e.g., `*.example.com`).
         */
        public var certificateAlternativeNames: List<String>? = null
        /**
         * The domain name (e.g., `example.com`) for your SSL/TLS certificate.
         */
        public var certificateDomainName: kotlin.String? = null
        /**
         * The SSL/TLS certificate name.
         *
         * You can have up to 10 certificates in your account at one time. Each Lightsail load balancer can have up to 2 certificates associated with it at one time. There is also an overall limit to the number of certificates that can be issue in a 365-day period. For more information, see [Limits](http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html).
         */
        public var certificateName: kotlin.String? = null
        /**
         * The load balancer name where you want to create the SSL/TLS certificate.
         */
        public var loadBalancerName: kotlin.String? = null
        /**
         * The tag keys and optional values to add to the resource during create.
         *
         * Use the `TagResource` action to tag a resource after it's created.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest) : this() {
            this.certificateAlternativeNames = x.certificateAlternativeNames
            this.certificateDomainName = x.certificateDomainName
            this.certificateName = x.certificateName
            this.loadBalancerName = x.loadBalancerName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest = CreateLoadBalancerTlsCertificateRequest(this)
    }
}
