// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateRelationalDatabaseFromSnapshotRequest private constructor(builder: Builder) {
    /**
     * The Availability Zone in which to create your new database. Use the `us-east-2a` case-sensitive format.
     *
     * You can get a list of Availability Zones by using the `get regions` operation. Be sure to add the `include relational database Availability Zones` parameter to your request.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * Specifies the accessibility options for your new database. A value of `true` specifies a database that is available to resources outside of your Lightsail account. A value of `false` specifies a database that is available only to your Lightsail resources in the same region as your database.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The bundle ID for your new database. A bundle describes the performance specifications for your database.
     *
     * You can get a list of database bundle IDs by using the `get relational database bundles` operation.
     *
     * When creating a new database from a snapshot, you cannot choose a bundle that is smaller than the bundle of the source database.
     */
    public val relationalDatabaseBundleId: kotlin.String? = builder.relationalDatabaseBundleId
    /**
     * The name to use for your new Lightsail database resource.
     *
     * Constraints:
     * + Must contain from 2 to 255 alphanumeric characters, or hyphens.
     * + The first and last character must be a letter or number.
     */
    public val relationalDatabaseName: kotlin.String? = builder.relationalDatabaseName
    /**
     * The name of the database snapshot from which to create your new database.
     */
    public val relationalDatabaseSnapshotName: kotlin.String? = builder.relationalDatabaseSnapshotName
    /**
     * The date and time to restore your database from.
     *
     * Constraints:
     * + Must be before the latest restorable time for the database.
     * + Cannot be specified if the `use latest restorable time` parameter is `true`.
     * + Specified in Coordinated Universal Time (UTC).
     * + Specified in the Unix time format.For example, if you wish to use a restore time of October 1, 2018, at 8 PM UTC, then you input `1538424000` as the restore time.
     */
    public val restoreTime: aws.smithy.kotlin.runtime.time.Instant? = builder.restoreTime
    /**
     * The name of the source database.
     */
    public val sourceRelationalDatabaseName: kotlin.String? = builder.sourceRelationalDatabaseName
    /**
     * The tag keys and optional values to add to the resource during create.
     *
     * Use the `TagResource` action to tag a resource after it's created.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies whether your database is restored from the latest backup time. A value of `true` restores from the latest backup time.
     *
     * Default: `false`
     *
     * Constraints: Cannot be specified if the `restore time` parameter is provided.
     */
    public val useLatestRestorableTime: kotlin.Boolean? = builder.useLatestRestorableTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRelationalDatabaseFromSnapshotRequest(")
        append("availabilityZone=$availabilityZone,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("relationalDatabaseBundleId=$relationalDatabaseBundleId,")
        append("relationalDatabaseName=$relationalDatabaseName,")
        append("relationalDatabaseSnapshotName=$relationalDatabaseSnapshotName,")
        append("restoreTime=$restoreTime,")
        append("sourceRelationalDatabaseName=$sourceRelationalDatabaseName,")
        append("tags=$tags,")
        append("useLatestRestorableTime=$useLatestRestorableTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (relationalDatabaseBundleId?.hashCode() ?: 0)
        result = 31 * result + (relationalDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (relationalDatabaseSnapshotName?.hashCode() ?: 0)
        result = 31 * result + (restoreTime?.hashCode() ?: 0)
        result = 31 * result + (sourceRelationalDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (useLatestRestorableTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRelationalDatabaseFromSnapshotRequest

        if (availabilityZone != other.availabilityZone) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (relationalDatabaseBundleId != other.relationalDatabaseBundleId) return false
        if (relationalDatabaseName != other.relationalDatabaseName) return false
        if (relationalDatabaseSnapshotName != other.relationalDatabaseSnapshotName) return false
        if (restoreTime != other.restoreTime) return false
        if (sourceRelationalDatabaseName != other.sourceRelationalDatabaseName) return false
        if (tags != other.tags) return false
        if (useLatestRestorableTime != other.useLatestRestorableTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Availability Zone in which to create your new database. Use the `us-east-2a` case-sensitive format.
         *
         * You can get a list of Availability Zones by using the `get regions` operation. Be sure to add the `include relational database Availability Zones` parameter to your request.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * Specifies the accessibility options for your new database. A value of `true` specifies a database that is available to resources outside of your Lightsail account. A value of `false` specifies a database that is available only to your Lightsail resources in the same region as your database.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The bundle ID for your new database. A bundle describes the performance specifications for your database.
         *
         * You can get a list of database bundle IDs by using the `get relational database bundles` operation.
         *
         * When creating a new database from a snapshot, you cannot choose a bundle that is smaller than the bundle of the source database.
         */
        public var relationalDatabaseBundleId: kotlin.String? = null
        /**
         * The name to use for your new Lightsail database resource.
         *
         * Constraints:
         * + Must contain from 2 to 255 alphanumeric characters, or hyphens.
         * + The first and last character must be a letter or number.
         */
        public var relationalDatabaseName: kotlin.String? = null
        /**
         * The name of the database snapshot from which to create your new database.
         */
        public var relationalDatabaseSnapshotName: kotlin.String? = null
        /**
         * The date and time to restore your database from.
         *
         * Constraints:
         * + Must be before the latest restorable time for the database.
         * + Cannot be specified if the `use latest restorable time` parameter is `true`.
         * + Specified in Coordinated Universal Time (UTC).
         * + Specified in the Unix time format.For example, if you wish to use a restore time of October 1, 2018, at 8 PM UTC, then you input `1538424000` as the restore time.
         */
        public var restoreTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the source database.
         */
        public var sourceRelationalDatabaseName: kotlin.String? = null
        /**
         * The tag keys and optional values to add to the resource during create.
         *
         * Use the `TagResource` action to tag a resource after it's created.
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies whether your database is restored from the latest backup time. A value of `true` restores from the latest backup time.
         *
         * Default: `false`
         *
         * Constraints: Cannot be specified if the `restore time` parameter is provided.
         */
        public var useLatestRestorableTime: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest) : this() {
            this.availabilityZone = x.availabilityZone
            this.publiclyAccessible = x.publiclyAccessible
            this.relationalDatabaseBundleId = x.relationalDatabaseBundleId
            this.relationalDatabaseName = x.relationalDatabaseName
            this.relationalDatabaseSnapshotName = x.relationalDatabaseSnapshotName
            this.restoreTime = x.restoreTime
            this.sourceRelationalDatabaseName = x.sourceRelationalDatabaseName
            this.tags = x.tags
            this.useLatestRestorableTime = x.useLatestRestorableTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest = CreateRelationalDatabaseFromSnapshotRequest(this)
    }
}
