// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class CreateRelationalDatabaseRequest private constructor(builder: Builder) {
    /**
     * The Availability Zone in which to create your new database. Use the `us-east-2a` case-sensitive format.
     *
     * You can get a list of Availability Zones by using the `get regions` operation. Be sure to add the `include relational database Availability Zones` parameter to your request.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The meaning of this parameter differs according to the database engine you use.
     *
     * **MySQL**
     *
     * The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, no database is created in the database resource.
     *
     * Constraints:
     * + Must contain 1 to 64 letters or numbers.
     * + Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0- 9).
     * + Can't be a word reserved by the specified database engine.For more information about reserved words in MySQL, see the Keywords and Reserved Words articles for [MySQL 5.6](https://dev.mysql.com/doc/refman/5.6/en/keywords.html), [MySQL 5.7](https://dev.mysql.com/doc/refman/5.7/en/keywords.html), and [MySQL 8.0](https://dev.mysql.com/doc/refman/8.0/en/keywords.html).
     *
     * **PostgreSQL**
     *
     * The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, a database named `postgres` is created in the database resource.
     *
     * Constraints:
     * + Must contain 1 to 63 letters or numbers.
     * + Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0- 9).
     * + Can't be a word reserved by the specified database engine.For more information about reserved words in PostgreSQL, see the SQL Key Words articles for [PostgreSQL 9.6](https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html), [PostgreSQL 10](https://www.postgresql.org/docs/10/sql-keywords-appendix.html), [PostgreSQL 11](https://www.postgresql.org/docs/11/sql-keywords-appendix.html), and [PostgreSQL 12](https://www.postgresql.org/docs/12/sql-keywords-appendix.html).
     */
    public val masterDatabaseName: kotlin.String? = builder.masterDatabaseName
    /**
     * The password for the master user. The password can include any printable ASCII character except "/", """, or "@". It cannot contain spaces.
     *
     * **MySQL**
     *
     * Constraints: Must contain from 8 to 41 characters.
     *
     * **PostgreSQL**
     *
     * Constraints: Must contain from 8 to 128 characters.
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The name for the master user.
     *
     * **MySQL**
     *
     * Constraints:
     * + Required for MySQL.
     * + Must be 1 to 16 letters or numbers. Can contain underscores.
     * + First character must be a letter.
     * + Can't be a reserved word for the chosen database engine.For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for [MySQL 5.6](https://dev.mysql.com/doc/refman/5.6/en/keywords.html), [MySQL 5.7](https://dev.mysql.com/doc/refman/5.7/en/keywords.html), or [MySQL 8.0](https://dev.mysql.com/doc/refman/8.0/en/keywords.html).
     *
     * **PostgreSQL**
     *
     * Constraints:
     * + Required for PostgreSQL.
     * + Must be 1 to 63 letters or numbers. Can contain underscores.
     * + First character must be a letter.
     * + Can't be a reserved word for the chosen database engine.For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for [PostgreSQL 9.6](https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html), [PostgreSQL 10](https://www.postgresql.org/docs/10/sql-keywords-appendix.html), [PostgreSQL 11](https://www.postgresql.org/docs/11/sql-keywords-appendix.html), and [PostgreSQL 12](https://www.postgresql.org/docs/12/sql-keywords-appendix.html).
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The daily time range during which automated backups are created for your new database if automated backups are enabled.
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. For more information about the preferred backup window time blocks for each region, see the [Working With Backups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow) guide in the Amazon Relational Database Service documentation.
     *
     * Constraints:
     * + Must be in the `hh24:mi-hh24:mi` format.Example: `16:00-16:30`
     * + Specified in Coordinated Universal Time (UTC).
     * + Must not conflict with the preferred maintenance window.
     * + Must be at least 30 minutes.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur on your new database.
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week.
     *
     * Constraints:
     * + Must be in the `ddd:hh24:mi-ddd:hh24:mi` format.
     * + Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * + Must be at least 30 minutes.
     * + Specified in Coordinated Universal Time (UTC).
     * + Example: `Tue:17:00-Tue:17:30`
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Specifies the accessibility options for your new database. A value of `true` specifies a database that is available to resources outside of your Lightsail account. A value of `false` specifies a database that is available only to your Lightsail resources in the same region as your database.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The blueprint ID for your new database. A blueprint describes the major engine version of a database.
     *
     * You can get a list of database blueprints IDs by using the `get relational database blueprints` operation.
     */
    public val relationalDatabaseBlueprintId: kotlin.String? = builder.relationalDatabaseBlueprintId
    /**
     * The bundle ID for your new database. A bundle describes the performance specifications for your database.
     *
     * You can get a list of database bundle IDs by using the `get relational database bundles` operation.
     */
    public val relationalDatabaseBundleId: kotlin.String? = builder.relationalDatabaseBundleId
    /**
     * The name to use for your new Lightsail database resource.
     *
     * Constraints:
     * + Must contain from 2 to 255 alphanumeric characters, or hyphens.
     * + The first and last character must be a letter or number.
     */
    public val relationalDatabaseName: kotlin.String? = builder.relationalDatabaseName
    /**
     * The tag keys and optional values to add to the resource during create.
     *
     * Use the `TagResource` action to tag a resource after it's created.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CreateRelationalDatabaseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRelationalDatabaseRequest(")
        append("availabilityZone=$availabilityZone,")
        append("masterDatabaseName=$masterDatabaseName,")
        append("masterUserPassword=*** Sensitive Data Redacted ***,")
        append("masterUsername=$masterUsername,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("relationalDatabaseBlueprintId=$relationalDatabaseBlueprintId,")
        append("relationalDatabaseBundleId=$relationalDatabaseBundleId,")
        append("relationalDatabaseName=$relationalDatabaseName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (masterDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (relationalDatabaseBlueprintId?.hashCode() ?: 0)
        result = 31 * result + (relationalDatabaseBundleId?.hashCode() ?: 0)
        result = 31 * result + (relationalDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRelationalDatabaseRequest

        if (availabilityZone != other.availabilityZone) return false
        if (masterDatabaseName != other.masterDatabaseName) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (masterUsername != other.masterUsername) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (relationalDatabaseBlueprintId != other.relationalDatabaseBlueprintId) return false
        if (relationalDatabaseBundleId != other.relationalDatabaseBundleId) return false
        if (relationalDatabaseName != other.relationalDatabaseName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CreateRelationalDatabaseRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Availability Zone in which to create your new database. Use the `us-east-2a` case-sensitive format.
         *
         * You can get a list of Availability Zones by using the `get regions` operation. Be sure to add the `include relational database Availability Zones` parameter to your request.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The meaning of this parameter differs according to the database engine you use.
         *
         * **MySQL**
         *
         * The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, no database is created in the database resource.
         *
         * Constraints:
         * + Must contain 1 to 64 letters or numbers.
         * + Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0- 9).
         * + Can't be a word reserved by the specified database engine.For more information about reserved words in MySQL, see the Keywords and Reserved Words articles for [MySQL 5.6](https://dev.mysql.com/doc/refman/5.6/en/keywords.html), [MySQL 5.7](https://dev.mysql.com/doc/refman/5.7/en/keywords.html), and [MySQL 8.0](https://dev.mysql.com/doc/refman/8.0/en/keywords.html).
         *
         * **PostgreSQL**
         *
         * The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, a database named `postgres` is created in the database resource.
         *
         * Constraints:
         * + Must contain 1 to 63 letters or numbers.
         * + Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0- 9).
         * + Can't be a word reserved by the specified database engine.For more information about reserved words in PostgreSQL, see the SQL Key Words articles for [PostgreSQL 9.6](https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html), [PostgreSQL 10](https://www.postgresql.org/docs/10/sql-keywords-appendix.html), [PostgreSQL 11](https://www.postgresql.org/docs/11/sql-keywords-appendix.html), and [PostgreSQL 12](https://www.postgresql.org/docs/12/sql-keywords-appendix.html).
         */
        public var masterDatabaseName: kotlin.String? = null
        /**
         * The password for the master user. The password can include any printable ASCII character except "/", """, or "@". It cannot contain spaces.
         *
         * **MySQL**
         *
         * Constraints: Must contain from 8 to 41 characters.
         *
         * **PostgreSQL**
         *
         * Constraints: Must contain from 8 to 128 characters.
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * The name for the master user.
         *
         * **MySQL**
         *
         * Constraints:
         * + Required for MySQL.
         * + Must be 1 to 16 letters or numbers. Can contain underscores.
         * + First character must be a letter.
         * + Can't be a reserved word for the chosen database engine.For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for [MySQL 5.6](https://dev.mysql.com/doc/refman/5.6/en/keywords.html), [MySQL 5.7](https://dev.mysql.com/doc/refman/5.7/en/keywords.html), or [MySQL 8.0](https://dev.mysql.com/doc/refman/8.0/en/keywords.html).
         *
         * **PostgreSQL**
         *
         * Constraints:
         * + Required for PostgreSQL.
         * + Must be 1 to 63 letters or numbers. Can contain underscores.
         * + First character must be a letter.
         * + Can't be a reserved word for the chosen database engine.For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for [PostgreSQL 9.6](https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html), [PostgreSQL 10](https://www.postgresql.org/docs/10/sql-keywords-appendix.html), [PostgreSQL 11](https://www.postgresql.org/docs/11/sql-keywords-appendix.html), and [PostgreSQL 12](https://www.postgresql.org/docs/12/sql-keywords-appendix.html).
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The daily time range during which automated backups are created for your new database if automated backups are enabled.
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. For more information about the preferred backup window time blocks for each region, see the [Working With Backups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow) guide in the Amazon Relational Database Service documentation.
         *
         * Constraints:
         * + Must be in the `hh24:mi-hh24:mi` format.Example: `16:00-16:30`
         * + Specified in Coordinated Universal Time (UTC).
         * + Must not conflict with the preferred maintenance window.
         * + Must be at least 30 minutes.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur on your new database.
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week.
         *
         * Constraints:
         * + Must be in the `ddd:hh24:mi-ddd:hh24:mi` format.
         * + Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * + Must be at least 30 minutes.
         * + Specified in Coordinated Universal Time (UTC).
         * + Example: `Tue:17:00-Tue:17:30`
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Specifies the accessibility options for your new database. A value of `true` specifies a database that is available to resources outside of your Lightsail account. A value of `false` specifies a database that is available only to your Lightsail resources in the same region as your database.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The blueprint ID for your new database. A blueprint describes the major engine version of a database.
         *
         * You can get a list of database blueprints IDs by using the `get relational database blueprints` operation.
         */
        public var relationalDatabaseBlueprintId: kotlin.String? = null
        /**
         * The bundle ID for your new database. A bundle describes the performance specifications for your database.
         *
         * You can get a list of database bundle IDs by using the `get relational database bundles` operation.
         */
        public var relationalDatabaseBundleId: kotlin.String? = null
        /**
         * The name to use for your new Lightsail database resource.
         *
         * Constraints:
         * + Must contain from 2 to 255 alphanumeric characters, or hyphens.
         * + The first and last character must be a letter or number.
         */
        public var relationalDatabaseName: kotlin.String? = null
        /**
         * The tag keys and optional values to add to the resource during create.
         *
         * Use the `TagResource` action to tag a resource after it's created.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CreateRelationalDatabaseRequest) : this() {
            this.availabilityZone = x.availabilityZone
            this.masterDatabaseName = x.masterDatabaseName
            this.masterUserPassword = x.masterUserPassword
            this.masterUsername = x.masterUsername
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.relationalDatabaseBlueprintId = x.relationalDatabaseBlueprintId
            this.relationalDatabaseBundleId = x.relationalDatabaseBundleId
            this.relationalDatabaseName = x.relationalDatabaseName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CreateRelationalDatabaseRequest = CreateRelationalDatabaseRequest(this)
    }
}
