// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class DeleteContainerImageRequest private constructor(builder: Builder) {
    /**
     * The name of the container image to delete from the container service.
     *
     * Use the `GetContainerImages` action to get the name of the container images that are registered to a container service.
     *
     * Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (`:`). For example, `:container-service-1.mystaticwebsite.1`. Container images sourced from a public registry like Docker Hub don't start with a colon. For example, `nginx:latest` or `nginx`.
     */
    public val image: kotlin.String? = requireNotNull(builder.image) { "A non-null value must be provided for image" }
    /**
     * The name of the container service for which to delete a registered container image.
     */
    public val serviceName: kotlin.String? = requireNotNull(builder.serviceName) { "A non-null value must be provided for serviceName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.DeleteContainerImageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteContainerImageRequest(")
        append("image=$image,")
        append("serviceName=$serviceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = image?.hashCode() ?: 0
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteContainerImageRequest

        if (image != other.image) return false
        if (serviceName != other.serviceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.DeleteContainerImageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the container image to delete from the container service.
         *
         * Use the `GetContainerImages` action to get the name of the container images that are registered to a container service.
         *
         * Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (`:`). For example, `:container-service-1.mystaticwebsite.1`. Container images sourced from a public registry like Docker Hub don't start with a colon. For example, `nginx:latest` or `nginx`.
         */
        public var image: kotlin.String? = null
        /**
         * The name of the container service for which to delete a registered container image.
         */
        public var serviceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.DeleteContainerImageRequest) : this() {
            this.image = x.image
            this.serviceName = x.serviceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.DeleteContainerImageRequest = DeleteContainerImageRequest(this)
    }
}
