// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a block storage disk snapshot.
 */
public class DiskSnapshot private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the disk snapshot.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date when the disk snapshot was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon Resource Name (ARN) of the source disk from which the disk snapshot was created.
     */
    public val fromDiskArn: kotlin.String? = builder.fromDiskArn
    /**
     * The unique name of the source disk from which the disk snapshot was created.
     */
    public val fromDiskName: kotlin.String? = builder.fromDiskName
    /**
     * The Amazon Resource Name (ARN) of the source instance from which the disk (system volume) snapshot was created.
     */
    public val fromInstanceArn: kotlin.String? = builder.fromInstanceArn
    /**
     * The unique name of the source instance from which the disk (system volume) snapshot was created.
     */
    public val fromInstanceName: kotlin.String? = builder.fromInstanceName
    /**
     * A Boolean value indicating whether the snapshot was created from an automatic snapshot.
     */
    public val isFromAutoSnapshot: kotlin.Boolean? = builder.isFromAutoSnapshot
    /**
     * The AWS Region and Availability Zone where the disk snapshot was created.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The name of the disk snapshot (e.g., `my-disk-snapshot`).
     */
    public val name: kotlin.String? = builder.name
    /**
     * The progress of the snapshot.
     */
    public val progress: kotlin.String? = builder.progress
    /**
     * The Lightsail resource type (e.g., `DiskSnapshot`).
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * The size of the disk in GB.
     */
    public val sizeInGb: kotlin.Int? = builder.sizeInGb
    /**
     * The status of the disk snapshot operation.
     */
    public val state: aws.sdk.kotlin.services.lightsail.model.DiskSnapshotState? = builder.state
    /**
     * The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode
    /**
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.DiskSnapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DiskSnapshot(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("fromDiskArn=$fromDiskArn,")
        append("fromDiskName=$fromDiskName,")
        append("fromInstanceArn=$fromInstanceArn,")
        append("fromInstanceName=$fromInstanceName,")
        append("isFromAutoSnapshot=$isFromAutoSnapshot,")
        append("location=$location,")
        append("name=$name,")
        append("progress=$progress,")
        append("resourceType=$resourceType,")
        append("sizeInGb=$sizeInGb,")
        append("state=$state,")
        append("supportCode=$supportCode,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (fromDiskArn?.hashCode() ?: 0)
        result = 31 * result + (fromDiskName?.hashCode() ?: 0)
        result = 31 * result + (fromInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (fromInstanceName?.hashCode() ?: 0)
        result = 31 * result + (isFromAutoSnapshot?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (progress?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sizeInGb ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DiskSnapshot

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (fromDiskArn != other.fromDiskArn) return false
        if (fromDiskName != other.fromDiskName) return false
        if (fromInstanceArn != other.fromInstanceArn) return false
        if (fromInstanceName != other.fromInstanceName) return false
        if (isFromAutoSnapshot != other.isFromAutoSnapshot) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (progress != other.progress) return false
        if (resourceType != other.resourceType) return false
        if (sizeInGb != other.sizeInGb) return false
        if (state != other.state) return false
        if (supportCode != other.supportCode) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.DiskSnapshot = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the disk snapshot.
         */
        public var arn: kotlin.String? = null
        /**
         * The date when the disk snapshot was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the source disk from which the disk snapshot was created.
         */
        public var fromDiskArn: kotlin.String? = null
        /**
         * The unique name of the source disk from which the disk snapshot was created.
         */
        public var fromDiskName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the source instance from which the disk (system volume) snapshot was created.
         */
        public var fromInstanceArn: kotlin.String? = null
        /**
         * The unique name of the source instance from which the disk (system volume) snapshot was created.
         */
        public var fromInstanceName: kotlin.String? = null
        /**
         * A Boolean value indicating whether the snapshot was created from an automatic snapshot.
         */
        public var isFromAutoSnapshot: kotlin.Boolean? = null
        /**
         * The AWS Region and Availability Zone where the disk snapshot was created.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The name of the disk snapshot (e.g., `my-disk-snapshot`).
         */
        public var name: kotlin.String? = null
        /**
         * The progress of the snapshot.
         */
        public var progress: kotlin.String? = null
        /**
         * The Lightsail resource type (e.g., `DiskSnapshot`).
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * The size of the disk in GB.
         */
        public var sizeInGb: kotlin.Int? = null
        /**
         * The status of the disk snapshot operation.
         */
        public var state: aws.sdk.kotlin.services.lightsail.model.DiskSnapshotState? = null
        /**
         * The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null
        /**
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.DiskSnapshot) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.fromDiskArn = x.fromDiskArn
            this.fromDiskName = x.fromDiskName
            this.fromInstanceArn = x.fromInstanceArn
            this.fromInstanceName = x.fromInstanceName
            this.isFromAutoSnapshot = x.isFromAutoSnapshot
            this.location = x.location
            this.name = x.name
            this.progress = x.progress
            this.resourceType = x.resourceType
            this.sizeInGb = x.sizeInGb
            this.state = x.state
            this.supportCode = x.supportCode
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.DiskSnapshot = DiskSnapshot(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }
    }
}
