// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetLoadBalancerMetricDataRequest private constructor(builder: Builder) {
    /**
     * The end time of the period.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The name of the load balancer.
     */
    public val loadBalancerName: kotlin.String? = builder.loadBalancerName
    /**
     * The metric for which you want to return information.
     *
     * Valid load balancer metric names are listed below, along with the most useful `statistics` to include in your request, and the published `unit` value.
     * + **`ClientTLSNegotiationErrorCount`** - The number of TLS connections initiated by the client that did not establish a session with the load balancer due to a TLS error generated by the load balancer. Possible causes include a mismatch of ciphers or protocols.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Count`.
     * + **`HealthyHostCount`** - The number of target instances that are considered healthy.`Statistics`: The most useful statistic are `Average`, `Minimum`, and `Maximum`.`Unit`: The published unit is `Count`.
     * + **`HTTPCode_Instance_2XX_Count`** - The number of HTTP 2XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.`Statistics`: The most useful statistic is `Sum`. Note that `Minimum`, `Maximum`, and `Average` all return `1`.`Unit`: The published unit is `Count`.
     * + **`HTTPCode_Instance_3XX_Count`** - The number of HTTP 3XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.`Statistics`: The most useful statistic is `Sum`. Note that `Minimum`, `Maximum`, and `Average` all return `1`.`Unit`: The published unit is `Count`.
     * + **`HTTPCode_Instance_4XX_Count`** - The number of HTTP 4XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.`Statistics`: The most useful statistic is `Sum`. Note that `Minimum`, `Maximum`, and `Average` all return `1`.`Unit`: The published unit is `Count`.
     * + **`HTTPCode_Instance_5XX_Count`** - The number of HTTP 5XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.`Statistics`: The most useful statistic is `Sum`. Note that `Minimum`, `Maximum`, and `Average` all return `1`.`Unit`: The published unit is `Count`.
     * + **`HTTPCode_LB_4XX_Count`** - The number of HTTP 4XX client error codes that originated from the load balancer. Client errors are generated when requests are malformed or incomplete. These requests were not received by the target instance. This count does not include response codes generated by the target instances.`Statistics`: The most useful statistic is `Sum`. Note that `Minimum`, `Maximum`, and `Average` all return `1`.`Unit`: The published unit is `Count`.
     * + **`HTTPCode_LB_5XX_Count`** - The number of HTTP 5XX server error codes that originated from the load balancer. This does not include any response codes generated by the target instance. This metric is reported if there are no healthy instances attached to the load balancer, or if the request rate exceeds the capacity of the instances (spillover) or the load balancer.`Statistics`: The most useful statistic is `Sum`. Note that `Minimum`, `Maximum`, and `Average` all return `1`.`Unit`: The published unit is `Count`.
     * + **`InstanceResponseTime`** - The time elapsed, in seconds, after the request leaves the load balancer until a response from the target instance is received.`Statistics`: The most useful statistic is `Average`.`Unit`: The published unit is `Seconds`.
     * + **`RejectedConnectionCount`** - The number of connections that were rejected because the load balancer had reached its maximum number of connections.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Count`.
     * + **`RequestCount`** - The number of requests processed over IPv4. This count includes only the requests with a response generated by a target instance of the load balancer.`Statistics`: The most useful statistic is `Sum`. Note that `Minimum`, `Maximum`, and `Average` all return `1`.`Unit`: The published unit is `Count`.
     * + **`UnhealthyHostCount`** - The number of target instances that are considered unhealthy.`Statistics`: The most useful statistic are `Average`, `Minimum`, and `Maximum`.`Unit`: The published unit is `Count`.
     */
    public val metricName: aws.sdk.kotlin.services.lightsail.model.LoadBalancerMetricName? = builder.metricName
    /**
     * The granularity, in seconds, of the returned data points.
     */
    public val period: kotlin.Int = builder.period
    /**
     * The start time of the period.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The statistic for the metric.
     *
     * The following statistics are available:
     * + `Minimum` - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.
     * + `Maximum` - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.
     * + `Sum` - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.
     * + `Average` - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.
     * + `SampleCount` - The count, or number, of data points used for the statistical calculation.
     */
    public val statistics: List<MetricStatistic>? = builder.statistics
    /**
     * The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units with each available metric, see the `metricName` parameter.
     */
    public val unit: aws.sdk.kotlin.services.lightsail.model.MetricUnit? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.GetLoadBalancerMetricDataRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetLoadBalancerMetricDataRequest(")
        append("endTime=$endTime,")
        append("loadBalancerName=$loadBalancerName,")
        append("metricName=$metricName,")
        append("period=$period,")
        append("startTime=$startTime,")
        append("statistics=$statistics,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (loadBalancerName?.hashCode() ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (period)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (statistics?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetLoadBalancerMetricDataRequest

        if (endTime != other.endTime) return false
        if (loadBalancerName != other.loadBalancerName) return false
        if (metricName != other.metricName) return false
        if (period != other.period) return false
        if (startTime != other.startTime) return false
        if (statistics != other.statistics) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.GetLoadBalancerMetricDataRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The end time of the period.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the load balancer.
         */
        public var loadBalancerName: kotlin.String? = null
        /**
         * The metric for which you want to return information.
         *
         * Valid load balancer metric names are listed below, along with the most useful `statistics` to include in your request, and the published `unit` value.
         * + **`ClientTLSNegotiationErrorCount`** - The number of TLS connections initiated by the client that did not establish a session with the load balancer due to a TLS error generated by the load balancer. Possible causes include a mismatch of ciphers or protocols.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Count`.
         * + **`HealthyHostCount`** - The number of target instances that are considered healthy.`Statistics`: The most useful statistic are `Average`, `Minimum`, and `Maximum`.`Unit`: The published unit is `Count`.
         * + **`HTTPCode_Instance_2XX_Count`** - The number of HTTP 2XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.`Statistics`: The most useful statistic is `Sum`. Note that `Minimum`, `Maximum`, and `Average` all return `1`.`Unit`: The published unit is `Count`.
         * + **`HTTPCode_Instance_3XX_Count`** - The number of HTTP 3XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.`Statistics`: The most useful statistic is `Sum`. Note that `Minimum`, `Maximum`, and `Average` all return `1`.`Unit`: The published unit is `Count`.
         * + **`HTTPCode_Instance_4XX_Count`** - The number of HTTP 4XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.`Statistics`: The most useful statistic is `Sum`. Note that `Minimum`, `Maximum`, and `Average` all return `1`.`Unit`: The published unit is `Count`.
         * + **`HTTPCode_Instance_5XX_Count`** - The number of HTTP 5XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.`Statistics`: The most useful statistic is `Sum`. Note that `Minimum`, `Maximum`, and `Average` all return `1`.`Unit`: The published unit is `Count`.
         * + **`HTTPCode_LB_4XX_Count`** - The number of HTTP 4XX client error codes that originated from the load balancer. Client errors are generated when requests are malformed or incomplete. These requests were not received by the target instance. This count does not include response codes generated by the target instances.`Statistics`: The most useful statistic is `Sum`. Note that `Minimum`, `Maximum`, and `Average` all return `1`.`Unit`: The published unit is `Count`.
         * + **`HTTPCode_LB_5XX_Count`** - The number of HTTP 5XX server error codes that originated from the load balancer. This does not include any response codes generated by the target instance. This metric is reported if there are no healthy instances attached to the load balancer, or if the request rate exceeds the capacity of the instances (spillover) or the load balancer.`Statistics`: The most useful statistic is `Sum`. Note that `Minimum`, `Maximum`, and `Average` all return `1`.`Unit`: The published unit is `Count`.
         * + **`InstanceResponseTime`** - The time elapsed, in seconds, after the request leaves the load balancer until a response from the target instance is received.`Statistics`: The most useful statistic is `Average`.`Unit`: The published unit is `Seconds`.
         * + **`RejectedConnectionCount`** - The number of connections that were rejected because the load balancer had reached its maximum number of connections.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Count`.
         * + **`RequestCount`** - The number of requests processed over IPv4. This count includes only the requests with a response generated by a target instance of the load balancer.`Statistics`: The most useful statistic is `Sum`. Note that `Minimum`, `Maximum`, and `Average` all return `1`.`Unit`: The published unit is `Count`.
         * + **`UnhealthyHostCount`** - The number of target instances that are considered unhealthy.`Statistics`: The most useful statistic are `Average`, `Minimum`, and `Maximum`.`Unit`: The published unit is `Count`.
         */
        public var metricName: aws.sdk.kotlin.services.lightsail.model.LoadBalancerMetricName? = null
        /**
         * The granularity, in seconds, of the returned data points.
         */
        public var period: kotlin.Int = 0
        /**
         * The start time of the period.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The statistic for the metric.
         *
         * The following statistics are available:
         * + `Minimum` - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.
         * + `Maximum` - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.
         * + `Sum` - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.
         * + `Average` - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.
         * + `SampleCount` - The count, or number, of data points used for the statistical calculation.
         */
        public var statistics: List<MetricStatistic>? = null
        /**
         * The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units with each available metric, see the `metricName` parameter.
         */
        public var unit: aws.sdk.kotlin.services.lightsail.model.MetricUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.GetLoadBalancerMetricDataRequest) : this() {
            this.endTime = x.endTime
            this.loadBalancerName = x.loadBalancerName
            this.metricName = x.metricName
            this.period = x.period
            this.startTime = x.startTime
            this.statistics = x.statistics
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.GetLoadBalancerMetricDataRequest = GetLoadBalancerMetricDataRequest(this)
    }
}
