// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an instance snapshot.
 */
public class InstanceSnapshot private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the snapshot (e.g., `arn:aws:lightsail:us-east-2:123456789101:InstanceSnapshot/d23b5706-3322-4d83-81e5-12345EXAMPLE`).
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The timestamp when the snapshot was created (e.g., `1479907467.024`).
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An array of disk objects containing information about all block storage disks.
     */
    public val fromAttachedDisks: List<Disk>? = builder.fromAttachedDisks
    /**
     * The blueprint ID from which you created the snapshot (e.g., `os_debian_8_3`). A blueprint is a virtual private server (or *instance*) image used to create instances quickly.
     */
    public val fromBlueprintId: kotlin.String? = builder.fromBlueprintId
    /**
     * The bundle ID from which you created the snapshot (e.g., `micro_1_0`).
     */
    public val fromBundleId: kotlin.String? = builder.fromBundleId
    /**
     * The Amazon Resource Name (ARN) of the instance from which the snapshot was created (e.g., `arn:aws:lightsail:us-east-2:123456789101:Instance/64b8404c-ccb1-430b-8daf-12345EXAMPLE`).
     */
    public val fromInstanceArn: kotlin.String? = builder.fromInstanceArn
    /**
     * The instance from which the snapshot was created.
     */
    public val fromInstanceName: kotlin.String? = builder.fromInstanceName
    /**
     * A Boolean value indicating whether the snapshot was created from an automatic snapshot.
     */
    public val isFromAutoSnapshot: kotlin.Boolean? = builder.isFromAutoSnapshot
    /**
     * The region name and Availability Zone where you created the snapshot.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The name of the snapshot.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The progress of the snapshot.
     *
     * This is populated only for disk snapshots, and is `null` for instance snapshots.
     */
    public val progress: kotlin.String? = builder.progress
    /**
     * The type of resource (usually `InstanceSnapshot`).
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * The size in GB of the SSD.
     */
    public val sizeInGb: kotlin.Int? = builder.sizeInGb
    /**
     * The state the snapshot is in.
     */
    public val state: aws.sdk.kotlin.services.lightsail.model.InstanceSnapshotState? = builder.state
    /**
     * The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode
    /**
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.InstanceSnapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceSnapshot(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("fromAttachedDisks=$fromAttachedDisks,")
        append("fromBlueprintId=$fromBlueprintId,")
        append("fromBundleId=$fromBundleId,")
        append("fromInstanceArn=$fromInstanceArn,")
        append("fromInstanceName=$fromInstanceName,")
        append("isFromAutoSnapshot=$isFromAutoSnapshot,")
        append("location=$location,")
        append("name=$name,")
        append("progress=$progress,")
        append("resourceType=$resourceType,")
        append("sizeInGb=$sizeInGb,")
        append("state=$state,")
        append("supportCode=$supportCode,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (fromAttachedDisks?.hashCode() ?: 0)
        result = 31 * result + (fromBlueprintId?.hashCode() ?: 0)
        result = 31 * result + (fromBundleId?.hashCode() ?: 0)
        result = 31 * result + (fromInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (fromInstanceName?.hashCode() ?: 0)
        result = 31 * result + (isFromAutoSnapshot?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (progress?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sizeInGb ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceSnapshot

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (fromAttachedDisks != other.fromAttachedDisks) return false
        if (fromBlueprintId != other.fromBlueprintId) return false
        if (fromBundleId != other.fromBundleId) return false
        if (fromInstanceArn != other.fromInstanceArn) return false
        if (fromInstanceName != other.fromInstanceName) return false
        if (isFromAutoSnapshot != other.isFromAutoSnapshot) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (progress != other.progress) return false
        if (resourceType != other.resourceType) return false
        if (sizeInGb != other.sizeInGb) return false
        if (state != other.state) return false
        if (supportCode != other.supportCode) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.InstanceSnapshot = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the snapshot (e.g., `arn:aws:lightsail:us-east-2:123456789101:InstanceSnapshot/d23b5706-3322-4d83-81e5-12345EXAMPLE`).
         */
        public var arn: kotlin.String? = null
        /**
         * The timestamp when the snapshot was created (e.g., `1479907467.024`).
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An array of disk objects containing information about all block storage disks.
         */
        public var fromAttachedDisks: List<Disk>? = null
        /**
         * The blueprint ID from which you created the snapshot (e.g., `os_debian_8_3`). A blueprint is a virtual private server (or *instance*) image used to create instances quickly.
         */
        public var fromBlueprintId: kotlin.String? = null
        /**
         * The bundle ID from which you created the snapshot (e.g., `micro_1_0`).
         */
        public var fromBundleId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the instance from which the snapshot was created (e.g., `arn:aws:lightsail:us-east-2:123456789101:Instance/64b8404c-ccb1-430b-8daf-12345EXAMPLE`).
         */
        public var fromInstanceArn: kotlin.String? = null
        /**
         * The instance from which the snapshot was created.
         */
        public var fromInstanceName: kotlin.String? = null
        /**
         * A Boolean value indicating whether the snapshot was created from an automatic snapshot.
         */
        public var isFromAutoSnapshot: kotlin.Boolean? = null
        /**
         * The region name and Availability Zone where you created the snapshot.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The name of the snapshot.
         */
        public var name: kotlin.String? = null
        /**
         * The progress of the snapshot.
         *
         * This is populated only for disk snapshots, and is `null` for instance snapshots.
         */
        public var progress: kotlin.String? = null
        /**
         * The type of resource (usually `InstanceSnapshot`).
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * The size in GB of the SSD.
         */
        public var sizeInGb: kotlin.Int? = null
        /**
         * The state the snapshot is in.
         */
        public var state: aws.sdk.kotlin.services.lightsail.model.InstanceSnapshotState? = null
        /**
         * The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null
        /**
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.InstanceSnapshot) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.fromAttachedDisks = x.fromAttachedDisks
            this.fromBlueprintId = x.fromBlueprintId
            this.fromBundleId = x.fromBundleId
            this.fromInstanceArn = x.fromInstanceArn
            this.fromInstanceName = x.fromInstanceName
            this.isFromAutoSnapshot = x.isFromAutoSnapshot
            this.location = x.location
            this.name = x.name
            this.progress = x.progress
            this.resourceType = x.resourceType
            this.sizeInGb = x.sizeInGb
            this.state = x.state
            this.supportCode = x.supportCode
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.InstanceSnapshot = InstanceSnapshot(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }
    }
}
