// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an SSH key pair.
 */
public class KeyPair private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the key pair (e.g., `arn:aws:lightsail:us-east-2:123456789101:KeyPair/05859e3d-331d-48ba-9034-12345EXAMPLE`).
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The timestamp when the key pair was created (e.g., `1479816991.349`).
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The RSA fingerprint of the key pair.
     */
    public val fingerprint: kotlin.String? = builder.fingerprint
    /**
     * The region name and Availability Zone where the key pair was created.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The friendly name of the SSH key pair.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The resource type (usually `KeyPair`).
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode
    /**
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.KeyPair = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KeyPair(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("fingerprint=$fingerprint,")
        append("location=$location,")
        append("name=$name,")
        append("resourceType=$resourceType,")
        append("supportCode=$supportCode,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (fingerprint?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KeyPair

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (fingerprint != other.fingerprint) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (resourceType != other.resourceType) return false
        if (supportCode != other.supportCode) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.KeyPair = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the key pair (e.g., `arn:aws:lightsail:us-east-2:123456789101:KeyPair/05859e3d-331d-48ba-9034-12345EXAMPLE`).
         */
        public var arn: kotlin.String? = null
        /**
         * The timestamp when the key pair was created (e.g., `1479816991.349`).
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The RSA fingerprint of the key pair.
         */
        public var fingerprint: kotlin.String? = null
        /**
         * The region name and Availability Zone where the key pair was created.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The friendly name of the SSH key pair.
         */
        public var name: kotlin.String? = null
        /**
         * The resource type (usually `KeyPair`).
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null
        /**
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.KeyPair) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.fingerprint = x.fingerprint
            this.location = x.location
            this.name = x.name
            this.resourceType = x.resourceType
            this.supportCode = x.supportCode
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.KeyPair = KeyPair(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }
    }
}
