// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the configuration for an Amazon Lightsail container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories.
 *
 * For more information, see [Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access) in the *Amazon Lightsail Developer Guide*.
 */
public class PrivateRegistryAccess private constructor(builder: Builder) {
    /**
     * An object that describes the activation status of the role that you can use to grant a Lightsail container service access to Amazon ECR private repositories. If the role is activated, the Amazon Resource Name (ARN) of the role is also listed.
     */
    public val ecrImagePullerRole: aws.sdk.kotlin.services.lightsail.model.ContainerServiceEcrImagePullerRole? = builder.ecrImagePullerRole

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccess = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PrivateRegistryAccess(")
        append("ecrImagePullerRole=$ecrImagePullerRole")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ecrImagePullerRole?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PrivateRegistryAccess

        if (ecrImagePullerRole != other.ecrImagePullerRole) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccess = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that describes the activation status of the role that you can use to grant a Lightsail container service access to Amazon ECR private repositories. If the role is activated, the Amazon Resource Name (ARN) of the role is also listed.
         */
        public var ecrImagePullerRole: aws.sdk.kotlin.services.lightsail.model.ContainerServiceEcrImagePullerRole? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccess) : this() {
            this.ecrImagePullerRole = x.ecrImagePullerRole
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccess = PrivateRegistryAccess(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ContainerServiceEcrImagePullerRole] inside the given [block]
         */
        public fun ecrImagePullerRole(block: aws.sdk.kotlin.services.lightsail.model.ContainerServiceEcrImagePullerRole.Builder.() -> kotlin.Unit) {
            this.ecrImagePullerRole = aws.sdk.kotlin.services.lightsail.model.ContainerServiceEcrImagePullerRole.invoke(block)
        }
    }
}
