// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the delegation state of an Amazon Route 53 registered domain to Amazon Lightsail.
 *
 * When you delegate an Amazon Route 53 registered domain to Lightsail, you can manage the DNS of the domain using a Lightsail DNS zone. You no longer use the Route 53 hosted zone to manage the DNS of the domain. To delegate the domain, Lightsail automatically updates the domain's name servers in Route 53 to the name servers of the Lightsail DNS zone. Then, Lightsail automatically deletes the Route 53 hosted zone for the domain.
 *
 * All of the following conditions must be true for automatic domain delegation to be successful:
 * + The registered domain must be in the same Amazon Web Services account as the Lightsail account making the request.
 * + The user or entity making the request must have permission to manage domains in Route 53.
 * + The Route 53 hosted zone for the domain must be empty. It cannot contain DNS records other than start of authority (SOA) and name server records.
 *
 * If automatic domain delegation fails, or if you manage the DNS of your domain using a service other than Route 53, then you must manually add the Lightsail DNS zone name servers to your domain in order to delegate management of its DNS to Lightsail. For more information, see [Creating a DNS zone to manage your domain’s records in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-how-to-create-dns-entry) in the *Amazon Lightsail Developer Guide*.
 */
public class RegisteredDomainDelegationInfo private constructor(builder: Builder) {
    /**
     * An object that describes the state of the name server records that are automatically added to the Route 53 domain by Lightsail.
     */
    public val nameServersUpdateState: aws.sdk.kotlin.services.lightsail.model.NameServersUpdateState? = builder.nameServersUpdateState
    /**
     * Describes the deletion state of an Amazon Route 53 hosted zone for a domain that is being automatically delegated to an Amazon Lightsail DNS zone.
     */
    public val r53HostedZoneDeletionState: aws.sdk.kotlin.services.lightsail.model.R53HostedZoneDeletionState? = builder.r53HostedZoneDeletionState

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.RegisteredDomainDelegationInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisteredDomainDelegationInfo(")
        append("nameServersUpdateState=$nameServersUpdateState,")
        append("r53HostedZoneDeletionState=$r53HostedZoneDeletionState")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = nameServersUpdateState?.hashCode() ?: 0
        result = 31 * result + (r53HostedZoneDeletionState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisteredDomainDelegationInfo

        if (nameServersUpdateState != other.nameServersUpdateState) return false
        if (r53HostedZoneDeletionState != other.r53HostedZoneDeletionState) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.RegisteredDomainDelegationInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that describes the state of the name server records that are automatically added to the Route 53 domain by Lightsail.
         */
        public var nameServersUpdateState: aws.sdk.kotlin.services.lightsail.model.NameServersUpdateState? = null
        /**
         * Describes the deletion state of an Amazon Route 53 hosted zone for a domain that is being automatically delegated to an Amazon Lightsail DNS zone.
         */
        public var r53HostedZoneDeletionState: aws.sdk.kotlin.services.lightsail.model.R53HostedZoneDeletionState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.RegisteredDomainDelegationInfo) : this() {
            this.nameServersUpdateState = x.nameServersUpdateState
            this.r53HostedZoneDeletionState = x.r53HostedZoneDeletionState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.RegisteredDomainDelegationInfo = RegisteredDomainDelegationInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.NameServersUpdateState] inside the given [block]
         */
        public fun nameServersUpdateState(block: aws.sdk.kotlin.services.lightsail.model.NameServersUpdateState.Builder.() -> kotlin.Unit) {
            this.nameServersUpdateState = aws.sdk.kotlin.services.lightsail.model.NameServersUpdateState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.R53HostedZoneDeletionState] inside the given [block]
         */
        public fun r53HostedZoneDeletionState(block: aws.sdk.kotlin.services.lightsail.model.R53HostedZoneDeletionState.Builder.() -> kotlin.Unit) {
            this.r53HostedZoneDeletionState = aws.sdk.kotlin.services.lightsail.model.R53HostedZoneDeletionState.invoke(block)
        }
    }
}
