// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a database snapshot.
 */
public class RelationalDatabaseSnapshot private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the database snapshot.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The timestamp when the database snapshot was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The software of the database snapshot (for example, `MySQL`)
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The database engine version for the database snapshot (for example, `5.7.23`).
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The Amazon Resource Name (ARN) of the database from which the database snapshot was created.
     */
    public val fromRelationalDatabaseArn: kotlin.String? = builder.fromRelationalDatabaseArn
    /**
     * The blueprint ID of the database from which the database snapshot was created. A blueprint describes the major engine version of a database.
     */
    public val fromRelationalDatabaseBlueprintId: kotlin.String? = builder.fromRelationalDatabaseBlueprintId
    /**
     * The bundle ID of the database from which the database snapshot was created.
     */
    public val fromRelationalDatabaseBundleId: kotlin.String? = builder.fromRelationalDatabaseBundleId
    /**
     * The name of the source database from which the database snapshot was created.
     */
    public val fromRelationalDatabaseName: kotlin.String? = builder.fromRelationalDatabaseName
    /**
     * The Region name and Availability Zone where the database snapshot is located.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The name of the database snapshot.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Lightsail resource type.
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * The size of the disk in GB (for example, `32`) for the database snapshot.
     */
    public val sizeInGb: kotlin.Int? = builder.sizeInGb
    /**
     * The state of the database snapshot.
     */
    public val state: kotlin.String? = builder.state
    /**
     * The support code for the database snapshot. Include this code in your email to support when you have questions about a database snapshot in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode
    /**
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseSnapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RelationalDatabaseSnapshot(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("fromRelationalDatabaseArn=$fromRelationalDatabaseArn,")
        append("fromRelationalDatabaseBlueprintId=$fromRelationalDatabaseBlueprintId,")
        append("fromRelationalDatabaseBundleId=$fromRelationalDatabaseBundleId,")
        append("fromRelationalDatabaseName=$fromRelationalDatabaseName,")
        append("location=$location,")
        append("name=$name,")
        append("resourceType=$resourceType,")
        append("sizeInGb=$sizeInGb,")
        append("state=$state,")
        append("supportCode=$supportCode,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (fromRelationalDatabaseArn?.hashCode() ?: 0)
        result = 31 * result + (fromRelationalDatabaseBlueprintId?.hashCode() ?: 0)
        result = 31 * result + (fromRelationalDatabaseBundleId?.hashCode() ?: 0)
        result = 31 * result + (fromRelationalDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sizeInGb ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RelationalDatabaseSnapshot

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (fromRelationalDatabaseArn != other.fromRelationalDatabaseArn) return false
        if (fromRelationalDatabaseBlueprintId != other.fromRelationalDatabaseBlueprintId) return false
        if (fromRelationalDatabaseBundleId != other.fromRelationalDatabaseBundleId) return false
        if (fromRelationalDatabaseName != other.fromRelationalDatabaseName) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (resourceType != other.resourceType) return false
        if (sizeInGb != other.sizeInGb) return false
        if (state != other.state) return false
        if (supportCode != other.supportCode) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseSnapshot = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the database snapshot.
         */
        public var arn: kotlin.String? = null
        /**
         * The timestamp when the database snapshot was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The software of the database snapshot (for example, `MySQL`)
         */
        public var engine: kotlin.String? = null
        /**
         * The database engine version for the database snapshot (for example, `5.7.23`).
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the database from which the database snapshot was created.
         */
        public var fromRelationalDatabaseArn: kotlin.String? = null
        /**
         * The blueprint ID of the database from which the database snapshot was created. A blueprint describes the major engine version of a database.
         */
        public var fromRelationalDatabaseBlueprintId: kotlin.String? = null
        /**
         * The bundle ID of the database from which the database snapshot was created.
         */
        public var fromRelationalDatabaseBundleId: kotlin.String? = null
        /**
         * The name of the source database from which the database snapshot was created.
         */
        public var fromRelationalDatabaseName: kotlin.String? = null
        /**
         * The Region name and Availability Zone where the database snapshot is located.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The name of the database snapshot.
         */
        public var name: kotlin.String? = null
        /**
         * The Lightsail resource type.
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * The size of the disk in GB (for example, `32`) for the database snapshot.
         */
        public var sizeInGb: kotlin.Int? = null
        /**
         * The state of the database snapshot.
         */
        public var state: kotlin.String? = null
        /**
         * The support code for the database snapshot. Include this code in your email to support when you have questions about a database snapshot in Lightsail. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null
        /**
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseSnapshot) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.fromRelationalDatabaseArn = x.fromRelationalDatabaseArn
            this.fromRelationalDatabaseBlueprintId = x.fromRelationalDatabaseBlueprintId
            this.fromRelationalDatabaseBundleId = x.fromRelationalDatabaseBundleId
            this.fromRelationalDatabaseName = x.fromRelationalDatabaseName
            this.location = x.location
            this.name = x.name
            this.resourceType = x.resourceType
            this.sizeInGb = x.sizeInGb
            this.state = x.state
            this.supportCode = x.supportCode
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseSnapshot = RelationalDatabaseSnapshot(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }
    }
}
