// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lightsail.model.GetLoadBalancersResponse
import aws.sdk.kotlin.services.lightsail.model.LightsailException
import aws.sdk.kotlin.services.lightsail.model.LoadBalancer
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetLoadBalancersOperationDeserializer: HttpDeserialize<GetLoadBalancersResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetLoadBalancersResponse {
        if (!response.status.isSuccess()) {
            throwGetLoadBalancersError(context, response)
        }
        val builder = GetLoadBalancersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetLoadBalancersOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetLoadBalancersError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LightsailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AccountSetupInProgressException" -> AccountSetupInProgressExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationFailureException" -> OperationFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthenticatedException" -> UnauthenticatedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LightsailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetLoadBalancersOperationBody(builder: GetLoadBalancersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LOADBALANCERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("loadBalancers"))
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextPageToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LOADBALANCERS_DESCRIPTOR)
        field(NEXTPAGETOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LOADBALANCERS_DESCRIPTOR.index -> builder.loadBalancers =
                    deserializer.deserializeList(LOADBALANCERS_DESCRIPTOR) {
                        val col0 = mutableListOf<LoadBalancer>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLoadBalancerDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
