// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.location.model.*
import aws.sdk.kotlin.services.location.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Location"
public const val ServiceApiVersion: String = "2020-11-19"
public const val SdkVersion: String = "0.17.4-beta"

internal class DefaultLocationClient(override val config: LocationClient.Config) : LocationClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates an association between a geofence collection and a tracker resource. This allows the tracker resource to communicate location data to the linked geofence collection.
     *
     * You can associate up to five geofence collections to each tracker resource.
     *
     * Currently not supported — Cross-account configurations, such as creating associations between a tracker resource in one account and a geofence collection in another account.
     */
    override suspend fun associateTrackerConsumer(input: AssociateTrackerConsumerRequest): AssociateTrackerConsumerResponse {
        val op = SdkHttpOperation.build<AssociateTrackerConsumerRequest, AssociateTrackerConsumerResponse> {
            serializer = AssociateTrackerConsumerOperationSerializer()
            deserializer = AssociateTrackerConsumerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateTrackerConsumer"
                hostPrefix = "tracking."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the position history of one or more devices from a tracker resource.
     */
    override suspend fun batchDeleteDevicePositionHistory(input: BatchDeleteDevicePositionHistoryRequest): BatchDeleteDevicePositionHistoryResponse {
        val op = SdkHttpOperation.build<BatchDeleteDevicePositionHistoryRequest, BatchDeleteDevicePositionHistoryResponse> {
            serializer = BatchDeleteDevicePositionHistoryOperationSerializer()
            deserializer = BatchDeleteDevicePositionHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDeleteDevicePositionHistory"
                hostPrefix = "tracking."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a batch of geofences from a geofence collection.
     *
     * This operation deletes the resource permanently.
     */
    override suspend fun batchDeleteGeofence(input: BatchDeleteGeofenceRequest): BatchDeleteGeofenceResponse {
        val op = SdkHttpOperation.build<BatchDeleteGeofenceRequest, BatchDeleteGeofenceResponse> {
            serializer = BatchDeleteGeofenceOperationSerializer()
            deserializer = BatchDeleteGeofenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDeleteGeofence"
                hostPrefix = "geofencing."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Evaluates device positions against the geofence geometries from a given geofence collection.
     *
     * This operation always returns an empty response because geofences are asynchronously evaluated. The evaluation determines if the device has entered or exited a geofenced area, and then publishes one of the following events to Amazon EventBridge:
     * + `ENTER` if Amazon Location determines that the tracked device has entered a geofenced area.
     * + `EXIT` if Amazon Location determines that the tracked device has exited a geofenced area.
     *
     * The last geofence that a device was observed within is tracked for 30 days after the most recent device position update.
     *
     * Geofence evaluation uses the given device position. It does not account for the optional `Accuracy` of a `DevicePositionUpdate`.
     *
     * The `DeviceID` is used as a string to represent the device. You do not need to have a `Tracker` associated with the `DeviceID`.
     */
    override suspend fun batchEvaluateGeofences(input: BatchEvaluateGeofencesRequest): BatchEvaluateGeofencesResponse {
        val op = SdkHttpOperation.build<BatchEvaluateGeofencesRequest, BatchEvaluateGeofencesResponse> {
            serializer = BatchEvaluateGeofencesOperationSerializer()
            deserializer = BatchEvaluateGeofencesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchEvaluateGeofences"
                hostPrefix = "geofencing."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the latest device positions for requested devices.
     */
    override suspend fun batchGetDevicePosition(input: BatchGetDevicePositionRequest): BatchGetDevicePositionResponse {
        val op = SdkHttpOperation.build<BatchGetDevicePositionRequest, BatchGetDevicePositionResponse> {
            serializer = BatchGetDevicePositionOperationSerializer()
            deserializer = BatchGetDevicePositionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetDevicePosition"
                hostPrefix = "tracking."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A batch request for storing geofence geometries into a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.
     */
    override suspend fun batchPutGeofence(input: BatchPutGeofenceRequest): BatchPutGeofenceResponse {
        val op = SdkHttpOperation.build<BatchPutGeofenceRequest, BatchPutGeofenceResponse> {
            serializer = BatchPutGeofenceOperationSerializer()
            deserializer = BatchPutGeofenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchPutGeofence"
                hostPrefix = "geofencing."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Uploads position update data for one or more devices to a tracker resource. Amazon Location uses the data when it reports the last known device position and position history. Amazon Location retains location data for 30 days.
     *
     * Position updates are handled based on the `PositionFiltering` property of the tracker. When `PositionFiltering` is set to `TimeBased`, updates are evaluated against linked geofence collections, and location data is stored at a maximum of one position per 30 second interval. If your update frequency is more often than every 30 seconds, only one update per 30 seconds is stored for each unique device ID.
     *
     * When `PositionFiltering` is set to `DistanceBased` filtering, location data is stored and evaluated against linked geofence collections only if the device has moved more than 30 m (98.4 ft).
     *
     * When `PositionFiltering` is set to `AccuracyBased` filtering, location data is stored and evaluated against linked geofence collections only if the device has moved more than the measured accuracy. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is neither stored or evaluated if the device has moved less than 15 m. If `PositionFiltering` is set to `AccuracyBased` filtering, Amazon Location uses the default value `{ "Horizontal": 0}` when accuracy is not provided on a `DevicePositionUpdate`.
     */
    override suspend fun batchUpdateDevicePosition(input: BatchUpdateDevicePositionRequest): BatchUpdateDevicePositionResponse {
        val op = SdkHttpOperation.build<BatchUpdateDevicePositionRequest, BatchUpdateDevicePositionResponse> {
            serializer = BatchUpdateDevicePositionOperationSerializer()
            deserializer = BatchUpdateDevicePositionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchUpdateDevicePosition"
                hostPrefix = "tracking."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * [Calculates a route](https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html) given the following required parameters: `DeparturePosition` and `DestinationPosition`. Requires that you first [create a route calculator resource](https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html).
     *
     * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best traffic conditions when calculating the route.
     *
     * Additional options include:
     * + [Specifying a departure time](https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html) using either `DepartureTime` or `DepartNow`. This calculates a route based on predictive traffic data at the given time. You can't specify both `DepartureTime` and `DepartNow` in a single request. Specifying both parameters returns a validation error.
     * + [Specifying a travel mode](https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html) using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify additional route preferences in `CarModeOptions` if traveling by `Car`, or `TruckModeOptions` if traveling by `Truck`.
     */
    override suspend fun calculateRoute(input: CalculateRouteRequest): CalculateRouteResponse {
        val op = SdkHttpOperation.build<CalculateRouteRequest, CalculateRouteResponse> {
            serializer = CalculateRouteOperationSerializer()
            deserializer = CalculateRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CalculateRoute"
                hostPrefix = "routes."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * [ Calculates a route matrix](https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html) given the following required parameters: `DeparturePositions` and `DestinationPositions`. `CalculateRouteMatrix` calculates routes and returns the travel time and travel distance from each departure position to each destination position in the request. For example, given departure positions A and B, and destination positions X and Y, `CalculateRouteMatrix` will return time and distance for routes from A to X, A to Y, B to X, and B to Y (in that order). The number of results returned (and routes calculated) will be the number of `DeparturePositions` times the number of `DestinationPositions`.
     *
     * Your account is charged for each route calculated, not the number of requests.
     *
     * Requires that you first [create a route calculator resource](https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html).
     *
     * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best traffic conditions when calculating routes.
     *
     * Additional options include:
     * + [ Specifying a departure time](https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html) using either `DepartureTime` or `DepartNow`. This calculates routes based on predictive traffic data at the given time. You can't specify both `DepartureTime` and `DepartNow` in a single request. Specifying both parameters returns a validation error.
     * + [Specifying a travel mode](https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html) using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify additional route preferences in `CarModeOptions` if traveling by `Car`, or `TruckModeOptions` if traveling by `Truck`.
     */
    override suspend fun calculateRouteMatrix(input: CalculateRouteMatrixRequest): CalculateRouteMatrixResponse {
        val op = SdkHttpOperation.build<CalculateRouteMatrixRequest, CalculateRouteMatrixResponse> {
            serializer = CalculateRouteMatrixOperationSerializer()
            deserializer = CalculateRouteMatrixOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CalculateRouteMatrix"
                hostPrefix = "routes."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a geofence collection, which manages and stores geofences.
     */
    override suspend fun createGeofenceCollection(input: CreateGeofenceCollectionRequest): CreateGeofenceCollectionResponse {
        val op = SdkHttpOperation.build<CreateGeofenceCollectionRequest, CreateGeofenceCollectionResponse> {
            serializer = CreateGeofenceCollectionOperationSerializer()
            deserializer = CreateGeofenceCollectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGeofenceCollection"
                hostPrefix = "geofencing."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a map resource in your AWS account, which provides map tiles of different styles sourced from global location data providers.
     *
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the [AWS service terms](http://aws.amazon.com/service-terms) for more details.
     */
    override suspend fun createMap(input: CreateMapRequest): CreateMapResponse {
        val op = SdkHttpOperation.build<CreateMapRequest, CreateMapResponse> {
            serializer = CreateMapOperationSerializer()
            deserializer = CreateMapOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateMap"
                hostPrefix = "maps."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a place index resource in your AWS account. Use a place index resource to geocode addresses and other text queries by using the `SearchPlaceIndexForText` operation, and reverse geocode coordinates by using the `SearchPlaceIndexForPosition` operation, and enable autosuggestions by using the `SearchPlaceIndexForSuggestions` operation.
     *
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the [AWS service terms](http://aws.amazon.com/service-terms) for more details.
     */
    override suspend fun createPlaceIndex(input: CreatePlaceIndexRequest): CreatePlaceIndexResponse {
        val op = SdkHttpOperation.build<CreatePlaceIndexRequest, CreatePlaceIndexResponse> {
            serializer = CreatePlaceIndexOperationSerializer()
            deserializer = CreatePlaceIndexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePlaceIndex"
                hostPrefix = "places."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a route calculator resource in your AWS account.
     *
     * You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A route calculator sources traffic and road network data from your chosen data provider.
     *
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the [AWS service terms](http://aws.amazon.com/service-terms) for more details.
     */
    override suspend fun createRouteCalculator(input: CreateRouteCalculatorRequest): CreateRouteCalculatorResponse {
        val op = SdkHttpOperation.build<CreateRouteCalculatorRequest, CreateRouteCalculatorResponse> {
            serializer = CreateRouteCalculatorOperationSerializer()
            deserializer = CreateRouteCalculatorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRouteCalculator"
                hostPrefix = "routes."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a tracker resource in your AWS account, which lets you retrieve current and historical location of devices.
     */
    override suspend fun createTracker(input: CreateTrackerRequest): CreateTrackerResponse {
        val op = SdkHttpOperation.build<CreateTrackerRequest, CreateTrackerResponse> {
            serializer = CreateTrackerOperationSerializer()
            deserializer = CreateTrackerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTracker"
                hostPrefix = "tracking."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a geofence collection from your AWS account.
     *
     * This operation deletes the resource permanently. If the geofence collection is the target of a tracker resource, the devices will no longer be monitored.
     */
    override suspend fun deleteGeofenceCollection(input: DeleteGeofenceCollectionRequest): DeleteGeofenceCollectionResponse {
        val op = SdkHttpOperation.build<DeleteGeofenceCollectionRequest, DeleteGeofenceCollectionResponse> {
            serializer = DeleteGeofenceCollectionOperationSerializer()
            deserializer = DeleteGeofenceCollectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGeofenceCollection"
                hostPrefix = "geofencing."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a map resource from your AWS account.
     *
     * This operation deletes the resource permanently. If the map is being used in an application, the map may not render.
     */
    override suspend fun deleteMap(input: DeleteMapRequest): DeleteMapResponse {
        val op = SdkHttpOperation.build<DeleteMapRequest, DeleteMapResponse> {
            serializer = DeleteMapOperationSerializer()
            deserializer = DeleteMapOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMap"
                hostPrefix = "maps."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a place index resource from your AWS account.
     *
     * This operation deletes the resource permanently.
     */
    override suspend fun deletePlaceIndex(input: DeletePlaceIndexRequest): DeletePlaceIndexResponse {
        val op = SdkHttpOperation.build<DeletePlaceIndexRequest, DeletePlaceIndexResponse> {
            serializer = DeletePlaceIndexOperationSerializer()
            deserializer = DeletePlaceIndexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePlaceIndex"
                hostPrefix = "places."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a route calculator resource from your AWS account.
     *
     * This operation deletes the resource permanently.
     */
    override suspend fun deleteRouteCalculator(input: DeleteRouteCalculatorRequest): DeleteRouteCalculatorResponse {
        val op = SdkHttpOperation.build<DeleteRouteCalculatorRequest, DeleteRouteCalculatorResponse> {
            serializer = DeleteRouteCalculatorOperationSerializer()
            deserializer = DeleteRouteCalculatorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRouteCalculator"
                hostPrefix = "routes."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a tracker resource from your AWS account.
     *
     * This operation deletes the resource permanently. If the tracker resource is in use, you may encounter an error. Make sure that the target resource isn't a dependency for your applications.
     */
    override suspend fun deleteTracker(input: DeleteTrackerRequest): DeleteTrackerResponse {
        val op = SdkHttpOperation.build<DeleteTrackerRequest, DeleteTrackerResponse> {
            serializer = DeleteTrackerOperationSerializer()
            deserializer = DeleteTrackerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTracker"
                hostPrefix = "tracking."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the geofence collection details.
     */
    override suspend fun describeGeofenceCollection(input: DescribeGeofenceCollectionRequest): DescribeGeofenceCollectionResponse {
        val op = SdkHttpOperation.build<DescribeGeofenceCollectionRequest, DescribeGeofenceCollectionResponse> {
            serializer = DescribeGeofenceCollectionOperationSerializer()
            deserializer = DescribeGeofenceCollectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeGeofenceCollection"
                hostPrefix = "geofencing."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the map resource details.
     */
    override suspend fun describeMap(input: DescribeMapRequest): DescribeMapResponse {
        val op = SdkHttpOperation.build<DescribeMapRequest, DescribeMapResponse> {
            serializer = DescribeMapOperationSerializer()
            deserializer = DescribeMapOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeMap"
                hostPrefix = "maps."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the place index resource details.
     */
    override suspend fun describePlaceIndex(input: DescribePlaceIndexRequest): DescribePlaceIndexResponse {
        val op = SdkHttpOperation.build<DescribePlaceIndexRequest, DescribePlaceIndexResponse> {
            serializer = DescribePlaceIndexOperationSerializer()
            deserializer = DescribePlaceIndexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePlaceIndex"
                hostPrefix = "places."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the route calculator resource details.
     */
    override suspend fun describeRouteCalculator(input: DescribeRouteCalculatorRequest): DescribeRouteCalculatorResponse {
        val op = SdkHttpOperation.build<DescribeRouteCalculatorRequest, DescribeRouteCalculatorResponse> {
            serializer = DescribeRouteCalculatorOperationSerializer()
            deserializer = DescribeRouteCalculatorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRouteCalculator"
                hostPrefix = "routes."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the tracker resource details.
     */
    override suspend fun describeTracker(input: DescribeTrackerRequest): DescribeTrackerResponse {
        val op = SdkHttpOperation.build<DescribeTrackerRequest, DescribeTrackerResponse> {
            serializer = DescribeTrackerOperationSerializer()
            deserializer = DescribeTrackerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTracker"
                hostPrefix = "tracking."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the association between a tracker resource and a geofence collection.
     *
     * Once you unlink a tracker resource from a geofence collection, the tracker positions will no longer be automatically evaluated against geofences.
     */
    override suspend fun disassociateTrackerConsumer(input: DisassociateTrackerConsumerRequest): DisassociateTrackerConsumerResponse {
        val op = SdkHttpOperation.build<DisassociateTrackerConsumerRequest, DisassociateTrackerConsumerResponse> {
            serializer = DisassociateTrackerConsumerOperationSerializer()
            deserializer = DisassociateTrackerConsumerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateTrackerConsumer"
                hostPrefix = "tracking."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a device's most recent position according to its sample time.
     *
     * Device positions are deleted after 30 days.
     */
    override suspend fun getDevicePosition(input: GetDevicePositionRequest): GetDevicePositionResponse {
        val op = SdkHttpOperation.build<GetDevicePositionRequest, GetDevicePositionResponse> {
            serializer = GetDevicePositionOperationSerializer()
            deserializer = GetDevicePositionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDevicePosition"
                hostPrefix = "tracking."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the device position history from a tracker resource within a specified range of time.
     *
     * Device positions are deleted after 30 days.
     */
    override suspend fun getDevicePositionHistory(input: GetDevicePositionHistoryRequest): GetDevicePositionHistoryResponse {
        val op = SdkHttpOperation.build<GetDevicePositionHistoryRequest, GetDevicePositionHistoryResponse> {
            serializer = GetDevicePositionHistoryOperationSerializer()
            deserializer = GetDevicePositionHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDevicePositionHistory"
                hostPrefix = "tracking."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the geofence details from a geofence collection.
     */
    override suspend fun getGeofence(input: GetGeofenceRequest): GetGeofenceResponse {
        val op = SdkHttpOperation.build<GetGeofenceRequest, GetGeofenceResponse> {
            serializer = GetGeofenceOperationSerializer()
            deserializer = GetGeofenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGeofence"
                hostPrefix = "geofencing."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves glyphs used to display labels on a map.
     */
    override suspend fun getMapGlyphs(input: GetMapGlyphsRequest): GetMapGlyphsResponse {
        val op = SdkHttpOperation.build<GetMapGlyphsRequest, GetMapGlyphsResponse> {
            serializer = GetMapGlyphsOperationSerializer()
            deserializer = GetMapGlyphsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMapGlyphs"
                hostPrefix = "maps."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG image paired with a JSON document describing the offsets of individual icons that will be displayed on a rendered map.
     */
    override suspend fun getMapSprites(input: GetMapSpritesRequest): GetMapSpritesResponse {
        val op = SdkHttpOperation.build<GetMapSpritesRequest, GetMapSpritesResponse> {
            serializer = GetMapSpritesOperationSerializer()
            deserializer = GetMapSpritesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMapSprites"
                hostPrefix = "maps."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the map style descriptor from a map resource.
     *
     * The style descriptor contains speciﬁcations on how features render on a map. For example, what data to display, what order to display the data in, and the style for the data. Style descriptors follow the Mapbox Style Specification.
     */
    override suspend fun getMapStyleDescriptor(input: GetMapStyleDescriptorRequest): GetMapStyleDescriptorResponse {
        val op = SdkHttpOperation.build<GetMapStyleDescriptorRequest, GetMapStyleDescriptorResponse> {
            serializer = GetMapStyleDescriptorOperationSerializer()
            deserializer = GetMapStyleDescriptorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMapStyleDescriptor"
                hostPrefix = "maps."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a vector data tile from the map resource. Map tiles are used by clients to render a map. they're addressed using a grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level.
     *
     * The origin (0, 0) is the top left of the map. Increasing the zoom level by 1 doubles both the X and Y dimensions, so a tile containing data for the entire world at (0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1, 1/1/0, 1/1/1).
     */
    override suspend fun getMapTile(input: GetMapTileRequest): GetMapTileResponse {
        val op = SdkHttpOperation.build<GetMapTileRequest, GetMapTileResponse> {
            serializer = GetMapTileOperationSerializer()
            deserializer = GetMapTileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMapTile"
                hostPrefix = "maps."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A batch request to retrieve all device positions.
     */
    override suspend fun listDevicePositions(input: ListDevicePositionsRequest): ListDevicePositionsResponse {
        val op = SdkHttpOperation.build<ListDevicePositionsRequest, ListDevicePositionsResponse> {
            serializer = ListDevicePositionsOperationSerializer()
            deserializer = ListDevicePositionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDevicePositions"
                hostPrefix = "tracking."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists geofence collections in your AWS account.
     */
    override suspend fun listGeofenceCollections(input: ListGeofenceCollectionsRequest): ListGeofenceCollectionsResponse {
        val op = SdkHttpOperation.build<ListGeofenceCollectionsRequest, ListGeofenceCollectionsResponse> {
            serializer = ListGeofenceCollectionsOperationSerializer()
            deserializer = ListGeofenceCollectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGeofenceCollections"
                hostPrefix = "geofencing."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists geofences stored in a given geofence collection.
     */
    override suspend fun listGeofences(input: ListGeofencesRequest): ListGeofencesResponse {
        val op = SdkHttpOperation.build<ListGeofencesRequest, ListGeofencesResponse> {
            serializer = ListGeofencesOperationSerializer()
            deserializer = ListGeofencesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGeofences"
                hostPrefix = "geofencing."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists map resources in your AWS account.
     */
    override suspend fun listMaps(input: ListMapsRequest): ListMapsResponse {
        val op = SdkHttpOperation.build<ListMapsRequest, ListMapsResponse> {
            serializer = ListMapsOperationSerializer()
            deserializer = ListMapsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMaps"
                hostPrefix = "maps."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists place index resources in your AWS account.
     */
    override suspend fun listPlaceIndexes(input: ListPlaceIndexesRequest): ListPlaceIndexesResponse {
        val op = SdkHttpOperation.build<ListPlaceIndexesRequest, ListPlaceIndexesResponse> {
            serializer = ListPlaceIndexesOperationSerializer()
            deserializer = ListPlaceIndexesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPlaceIndexes"
                hostPrefix = "places."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists route calculator resources in your AWS account.
     */
    override suspend fun listRouteCalculators(input: ListRouteCalculatorsRequest): ListRouteCalculatorsResponse {
        val op = SdkHttpOperation.build<ListRouteCalculatorsRequest, ListRouteCalculatorsResponse> {
            serializer = ListRouteCalculatorsOperationSerializer()
            deserializer = ListRouteCalculatorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRouteCalculators"
                hostPrefix = "routes."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of tags that are applied to the specified Amazon Location resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
                hostPrefix = "metadata."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists geofence collections currently associated to the given tracker resource.
     */
    override suspend fun listTrackerConsumers(input: ListTrackerConsumersRequest): ListTrackerConsumersResponse {
        val op = SdkHttpOperation.build<ListTrackerConsumersRequest, ListTrackerConsumersResponse> {
            serializer = ListTrackerConsumersOperationSerializer()
            deserializer = ListTrackerConsumersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTrackerConsumers"
                hostPrefix = "tracking."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists tracker resources in your AWS account.
     */
    override suspend fun listTrackers(input: ListTrackersRequest): ListTrackersResponse {
        val op = SdkHttpOperation.build<ListTrackersRequest, ListTrackersResponse> {
            serializer = ListTrackersOperationSerializer()
            deserializer = ListTrackersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTrackers"
                hostPrefix = "tracking."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.
     */
    override suspend fun putGeofence(input: PutGeofenceRequest): PutGeofenceResponse {
        val op = SdkHttpOperation.build<PutGeofenceRequest, PutGeofenceResponse> {
            serializer = PutGeofenceOperationSerializer()
            deserializer = PutGeofenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutGeofence"
                hostPrefix = "geofencing."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Reverse geocodes a given coordinate and returns a legible address. Allows you to search for Places or points of interest near a given position.
     */
    override suspend fun searchPlaceIndexForPosition(input: SearchPlaceIndexForPositionRequest): SearchPlaceIndexForPositionResponse {
        val op = SdkHttpOperation.build<SearchPlaceIndexForPositionRequest, SearchPlaceIndexForPositionResponse> {
            serializer = SearchPlaceIndexForPositionOperationSerializer()
            deserializer = SearchPlaceIndexForPositionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchPlaceIndexForPosition"
                hostPrefix = "places."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Generates suggestions for addresses and points of interest based on partial or misspelled free-form text. This operation is also known as autocomplete, autosuggest, or fuzzy matching.
     *
     * Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a specific position on the globe.
     *
     * You can search for suggested place names near a specified position by using `BiasPosition`, or filter results within a bounding box by using `FilterBBox`. These parameters are mutually exclusive; using both `BiasPosition` and `FilterBBox` in the same command returns an error.
     */
    override suspend fun searchPlaceIndexForSuggestions(input: SearchPlaceIndexForSuggestionsRequest): SearchPlaceIndexForSuggestionsResponse {
        val op = SdkHttpOperation.build<SearchPlaceIndexForSuggestionsRequest, SearchPlaceIndexForSuggestionsResponse> {
            serializer = SearchPlaceIndexForSuggestionsOperationSerializer()
            deserializer = SearchPlaceIndexForSuggestionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchPlaceIndexForSuggestions"
                hostPrefix = "places."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Geocodes free-form text, such as an address, name, city, or region to allow you to search for Places or points of interest.
     *
     * Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a specific position on the globe.
     *
     * You can search for places near a given position using `BiasPosition`, or filter results within a bounding box using `FilterBBox`. Providing both parameters simultaneously returns an error.
     *
     * Search results are returned in order of highest to lowest relevance.
     */
    override suspend fun searchPlaceIndexForText(input: SearchPlaceIndexForTextRequest): SearchPlaceIndexForTextResponse {
        val op = SdkHttpOperation.build<SearchPlaceIndexForTextRequest, SearchPlaceIndexForTextResponse> {
            serializer = SearchPlaceIndexForTextOperationSerializer()
            deserializer = SearchPlaceIndexForTextOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchPlaceIndexForText"
                hostPrefix = "places."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Assigns one or more tags (key-value pairs) to the specified Amazon Location Service resource.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values.
     *
     * You can use the `TagResource` operation with an Amazon Location Service resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the tags already associated with the resource. If you specify a tag key that's already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     *
     * You can associate up to 50 tags with a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
                hostPrefix = "metadata."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from the specified Amazon Location resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
                hostPrefix = "metadata."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified properties of a given geofence collection.
     */
    override suspend fun updateGeofenceCollection(input: UpdateGeofenceCollectionRequest): UpdateGeofenceCollectionResponse {
        val op = SdkHttpOperation.build<UpdateGeofenceCollectionRequest, UpdateGeofenceCollectionResponse> {
            serializer = UpdateGeofenceCollectionOperationSerializer()
            deserializer = UpdateGeofenceCollectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGeofenceCollection"
                hostPrefix = "geofencing."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified properties of a given map resource.
     */
    override suspend fun updateMap(input: UpdateMapRequest): UpdateMapResponse {
        val op = SdkHttpOperation.build<UpdateMapRequest, UpdateMapResponse> {
            serializer = UpdateMapOperationSerializer()
            deserializer = UpdateMapOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMap"
                hostPrefix = "maps."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified properties of a given place index resource.
     */
    override suspend fun updatePlaceIndex(input: UpdatePlaceIndexRequest): UpdatePlaceIndexResponse {
        val op = SdkHttpOperation.build<UpdatePlaceIndexRequest, UpdatePlaceIndexResponse> {
            serializer = UpdatePlaceIndexOperationSerializer()
            deserializer = UpdatePlaceIndexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePlaceIndex"
                hostPrefix = "places."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified properties for a given route calculator resource.
     */
    override suspend fun updateRouteCalculator(input: UpdateRouteCalculatorRequest): UpdateRouteCalculatorResponse {
        val op = SdkHttpOperation.build<UpdateRouteCalculatorRequest, UpdateRouteCalculatorResponse> {
            serializer = UpdateRouteCalculatorOperationSerializer()
            deserializer = UpdateRouteCalculatorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRouteCalculator"
                hostPrefix = "routes."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified properties of a given tracker resource.
     */
    override suspend fun updateTracker(input: UpdateTrackerRequest): UpdateTrackerResponse {
        val op = SdkHttpOperation.build<UpdateTrackerRequest, UpdateTrackerResponse> {
            serializer = UpdateTrackerOperationSerializer()
            deserializer = UpdateTrackerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTracker"
                hostPrefix = "tracking."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "geo"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "geo")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
