// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.location.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.location.model.*
import aws.sdk.kotlin.services.location.model.AssociateTrackerConsumerRequest
import aws.sdk.kotlin.services.location.model.AssociateTrackerConsumerResponse
import aws.sdk.kotlin.services.location.model.BatchDeleteDevicePositionHistoryRequest
import aws.sdk.kotlin.services.location.model.BatchDeleteDevicePositionHistoryResponse
import aws.sdk.kotlin.services.location.model.BatchDeleteGeofenceRequest
import aws.sdk.kotlin.services.location.model.BatchDeleteGeofenceResponse
import aws.sdk.kotlin.services.location.model.BatchEvaluateGeofencesRequest
import aws.sdk.kotlin.services.location.model.BatchEvaluateGeofencesResponse
import aws.sdk.kotlin.services.location.model.BatchGetDevicePositionRequest
import aws.sdk.kotlin.services.location.model.BatchGetDevicePositionResponse
import aws.sdk.kotlin.services.location.model.BatchPutGeofenceRequest
import aws.sdk.kotlin.services.location.model.BatchPutGeofenceResponse
import aws.sdk.kotlin.services.location.model.BatchUpdateDevicePositionRequest
import aws.sdk.kotlin.services.location.model.BatchUpdateDevicePositionResponse
import aws.sdk.kotlin.services.location.model.CalculateRouteMatrixRequest
import aws.sdk.kotlin.services.location.model.CalculateRouteMatrixResponse
import aws.sdk.kotlin.services.location.model.CalculateRouteRequest
import aws.sdk.kotlin.services.location.model.CalculateRouteResponse
import aws.sdk.kotlin.services.location.model.CreateGeofenceCollectionRequest
import aws.sdk.kotlin.services.location.model.CreateGeofenceCollectionResponse
import aws.sdk.kotlin.services.location.model.CreateMapRequest
import aws.sdk.kotlin.services.location.model.CreateMapResponse
import aws.sdk.kotlin.services.location.model.CreatePlaceIndexRequest
import aws.sdk.kotlin.services.location.model.CreatePlaceIndexResponse
import aws.sdk.kotlin.services.location.model.CreateRouteCalculatorRequest
import aws.sdk.kotlin.services.location.model.CreateRouteCalculatorResponse
import aws.sdk.kotlin.services.location.model.CreateTrackerRequest
import aws.sdk.kotlin.services.location.model.CreateTrackerResponse
import aws.sdk.kotlin.services.location.model.DeleteGeofenceCollectionRequest
import aws.sdk.kotlin.services.location.model.DeleteGeofenceCollectionResponse
import aws.sdk.kotlin.services.location.model.DeleteMapRequest
import aws.sdk.kotlin.services.location.model.DeleteMapResponse
import aws.sdk.kotlin.services.location.model.DeletePlaceIndexRequest
import aws.sdk.kotlin.services.location.model.DeletePlaceIndexResponse
import aws.sdk.kotlin.services.location.model.DeleteRouteCalculatorRequest
import aws.sdk.kotlin.services.location.model.DeleteRouteCalculatorResponse
import aws.sdk.kotlin.services.location.model.DeleteTrackerRequest
import aws.sdk.kotlin.services.location.model.DeleteTrackerResponse
import aws.sdk.kotlin.services.location.model.DescribeGeofenceCollectionRequest
import aws.sdk.kotlin.services.location.model.DescribeGeofenceCollectionResponse
import aws.sdk.kotlin.services.location.model.DescribeMapRequest
import aws.sdk.kotlin.services.location.model.DescribeMapResponse
import aws.sdk.kotlin.services.location.model.DescribePlaceIndexRequest
import aws.sdk.kotlin.services.location.model.DescribePlaceIndexResponse
import aws.sdk.kotlin.services.location.model.DescribeRouteCalculatorRequest
import aws.sdk.kotlin.services.location.model.DescribeRouteCalculatorResponse
import aws.sdk.kotlin.services.location.model.DescribeTrackerRequest
import aws.sdk.kotlin.services.location.model.DescribeTrackerResponse
import aws.sdk.kotlin.services.location.model.DisassociateTrackerConsumerRequest
import aws.sdk.kotlin.services.location.model.DisassociateTrackerConsumerResponse
import aws.sdk.kotlin.services.location.model.GetDevicePositionHistoryRequest
import aws.sdk.kotlin.services.location.model.GetDevicePositionHistoryResponse
import aws.sdk.kotlin.services.location.model.GetDevicePositionRequest
import aws.sdk.kotlin.services.location.model.GetDevicePositionResponse
import aws.sdk.kotlin.services.location.model.GetGeofenceRequest
import aws.sdk.kotlin.services.location.model.GetGeofenceResponse
import aws.sdk.kotlin.services.location.model.GetMapGlyphsRequest
import aws.sdk.kotlin.services.location.model.GetMapGlyphsResponse
import aws.sdk.kotlin.services.location.model.GetMapSpritesRequest
import aws.sdk.kotlin.services.location.model.GetMapSpritesResponse
import aws.sdk.kotlin.services.location.model.GetMapStyleDescriptorRequest
import aws.sdk.kotlin.services.location.model.GetMapStyleDescriptorResponse
import aws.sdk.kotlin.services.location.model.GetMapTileRequest
import aws.sdk.kotlin.services.location.model.GetMapTileResponse
import aws.sdk.kotlin.services.location.model.ListDevicePositionsRequest
import aws.sdk.kotlin.services.location.model.ListDevicePositionsResponse
import aws.sdk.kotlin.services.location.model.ListGeofenceCollectionsRequest
import aws.sdk.kotlin.services.location.model.ListGeofenceCollectionsResponse
import aws.sdk.kotlin.services.location.model.ListGeofencesRequest
import aws.sdk.kotlin.services.location.model.ListGeofencesResponse
import aws.sdk.kotlin.services.location.model.ListMapsRequest
import aws.sdk.kotlin.services.location.model.ListMapsResponse
import aws.sdk.kotlin.services.location.model.ListPlaceIndexesRequest
import aws.sdk.kotlin.services.location.model.ListPlaceIndexesResponse
import aws.sdk.kotlin.services.location.model.ListRouteCalculatorsRequest
import aws.sdk.kotlin.services.location.model.ListRouteCalculatorsResponse
import aws.sdk.kotlin.services.location.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.location.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.location.model.ListTrackerConsumersRequest
import aws.sdk.kotlin.services.location.model.ListTrackerConsumersResponse
import aws.sdk.kotlin.services.location.model.ListTrackersRequest
import aws.sdk.kotlin.services.location.model.ListTrackersResponse
import aws.sdk.kotlin.services.location.model.PutGeofenceRequest
import aws.sdk.kotlin.services.location.model.PutGeofenceResponse
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForPositionRequest
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForPositionResponse
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForSuggestionsRequest
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForSuggestionsResponse
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForTextRequest
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForTextResponse
import aws.sdk.kotlin.services.location.model.TagResourceRequest
import aws.sdk.kotlin.services.location.model.TagResourceResponse
import aws.sdk.kotlin.services.location.model.UntagResourceRequest
import aws.sdk.kotlin.services.location.model.UntagResourceResponse
import aws.sdk.kotlin.services.location.model.UpdateGeofenceCollectionRequest
import aws.sdk.kotlin.services.location.model.UpdateGeofenceCollectionResponse
import aws.sdk.kotlin.services.location.model.UpdateMapRequest
import aws.sdk.kotlin.services.location.model.UpdateMapResponse
import aws.sdk.kotlin.services.location.model.UpdatePlaceIndexRequest
import aws.sdk.kotlin.services.location.model.UpdatePlaceIndexResponse
import aws.sdk.kotlin.services.location.model.UpdateRouteCalculatorRequest
import aws.sdk.kotlin.services.location.model.UpdateRouteCalculatorResponse
import aws.sdk.kotlin.services.location.model.UpdateTrackerRequest
import aws.sdk.kotlin.services.location.model.UpdateTrackerResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Suite of geospatial services including Maps, Places, Routes, Tracking, and Geofencing
 */
public interface LocationClient : SdkClient {

    override val serviceName: String
        get() = "Location"
    /**
     * LocationClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): LocationClient {
            val config = Config.Builder().apply(block).build()
            return DefaultLocationClient(config)
        }

        public operator fun invoke(config: Config): LocationClient = DefaultLocationClient(config)

        /**
         * Construct a [LocationClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): LocationClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultLocationClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an association between a geofence collection and a tracker resource. This allows the tracker resource to communicate location data to the linked geofence collection.
     *
     * You can associate up to five geofence collections to each tracker resource.
     *
     * Currently not supported — Cross-account configurations, such as creating associations between a tracker resource in one account and a geofence collection in another account.
     */
    public suspend fun associateTrackerConsumer(input: AssociateTrackerConsumerRequest): AssociateTrackerConsumerResponse

    /**
     * Deletes the position history of one or more devices from a tracker resource.
     */
    public suspend fun batchDeleteDevicePositionHistory(input: BatchDeleteDevicePositionHistoryRequest): BatchDeleteDevicePositionHistoryResponse

    /**
     * Deletes a batch of geofences from a geofence collection.
     *
     * This operation deletes the resource permanently.
     */
    public suspend fun batchDeleteGeofence(input: BatchDeleteGeofenceRequest): BatchDeleteGeofenceResponse

    /**
     * Evaluates device positions against the geofence geometries from a given geofence collection.
     *
     * This operation always returns an empty response because geofences are asynchronously evaluated. The evaluation determines if the device has entered or exited a geofenced area, and then publishes one of the following events to Amazon EventBridge:
     * + `ENTER` if Amazon Location determines that the tracked device has entered a geofenced area.
     * + `EXIT` if Amazon Location determines that the tracked device has exited a geofenced area.
     *
     * The last geofence that a device was observed within is tracked for 30 days after the most recent device position update.
     *
     * Geofence evaluation uses the given device position. It does not account for the optional `Accuracy` of a `DevicePositionUpdate`.
     *
     * The `DeviceID` is used as a string to represent the device. You do not need to have a `Tracker` associated with the `DeviceID`.
     */
    public suspend fun batchEvaluateGeofences(input: BatchEvaluateGeofencesRequest): BatchEvaluateGeofencesResponse

    /**
     * Lists the latest device positions for requested devices.
     */
    public suspend fun batchGetDevicePosition(input: BatchGetDevicePositionRequest): BatchGetDevicePositionResponse

    /**
     * A batch request for storing geofence geometries into a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.
     */
    public suspend fun batchPutGeofence(input: BatchPutGeofenceRequest): BatchPutGeofenceResponse

    /**
     * Uploads position update data for one or more devices to a tracker resource. Amazon Location uses the data when it reports the last known device position and position history. Amazon Location retains location data for 30 days.
     *
     * Position updates are handled based on the `PositionFiltering` property of the tracker. When `PositionFiltering` is set to `TimeBased`, updates are evaluated against linked geofence collections, and location data is stored at a maximum of one position per 30 second interval. If your update frequency is more often than every 30 seconds, only one update per 30 seconds is stored for each unique device ID.
     *
     * When `PositionFiltering` is set to `DistanceBased` filtering, location data is stored and evaluated against linked geofence collections only if the device has moved more than 30 m (98.4 ft).
     *
     * When `PositionFiltering` is set to `AccuracyBased` filtering, location data is stored and evaluated against linked geofence collections only if the device has moved more than the measured accuracy. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is neither stored or evaluated if the device has moved less than 15 m. If `PositionFiltering` is set to `AccuracyBased` filtering, Amazon Location uses the default value `{ "Horizontal": 0}` when accuracy is not provided on a `DevicePositionUpdate`.
     */
    public suspend fun batchUpdateDevicePosition(input: BatchUpdateDevicePositionRequest): BatchUpdateDevicePositionResponse

    /**
     * [Calculates a route](https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html) given the following required parameters: `DeparturePosition` and `DestinationPosition`. Requires that you first [create a route calculator resource](https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html).
     *
     * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best traffic conditions when calculating the route.
     *
     * Additional options include:
     * + [Specifying a departure time](https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html) using either `DepartureTime` or `DepartNow`. This calculates a route based on predictive traffic data at the given time. You can't specify both `DepartureTime` and `DepartNow` in a single request. Specifying both parameters returns a validation error.
     * + [Specifying a travel mode](https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html) using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify additional route preferences in `CarModeOptions` if traveling by `Car`, or `TruckModeOptions` if traveling by `Truck`.
     */
    public suspend fun calculateRoute(input: CalculateRouteRequest): CalculateRouteResponse

    /**
     * [ Calculates a route matrix](https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html) given the following required parameters: `DeparturePositions` and `DestinationPositions`. `CalculateRouteMatrix` calculates routes and returns the travel time and travel distance from each departure position to each destination position in the request. For example, given departure positions A and B, and destination positions X and Y, `CalculateRouteMatrix` will return time and distance for routes from A to X, A to Y, B to X, and B to Y (in that order). The number of results returned (and routes calculated) will be the number of `DeparturePositions` times the number of `DestinationPositions`.
     *
     * Your account is charged for each route calculated, not the number of requests.
     *
     * Requires that you first [create a route calculator resource](https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html).
     *
     * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best traffic conditions when calculating routes.
     *
     * Additional options include:
     * + [ Specifying a departure time](https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html) using either `DepartureTime` or `DepartNow`. This calculates routes based on predictive traffic data at the given time. You can't specify both `DepartureTime` and `DepartNow` in a single request. Specifying both parameters returns a validation error.
     * + [Specifying a travel mode](https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html) using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify additional route preferences in `CarModeOptions` if traveling by `Car`, or `TruckModeOptions` if traveling by `Truck`.
     */
    public suspend fun calculateRouteMatrix(input: CalculateRouteMatrixRequest): CalculateRouteMatrixResponse

    /**
     * Creates a geofence collection, which manages and stores geofences.
     */
    public suspend fun createGeofenceCollection(input: CreateGeofenceCollectionRequest): CreateGeofenceCollectionResponse

    /**
     * Creates a map resource in your AWS account, which provides map tiles of different styles sourced from global location data providers.
     *
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the [AWS service terms](http://aws.amazon.com/service-terms) for more details.
     */
    public suspend fun createMap(input: CreateMapRequest): CreateMapResponse

    /**
     * Creates a place index resource in your AWS account. Use a place index resource to geocode addresses and other text queries by using the `SearchPlaceIndexForText` operation, and reverse geocode coordinates by using the `SearchPlaceIndexForPosition` operation, and enable autosuggestions by using the `SearchPlaceIndexForSuggestions` operation.
     *
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the [AWS service terms](http://aws.amazon.com/service-terms) for more details.
     */
    public suspend fun createPlaceIndex(input: CreatePlaceIndexRequest): CreatePlaceIndexResponse

    /**
     * Creates a route calculator resource in your AWS account.
     *
     * You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A route calculator sources traffic and road network data from your chosen data provider.
     *
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the [AWS service terms](http://aws.amazon.com/service-terms) for more details.
     */
    public suspend fun createRouteCalculator(input: CreateRouteCalculatorRequest): CreateRouteCalculatorResponse

    /**
     * Creates a tracker resource in your AWS account, which lets you retrieve current and historical location of devices.
     */
    public suspend fun createTracker(input: CreateTrackerRequest): CreateTrackerResponse

    /**
     * Deletes a geofence collection from your AWS account.
     *
     * This operation deletes the resource permanently. If the geofence collection is the target of a tracker resource, the devices will no longer be monitored.
     */
    public suspend fun deleteGeofenceCollection(input: DeleteGeofenceCollectionRequest): DeleteGeofenceCollectionResponse

    /**
     * Deletes a map resource from your AWS account.
     *
     * This operation deletes the resource permanently. If the map is being used in an application, the map may not render.
     */
    public suspend fun deleteMap(input: DeleteMapRequest): DeleteMapResponse

    /**
     * Deletes a place index resource from your AWS account.
     *
     * This operation deletes the resource permanently.
     */
    public suspend fun deletePlaceIndex(input: DeletePlaceIndexRequest): DeletePlaceIndexResponse

    /**
     * Deletes a route calculator resource from your AWS account.
     *
     * This operation deletes the resource permanently.
     */
    public suspend fun deleteRouteCalculator(input: DeleteRouteCalculatorRequest): DeleteRouteCalculatorResponse

    /**
     * Deletes a tracker resource from your AWS account.
     *
     * This operation deletes the resource permanently. If the tracker resource is in use, you may encounter an error. Make sure that the target resource isn't a dependency for your applications.
     */
    public suspend fun deleteTracker(input: DeleteTrackerRequest): DeleteTrackerResponse

    /**
     * Retrieves the geofence collection details.
     */
    public suspend fun describeGeofenceCollection(input: DescribeGeofenceCollectionRequest): DescribeGeofenceCollectionResponse

    /**
     * Retrieves the map resource details.
     */
    public suspend fun describeMap(input: DescribeMapRequest): DescribeMapResponse

    /**
     * Retrieves the place index resource details.
     */
    public suspend fun describePlaceIndex(input: DescribePlaceIndexRequest): DescribePlaceIndexResponse

    /**
     * Retrieves the route calculator resource details.
     */
    public suspend fun describeRouteCalculator(input: DescribeRouteCalculatorRequest): DescribeRouteCalculatorResponse

    /**
     * Retrieves the tracker resource details.
     */
    public suspend fun describeTracker(input: DescribeTrackerRequest): DescribeTrackerResponse

    /**
     * Removes the association between a tracker resource and a geofence collection.
     *
     * Once you unlink a tracker resource from a geofence collection, the tracker positions will no longer be automatically evaluated against geofences.
     */
    public suspend fun disassociateTrackerConsumer(input: DisassociateTrackerConsumerRequest): DisassociateTrackerConsumerResponse

    /**
     * Retrieves a device's most recent position according to its sample time.
     *
     * Device positions are deleted after 30 days.
     */
    public suspend fun getDevicePosition(input: GetDevicePositionRequest): GetDevicePositionResponse

    /**
     * Retrieves the device position history from a tracker resource within a specified range of time.
     *
     * Device positions are deleted after 30 days.
     */
    public suspend fun getDevicePositionHistory(input: GetDevicePositionHistoryRequest): GetDevicePositionHistoryResponse

    /**
     * Retrieves the geofence details from a geofence collection.
     */
    public suspend fun getGeofence(input: GetGeofenceRequest): GetGeofenceResponse

    /**
     * Retrieves glyphs used to display labels on a map.
     */
    public suspend fun getMapGlyphs(input: GetMapGlyphsRequest): GetMapGlyphsResponse

    /**
     * Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG image paired with a JSON document describing the offsets of individual icons that will be displayed on a rendered map.
     */
    public suspend fun getMapSprites(input: GetMapSpritesRequest): GetMapSpritesResponse

    /**
     * Retrieves the map style descriptor from a map resource.
     *
     * The style descriptor contains speciﬁcations on how features render on a map. For example, what data to display, what order to display the data in, and the style for the data. Style descriptors follow the Mapbox Style Specification.
     */
    public suspend fun getMapStyleDescriptor(input: GetMapStyleDescriptorRequest): GetMapStyleDescriptorResponse

    /**
     * Retrieves a vector data tile from the map resource. Map tiles are used by clients to render a map. they're addressed using a grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level.
     *
     * The origin (0, 0) is the top left of the map. Increasing the zoom level by 1 doubles both the X and Y dimensions, so a tile containing data for the entire world at (0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1, 1/1/0, 1/1/1).
     */
    public suspend fun getMapTile(input: GetMapTileRequest): GetMapTileResponse

    /**
     * A batch request to retrieve all device positions.
     */
    public suspend fun listDevicePositions(input: ListDevicePositionsRequest): ListDevicePositionsResponse

    /**
     * Lists geofence collections in your AWS account.
     */
    public suspend fun listGeofenceCollections(input: ListGeofenceCollectionsRequest = ListGeofenceCollectionsRequest {}): ListGeofenceCollectionsResponse

    /**
     * Lists geofences stored in a given geofence collection.
     */
    public suspend fun listGeofences(input: ListGeofencesRequest): ListGeofencesResponse

    /**
     * Lists map resources in your AWS account.
     */
    public suspend fun listMaps(input: ListMapsRequest = ListMapsRequest {}): ListMapsResponse

    /**
     * Lists place index resources in your AWS account.
     */
    public suspend fun listPlaceIndexes(input: ListPlaceIndexesRequest = ListPlaceIndexesRequest {}): ListPlaceIndexesResponse

    /**
     * Lists route calculator resources in your AWS account.
     */
    public suspend fun listRouteCalculators(input: ListRouteCalculatorsRequest = ListRouteCalculatorsRequest {}): ListRouteCalculatorsResponse

    /**
     * Returns a list of tags that are applied to the specified Amazon Location resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists geofence collections currently associated to the given tracker resource.
     */
    public suspend fun listTrackerConsumers(input: ListTrackerConsumersRequest): ListTrackerConsumersResponse

    /**
     * Lists tracker resources in your AWS account.
     */
    public suspend fun listTrackers(input: ListTrackersRequest = ListTrackersRequest {}): ListTrackersResponse

    /**
     * Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.
     */
    public suspend fun putGeofence(input: PutGeofenceRequest): PutGeofenceResponse

    /**
     * Reverse geocodes a given coordinate and returns a legible address. Allows you to search for Places or points of interest near a given position.
     */
    public suspend fun searchPlaceIndexForPosition(input: SearchPlaceIndexForPositionRequest): SearchPlaceIndexForPositionResponse

    /**
     * Generates suggestions for addresses and points of interest based on partial or misspelled free-form text. This operation is also known as autocomplete, autosuggest, or fuzzy matching.
     *
     * Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a specific position on the globe.
     *
     * You can search for suggested place names near a specified position by using `BiasPosition`, or filter results within a bounding box by using `FilterBBox`. These parameters are mutually exclusive; using both `BiasPosition` and `FilterBBox` in the same command returns an error.
     */
    public suspend fun searchPlaceIndexForSuggestions(input: SearchPlaceIndexForSuggestionsRequest): SearchPlaceIndexForSuggestionsResponse

    /**
     * Geocodes free-form text, such as an address, name, city, or region to allow you to search for Places or points of interest.
     *
     * Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a specific position on the globe.
     *
     * You can search for places near a given position using `BiasPosition`, or filter results within a bounding box using `FilterBBox`. Providing both parameters simultaneously returns an error.
     *
     * Search results are returned in order of highest to lowest relevance.
     */
    public suspend fun searchPlaceIndexForText(input: SearchPlaceIndexForTextRequest): SearchPlaceIndexForTextResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified Amazon Location Service resource.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values.
     *
     * You can use the `TagResource` operation with an Amazon Location Service resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the tags already associated with the resource. If you specify a tag key that's already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     *
     * You can associate up to 50 tags with a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified Amazon Location resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified properties of a given geofence collection.
     */
    public suspend fun updateGeofenceCollection(input: UpdateGeofenceCollectionRequest): UpdateGeofenceCollectionResponse

    /**
     * Updates the specified properties of a given map resource.
     */
    public suspend fun updateMap(input: UpdateMapRequest): UpdateMapResponse

    /**
     * Updates the specified properties of a given place index resource.
     */
    public suspend fun updatePlaceIndex(input: UpdatePlaceIndexRequest): UpdatePlaceIndexResponse

    /**
     * Updates the specified properties for a given route calculator resource.
     */
    public suspend fun updateRouteCalculator(input: UpdateRouteCalculatorRequest): UpdateRouteCalculatorResponse

    /**
     * Updates the specified properties of a given tracker resource.
     */
    public suspend fun updateTracker(input: UpdateTrackerRequest): UpdateTrackerResponse
}

/**
 * Creates an association between a geofence collection and a tracker resource. This allows the tracker resource to communicate location data to the linked geofence collection.
 *
 * You can associate up to five geofence collections to each tracker resource.
 *
 * Currently not supported — Cross-account configurations, such as creating associations between a tracker resource in one account and a geofence collection in another account.
 */
public suspend inline fun LocationClient.associateTrackerConsumer(crossinline block: AssociateTrackerConsumerRequest.Builder.() -> Unit): AssociateTrackerConsumerResponse = associateTrackerConsumer(AssociateTrackerConsumerRequest.Builder().apply(block).build())

/**
 * Deletes the position history of one or more devices from a tracker resource.
 */
public suspend inline fun LocationClient.batchDeleteDevicePositionHistory(crossinline block: BatchDeleteDevicePositionHistoryRequest.Builder.() -> Unit): BatchDeleteDevicePositionHistoryResponse = batchDeleteDevicePositionHistory(BatchDeleteDevicePositionHistoryRequest.Builder().apply(block).build())

/**
 * Deletes a batch of geofences from a geofence collection.
 *
 * This operation deletes the resource permanently.
 */
public suspend inline fun LocationClient.batchDeleteGeofence(crossinline block: BatchDeleteGeofenceRequest.Builder.() -> Unit): BatchDeleteGeofenceResponse = batchDeleteGeofence(BatchDeleteGeofenceRequest.Builder().apply(block).build())

/**
 * Evaluates device positions against the geofence geometries from a given geofence collection.
 *
 * This operation always returns an empty response because geofences are asynchronously evaluated. The evaluation determines if the device has entered or exited a geofenced area, and then publishes one of the following events to Amazon EventBridge:
 * + `ENTER` if Amazon Location determines that the tracked device has entered a geofenced area.
 * + `EXIT` if Amazon Location determines that the tracked device has exited a geofenced area.
 *
 * The last geofence that a device was observed within is tracked for 30 days after the most recent device position update.
 *
 * Geofence evaluation uses the given device position. It does not account for the optional `Accuracy` of a `DevicePositionUpdate`.
 *
 * The `DeviceID` is used as a string to represent the device. You do not need to have a `Tracker` associated with the `DeviceID`.
 */
public suspend inline fun LocationClient.batchEvaluateGeofences(crossinline block: BatchEvaluateGeofencesRequest.Builder.() -> Unit): BatchEvaluateGeofencesResponse = batchEvaluateGeofences(BatchEvaluateGeofencesRequest.Builder().apply(block).build())

/**
 * Lists the latest device positions for requested devices.
 */
public suspend inline fun LocationClient.batchGetDevicePosition(crossinline block: BatchGetDevicePositionRequest.Builder.() -> Unit): BatchGetDevicePositionResponse = batchGetDevicePosition(BatchGetDevicePositionRequest.Builder().apply(block).build())

/**
 * A batch request for storing geofence geometries into a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.
 */
public suspend inline fun LocationClient.batchPutGeofence(crossinline block: BatchPutGeofenceRequest.Builder.() -> Unit): BatchPutGeofenceResponse = batchPutGeofence(BatchPutGeofenceRequest.Builder().apply(block).build())

/**
 * Uploads position update data for one or more devices to a tracker resource. Amazon Location uses the data when it reports the last known device position and position history. Amazon Location retains location data for 30 days.
 *
 * Position updates are handled based on the `PositionFiltering` property of the tracker. When `PositionFiltering` is set to `TimeBased`, updates are evaluated against linked geofence collections, and location data is stored at a maximum of one position per 30 second interval. If your update frequency is more often than every 30 seconds, only one update per 30 seconds is stored for each unique device ID.
 *
 * When `PositionFiltering` is set to `DistanceBased` filtering, location data is stored and evaluated against linked geofence collections only if the device has moved more than 30 m (98.4 ft).
 *
 * When `PositionFiltering` is set to `AccuracyBased` filtering, location data is stored and evaluated against linked geofence collections only if the device has moved more than the measured accuracy. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is neither stored or evaluated if the device has moved less than 15 m. If `PositionFiltering` is set to `AccuracyBased` filtering, Amazon Location uses the default value `{ "Horizontal": 0}` when accuracy is not provided on a `DevicePositionUpdate`.
 */
public suspend inline fun LocationClient.batchUpdateDevicePosition(crossinline block: BatchUpdateDevicePositionRequest.Builder.() -> Unit): BatchUpdateDevicePositionResponse = batchUpdateDevicePosition(BatchUpdateDevicePositionRequest.Builder().apply(block).build())

/**
 * [Calculates a route](https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html) given the following required parameters: `DeparturePosition` and `DestinationPosition`. Requires that you first [create a route calculator resource](https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html).
 *
 * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best traffic conditions when calculating the route.
 *
 * Additional options include:
 * + [Specifying a departure time](https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html) using either `DepartureTime` or `DepartNow`. This calculates a route based on predictive traffic data at the given time. You can't specify both `DepartureTime` and `DepartNow` in a single request. Specifying both parameters returns a validation error.
 * + [Specifying a travel mode](https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html) using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify additional route preferences in `CarModeOptions` if traveling by `Car`, or `TruckModeOptions` if traveling by `Truck`.
 */
public suspend inline fun LocationClient.calculateRoute(crossinline block: CalculateRouteRequest.Builder.() -> Unit): CalculateRouteResponse = calculateRoute(CalculateRouteRequest.Builder().apply(block).build())

/**
 * [ Calculates a route matrix](https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html) given the following required parameters: `DeparturePositions` and `DestinationPositions`. `CalculateRouteMatrix` calculates routes and returns the travel time and travel distance from each departure position to each destination position in the request. For example, given departure positions A and B, and destination positions X and Y, `CalculateRouteMatrix` will return time and distance for routes from A to X, A to Y, B to X, and B to Y (in that order). The number of results returned (and routes calculated) will be the number of `DeparturePositions` times the number of `DestinationPositions`.
 *
 * Your account is charged for each route calculated, not the number of requests.
 *
 * Requires that you first [create a route calculator resource](https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html).
 *
 * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best traffic conditions when calculating routes.
 *
 * Additional options include:
 * + [ Specifying a departure time](https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html) using either `DepartureTime` or `DepartNow`. This calculates routes based on predictive traffic data at the given time. You can't specify both `DepartureTime` and `DepartNow` in a single request. Specifying both parameters returns a validation error.
 * + [Specifying a travel mode](https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html) using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify additional route preferences in `CarModeOptions` if traveling by `Car`, or `TruckModeOptions` if traveling by `Truck`.
 */
public suspend inline fun LocationClient.calculateRouteMatrix(crossinline block: CalculateRouteMatrixRequest.Builder.() -> Unit): CalculateRouteMatrixResponse = calculateRouteMatrix(CalculateRouteMatrixRequest.Builder().apply(block).build())

/**
 * Creates a geofence collection, which manages and stores geofences.
 */
public suspend inline fun LocationClient.createGeofenceCollection(crossinline block: CreateGeofenceCollectionRequest.Builder.() -> Unit): CreateGeofenceCollectionResponse = createGeofenceCollection(CreateGeofenceCollectionRequest.Builder().apply(block).build())

/**
 * Creates a map resource in your AWS account, which provides map tiles of different styles sourced from global location data providers.
 *
 * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the [AWS service terms](http://aws.amazon.com/service-terms) for more details.
 */
public suspend inline fun LocationClient.createMap(crossinline block: CreateMapRequest.Builder.() -> Unit): CreateMapResponse = createMap(CreateMapRequest.Builder().apply(block).build())

/**
 * Creates a place index resource in your AWS account. Use a place index resource to geocode addresses and other text queries by using the `SearchPlaceIndexForText` operation, and reverse geocode coordinates by using the `SearchPlaceIndexForPosition` operation, and enable autosuggestions by using the `SearchPlaceIndexForSuggestions` operation.
 *
 * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the [AWS service terms](http://aws.amazon.com/service-terms) for more details.
 */
public suspend inline fun LocationClient.createPlaceIndex(crossinline block: CreatePlaceIndexRequest.Builder.() -> Unit): CreatePlaceIndexResponse = createPlaceIndex(CreatePlaceIndexRequest.Builder().apply(block).build())

/**
 * Creates a route calculator resource in your AWS account.
 *
 * You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A route calculator sources traffic and road network data from your chosen data provider.
 *
 * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the [AWS service terms](http://aws.amazon.com/service-terms) for more details.
 */
public suspend inline fun LocationClient.createRouteCalculator(crossinline block: CreateRouteCalculatorRequest.Builder.() -> Unit): CreateRouteCalculatorResponse = createRouteCalculator(CreateRouteCalculatorRequest.Builder().apply(block).build())

/**
 * Creates a tracker resource in your AWS account, which lets you retrieve current and historical location of devices.
 */
public suspend inline fun LocationClient.createTracker(crossinline block: CreateTrackerRequest.Builder.() -> Unit): CreateTrackerResponse = createTracker(CreateTrackerRequest.Builder().apply(block).build())

/**
 * Deletes a geofence collection from your AWS account.
 *
 * This operation deletes the resource permanently. If the geofence collection is the target of a tracker resource, the devices will no longer be monitored.
 */
public suspend inline fun LocationClient.deleteGeofenceCollection(crossinline block: DeleteGeofenceCollectionRequest.Builder.() -> Unit): DeleteGeofenceCollectionResponse = deleteGeofenceCollection(DeleteGeofenceCollectionRequest.Builder().apply(block).build())

/**
 * Deletes a map resource from your AWS account.
 *
 * This operation deletes the resource permanently. If the map is being used in an application, the map may not render.
 */
public suspend inline fun LocationClient.deleteMap(crossinline block: DeleteMapRequest.Builder.() -> Unit): DeleteMapResponse = deleteMap(DeleteMapRequest.Builder().apply(block).build())

/**
 * Deletes a place index resource from your AWS account.
 *
 * This operation deletes the resource permanently.
 */
public suspend inline fun LocationClient.deletePlaceIndex(crossinline block: DeletePlaceIndexRequest.Builder.() -> Unit): DeletePlaceIndexResponse = deletePlaceIndex(DeletePlaceIndexRequest.Builder().apply(block).build())

/**
 * Deletes a route calculator resource from your AWS account.
 *
 * This operation deletes the resource permanently.
 */
public suspend inline fun LocationClient.deleteRouteCalculator(crossinline block: DeleteRouteCalculatorRequest.Builder.() -> Unit): DeleteRouteCalculatorResponse = deleteRouteCalculator(DeleteRouteCalculatorRequest.Builder().apply(block).build())

/**
 * Deletes a tracker resource from your AWS account.
 *
 * This operation deletes the resource permanently. If the tracker resource is in use, you may encounter an error. Make sure that the target resource isn't a dependency for your applications.
 */
public suspend inline fun LocationClient.deleteTracker(crossinline block: DeleteTrackerRequest.Builder.() -> Unit): DeleteTrackerResponse = deleteTracker(DeleteTrackerRequest.Builder().apply(block).build())

/**
 * Retrieves the geofence collection details.
 */
public suspend inline fun LocationClient.describeGeofenceCollection(crossinline block: DescribeGeofenceCollectionRequest.Builder.() -> Unit): DescribeGeofenceCollectionResponse = describeGeofenceCollection(DescribeGeofenceCollectionRequest.Builder().apply(block).build())

/**
 * Retrieves the map resource details.
 */
public suspend inline fun LocationClient.describeMap(crossinline block: DescribeMapRequest.Builder.() -> Unit): DescribeMapResponse = describeMap(DescribeMapRequest.Builder().apply(block).build())

/**
 * Retrieves the place index resource details.
 */
public suspend inline fun LocationClient.describePlaceIndex(crossinline block: DescribePlaceIndexRequest.Builder.() -> Unit): DescribePlaceIndexResponse = describePlaceIndex(DescribePlaceIndexRequest.Builder().apply(block).build())

/**
 * Retrieves the route calculator resource details.
 */
public suspend inline fun LocationClient.describeRouteCalculator(crossinline block: DescribeRouteCalculatorRequest.Builder.() -> Unit): DescribeRouteCalculatorResponse = describeRouteCalculator(DescribeRouteCalculatorRequest.Builder().apply(block).build())

/**
 * Retrieves the tracker resource details.
 */
public suspend inline fun LocationClient.describeTracker(crossinline block: DescribeTrackerRequest.Builder.() -> Unit): DescribeTrackerResponse = describeTracker(DescribeTrackerRequest.Builder().apply(block).build())

/**
 * Removes the association between a tracker resource and a geofence collection.
 *
 * Once you unlink a tracker resource from a geofence collection, the tracker positions will no longer be automatically evaluated against geofences.
 */
public suspend inline fun LocationClient.disassociateTrackerConsumer(crossinline block: DisassociateTrackerConsumerRequest.Builder.() -> Unit): DisassociateTrackerConsumerResponse = disassociateTrackerConsumer(DisassociateTrackerConsumerRequest.Builder().apply(block).build())

/**
 * Retrieves a device's most recent position according to its sample time.
 *
 * Device positions are deleted after 30 days.
 */
public suspend inline fun LocationClient.getDevicePosition(crossinline block: GetDevicePositionRequest.Builder.() -> Unit): GetDevicePositionResponse = getDevicePosition(GetDevicePositionRequest.Builder().apply(block).build())

/**
 * Retrieves the device position history from a tracker resource within a specified range of time.
 *
 * Device positions are deleted after 30 days.
 */
public suspend inline fun LocationClient.getDevicePositionHistory(crossinline block: GetDevicePositionHistoryRequest.Builder.() -> Unit): GetDevicePositionHistoryResponse = getDevicePositionHistory(GetDevicePositionHistoryRequest.Builder().apply(block).build())

/**
 * Retrieves the geofence details from a geofence collection.
 */
public suspend inline fun LocationClient.getGeofence(crossinline block: GetGeofenceRequest.Builder.() -> Unit): GetGeofenceResponse = getGeofence(GetGeofenceRequest.Builder().apply(block).build())

/**
 * Retrieves glyphs used to display labels on a map.
 */
public suspend inline fun LocationClient.getMapGlyphs(crossinline block: GetMapGlyphsRequest.Builder.() -> Unit): GetMapGlyphsResponse = getMapGlyphs(GetMapGlyphsRequest.Builder().apply(block).build())

/**
 * Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG image paired with a JSON document describing the offsets of individual icons that will be displayed on a rendered map.
 */
public suspend inline fun LocationClient.getMapSprites(crossinline block: GetMapSpritesRequest.Builder.() -> Unit): GetMapSpritesResponse = getMapSprites(GetMapSpritesRequest.Builder().apply(block).build())

/**
 * Retrieves the map style descriptor from a map resource.
 *
 * The style descriptor contains speciﬁcations on how features render on a map. For example, what data to display, what order to display the data in, and the style for the data. Style descriptors follow the Mapbox Style Specification.
 */
public suspend inline fun LocationClient.getMapStyleDescriptor(crossinline block: GetMapStyleDescriptorRequest.Builder.() -> Unit): GetMapStyleDescriptorResponse = getMapStyleDescriptor(GetMapStyleDescriptorRequest.Builder().apply(block).build())

/**
 * Retrieves a vector data tile from the map resource. Map tiles are used by clients to render a map. they're addressed using a grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level.
 *
 * The origin (0, 0) is the top left of the map. Increasing the zoom level by 1 doubles both the X and Y dimensions, so a tile containing data for the entire world at (0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1, 1/1/0, 1/1/1).
 */
public suspend inline fun LocationClient.getMapTile(crossinline block: GetMapTileRequest.Builder.() -> Unit): GetMapTileResponse = getMapTile(GetMapTileRequest.Builder().apply(block).build())

/**
 * A batch request to retrieve all device positions.
 */
public suspend inline fun LocationClient.listDevicePositions(crossinline block: ListDevicePositionsRequest.Builder.() -> Unit): ListDevicePositionsResponse = listDevicePositions(ListDevicePositionsRequest.Builder().apply(block).build())

/**
 * Lists geofence collections in your AWS account.
 */
public suspend inline fun LocationClient.listGeofenceCollections(crossinline block: ListGeofenceCollectionsRequest.Builder.() -> Unit): ListGeofenceCollectionsResponse = listGeofenceCollections(ListGeofenceCollectionsRequest.Builder().apply(block).build())

/**
 * Lists geofences stored in a given geofence collection.
 */
public suspend inline fun LocationClient.listGeofences(crossinline block: ListGeofencesRequest.Builder.() -> Unit): ListGeofencesResponse = listGeofences(ListGeofencesRequest.Builder().apply(block).build())

/**
 * Lists map resources in your AWS account.
 */
public suspend inline fun LocationClient.listMaps(crossinline block: ListMapsRequest.Builder.() -> Unit): ListMapsResponse = listMaps(ListMapsRequest.Builder().apply(block).build())

/**
 * Lists place index resources in your AWS account.
 */
public suspend inline fun LocationClient.listPlaceIndexes(crossinline block: ListPlaceIndexesRequest.Builder.() -> Unit): ListPlaceIndexesResponse = listPlaceIndexes(ListPlaceIndexesRequest.Builder().apply(block).build())

/**
 * Lists route calculator resources in your AWS account.
 */
public suspend inline fun LocationClient.listRouteCalculators(crossinline block: ListRouteCalculatorsRequest.Builder.() -> Unit): ListRouteCalculatorsResponse = listRouteCalculators(ListRouteCalculatorsRequest.Builder().apply(block).build())

/**
 * Returns a list of tags that are applied to the specified Amazon Location resource.
 */
public suspend inline fun LocationClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists geofence collections currently associated to the given tracker resource.
 */
public suspend inline fun LocationClient.listTrackerConsumers(crossinline block: ListTrackerConsumersRequest.Builder.() -> Unit): ListTrackerConsumersResponse = listTrackerConsumers(ListTrackerConsumersRequest.Builder().apply(block).build())

/**
 * Lists tracker resources in your AWS account.
 */
public suspend inline fun LocationClient.listTrackers(crossinline block: ListTrackersRequest.Builder.() -> Unit): ListTrackersResponse = listTrackers(ListTrackersRequest.Builder().apply(block).build())

/**
 * Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.
 */
public suspend inline fun LocationClient.putGeofence(crossinline block: PutGeofenceRequest.Builder.() -> Unit): PutGeofenceResponse = putGeofence(PutGeofenceRequest.Builder().apply(block).build())

/**
 * Reverse geocodes a given coordinate and returns a legible address. Allows you to search for Places or points of interest near a given position.
 */
public suspend inline fun LocationClient.searchPlaceIndexForPosition(crossinline block: SearchPlaceIndexForPositionRequest.Builder.() -> Unit): SearchPlaceIndexForPositionResponse = searchPlaceIndexForPosition(SearchPlaceIndexForPositionRequest.Builder().apply(block).build())

/**
 * Generates suggestions for addresses and points of interest based on partial or misspelled free-form text. This operation is also known as autocomplete, autosuggest, or fuzzy matching.
 *
 * Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a specific position on the globe.
 *
 * You can search for suggested place names near a specified position by using `BiasPosition`, or filter results within a bounding box by using `FilterBBox`. These parameters are mutually exclusive; using both `BiasPosition` and `FilterBBox` in the same command returns an error.
 */
public suspend inline fun LocationClient.searchPlaceIndexForSuggestions(crossinline block: SearchPlaceIndexForSuggestionsRequest.Builder.() -> Unit): SearchPlaceIndexForSuggestionsResponse = searchPlaceIndexForSuggestions(SearchPlaceIndexForSuggestionsRequest.Builder().apply(block).build())

/**
 * Geocodes free-form text, such as an address, name, city, or region to allow you to search for Places or points of interest.
 *
 * Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a specific position on the globe.
 *
 * You can search for places near a given position using `BiasPosition`, or filter results within a bounding box using `FilterBBox`. Providing both parameters simultaneously returns an error.
 *
 * Search results are returned in order of highest to lowest relevance.
 */
public suspend inline fun LocationClient.searchPlaceIndexForText(crossinline block: SearchPlaceIndexForTextRequest.Builder.() -> Unit): SearchPlaceIndexForTextResponse = searchPlaceIndexForText(SearchPlaceIndexForTextRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags (key-value pairs) to the specified Amazon Location Service resource.
 *
 * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values.
 *
 * You can use the `TagResource` operation with an Amazon Location Service resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the tags already associated with the resource. If you specify a tag key that's already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
 *
 * You can associate up to 50 tags with a resource.
 */
public suspend inline fun LocationClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified Amazon Location resource.
 */
public suspend inline fun LocationClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified properties of a given geofence collection.
 */
public suspend inline fun LocationClient.updateGeofenceCollection(crossinline block: UpdateGeofenceCollectionRequest.Builder.() -> Unit): UpdateGeofenceCollectionResponse = updateGeofenceCollection(UpdateGeofenceCollectionRequest.Builder().apply(block).build())

/**
 * Updates the specified properties of a given map resource.
 */
public suspend inline fun LocationClient.updateMap(crossinline block: UpdateMapRequest.Builder.() -> Unit): UpdateMapResponse = updateMap(UpdateMapRequest.Builder().apply(block).build())

/**
 * Updates the specified properties of a given place index resource.
 */
public suspend inline fun LocationClient.updatePlaceIndex(crossinline block: UpdatePlaceIndexRequest.Builder.() -> Unit): UpdatePlaceIndexResponse = updatePlaceIndex(UpdatePlaceIndexRequest.Builder().apply(block).build())

/**
 * Updates the specified properties for a given route calculator resource.
 */
public suspend inline fun LocationClient.updateRouteCalculator(crossinline block: UpdateRouteCalculatorRequest.Builder.() -> Unit): UpdateRouteCalculatorResponse = updateRouteCalculator(UpdateRouteCalculatorRequest.Builder().apply(block).build())

/**
 * Updates the specified properties of a given tracker resource.
 */
public suspend inline fun LocationClient.updateTracker(crossinline block: UpdateTrackerRequest.Builder.() -> Unit): UpdateTrackerResponse = updateTracker(UpdateTrackerRequest.Builder().apply(block).build())
