// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.time.Instant

public class CalculateRouteMatrixRequest private constructor(builder: Builder) {
    /**
     * The name of the route calculator resource that you want to use to calculate the route matrix.
     */
    public val calculatorName: kotlin.String? = requireNotNull(builder.calculatorName) { "A non-null value must be provided for calculatorName" }
    /**
     * Specifies route preferences when traveling by `Car`, such as avoiding routes that use ferries or tolls.
     *
     * Requirements: `TravelMode` must be specified as `Car`.
     */
    public val carModeOptions: aws.sdk.kotlin.services.location.model.CalculateRouteCarModeOptions? = builder.carModeOptions
    /**
     * Sets the time of departure as the current time. Uses the current time to calculate the route matrix. You can't set both `DepartureTime` and `DepartNow`. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.
     *
     * Default Value: `false`
     *
     * Valid Values: `false` | `true`
     */
    public val departNow: kotlin.Boolean? = builder.departNow
    /**
     * The list of departure (origin) positions for the route matrix. An array of points, each of which is itself a 2-value array defined in [WGS 84](https://earth-info.nga.mil/GandG/wgs84/index.html) format: `[longitude, latitude]`. For example, `[-123.115, 49.285]`.
     *
     * Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See [ Position restrictions](https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits) in the *Amazon Location Service Developer Guide*.
     *
     * For route calculators that use Esri as the data provider, if you specify a departure that's not located on a road, Amazon Location [ moves the position to the nearest road](https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html). The snapped value is available in the result in `SnappedDeparturePositions`.
     *
     * Valid Values: `[-180 to 180,-90 to 90]`
     */
    public val departurePositions: List<List<Double>>? = builder.departurePositions
    /**
     * Specifies the desired time of departure. Uses the given time to calculate the route matrix. You can't set both `DepartureTime` and `DepartNow`. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.
     *
     * Setting a departure time in the past returns a `400 ValidationException` error.
     *
     * + In [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`. For example, `2020–07-2T12:15:20.000Z+01:00`
     */
    public val departureTime: aws.smithy.kotlin.runtime.time.Instant? = builder.departureTime
    /**
     * The list of destination positions for the route matrix. An array of points, each of which is itself a 2-value array defined in [WGS 84](https://earth-info.nga.mil/GandG/wgs84/index.html) format: `[longitude, latitude]`. For example, `[-122.339, 47.615]`
     *
     * Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See [ Position restrictions](https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits) in the *Amazon Location Service Developer Guide*.
     *
     * For route calculators that use Esri as the data provider, if you specify a destination that's not located on a road, Amazon Location [ moves the position to the nearest road](https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html). The snapped value is available in the result in `SnappedDestinationPositions`.
     *
     * Valid Values: `[-180 to 180,-90 to 90]`
     */
    public val destinationPositions: List<List<Double>>? = builder.destinationPositions
    /**
     * Set the unit system to specify the distance.
     *
     * Default Value: `Kilometers`
     */
    public val distanceUnit: aws.sdk.kotlin.services.location.model.DistanceUnit? = builder.distanceUnit
    /**
     * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.
     *
     * The `TravelMode` you specify also determines how you specify route preferences:
     * + If traveling by `Car` use the `CarModeOptions` parameter.
     * + If traveling by `Truck` use the `TruckModeOptions` parameter.
     *
     * Default Value: `Car`
     */
    public val travelMode: aws.sdk.kotlin.services.location.model.TravelMode? = builder.travelMode
    /**
     * Specifies route preferences when traveling by `Truck`, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.
     *
     * Requirements: `TravelMode` must be specified as `Truck`.
     */
    public val truckModeOptions: aws.sdk.kotlin.services.location.model.CalculateRouteTruckModeOptions? = builder.truckModeOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CalculateRouteMatrixRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CalculateRouteMatrixRequest(")
        append("calculatorName=$calculatorName,")
        append("carModeOptions=$carModeOptions,")
        append("departNow=$departNow,")
        append("departurePositions=$departurePositions,")
        append("departureTime=$departureTime,")
        append("destinationPositions=$destinationPositions,")
        append("distanceUnit=$distanceUnit,")
        append("travelMode=$travelMode,")
        append("truckModeOptions=$truckModeOptions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = calculatorName?.hashCode() ?: 0
        result = 31 * result + (carModeOptions?.hashCode() ?: 0)
        result = 31 * result + (departNow?.hashCode() ?: 0)
        result = 31 * result + (departurePositions?.hashCode() ?: 0)
        result = 31 * result + (departureTime?.hashCode() ?: 0)
        result = 31 * result + (destinationPositions?.hashCode() ?: 0)
        result = 31 * result + (distanceUnit?.hashCode() ?: 0)
        result = 31 * result + (travelMode?.hashCode() ?: 0)
        result = 31 * result + (truckModeOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CalculateRouteMatrixRequest

        if (calculatorName != other.calculatorName) return false
        if (carModeOptions != other.carModeOptions) return false
        if (departNow != other.departNow) return false
        if (departurePositions != other.departurePositions) return false
        if (departureTime != other.departureTime) return false
        if (destinationPositions != other.destinationPositions) return false
        if (distanceUnit != other.distanceUnit) return false
        if (travelMode != other.travelMode) return false
        if (truckModeOptions != other.truckModeOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CalculateRouteMatrixRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the route calculator resource that you want to use to calculate the route matrix.
         */
        public var calculatorName: kotlin.String? = null
        /**
         * Specifies route preferences when traveling by `Car`, such as avoiding routes that use ferries or tolls.
         *
         * Requirements: `TravelMode` must be specified as `Car`.
         */
        public var carModeOptions: aws.sdk.kotlin.services.location.model.CalculateRouteCarModeOptions? = null
        /**
         * Sets the time of departure as the current time. Uses the current time to calculate the route matrix. You can't set both `DepartureTime` and `DepartNow`. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.
         *
         * Default Value: `false`
         *
         * Valid Values: `false` | `true`
         */
        public var departNow: kotlin.Boolean? = null
        /**
         * The list of departure (origin) positions for the route matrix. An array of points, each of which is itself a 2-value array defined in [WGS 84](https://earth-info.nga.mil/GandG/wgs84/index.html) format: `[longitude, latitude]`. For example, `[-123.115, 49.285]`.
         *
         * Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See [ Position restrictions](https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits) in the *Amazon Location Service Developer Guide*.
         *
         * For route calculators that use Esri as the data provider, if you specify a departure that's not located on a road, Amazon Location [ moves the position to the nearest road](https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html). The snapped value is available in the result in `SnappedDeparturePositions`.
         *
         * Valid Values: `[-180 to 180,-90 to 90]`
         */
        public var departurePositions: List<List<Double>>? = null
        /**
         * Specifies the desired time of departure. Uses the given time to calculate the route matrix. You can't set both `DepartureTime` and `DepartNow`. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.
         *
         * Setting a departure time in the past returns a `400 ValidationException` error.
         *
         * + In [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`. For example, `2020–07-2T12:15:20.000Z+01:00`
         */
        public var departureTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The list of destination positions for the route matrix. An array of points, each of which is itself a 2-value array defined in [WGS 84](https://earth-info.nga.mil/GandG/wgs84/index.html) format: `[longitude, latitude]`. For example, `[-122.339, 47.615]`
         *
         * Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See [ Position restrictions](https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits) in the *Amazon Location Service Developer Guide*.
         *
         * For route calculators that use Esri as the data provider, if you specify a destination that's not located on a road, Amazon Location [ moves the position to the nearest road](https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html). The snapped value is available in the result in `SnappedDestinationPositions`.
         *
         * Valid Values: `[-180 to 180,-90 to 90]`
         */
        public var destinationPositions: List<List<Double>>? = null
        /**
         * Set the unit system to specify the distance.
         *
         * Default Value: `Kilometers`
         */
        public var distanceUnit: aws.sdk.kotlin.services.location.model.DistanceUnit? = null
        /**
         * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.
         *
         * The `TravelMode` you specify also determines how you specify route preferences:
         * + If traveling by `Car` use the `CarModeOptions` parameter.
         * + If traveling by `Truck` use the `TruckModeOptions` parameter.
         *
         * Default Value: `Car`
         */
        public var travelMode: aws.sdk.kotlin.services.location.model.TravelMode? = null
        /**
         * Specifies route preferences when traveling by `Truck`, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.
         *
         * Requirements: `TravelMode` must be specified as `Truck`.
         */
        public var truckModeOptions: aws.sdk.kotlin.services.location.model.CalculateRouteTruckModeOptions? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CalculateRouteMatrixRequest) : this() {
            this.calculatorName = x.calculatorName
            this.carModeOptions = x.carModeOptions
            this.departNow = x.departNow
            this.departurePositions = x.departurePositions
            this.departureTime = x.departureTime
            this.destinationPositions = x.destinationPositions
            this.distanceUnit = x.distanceUnit
            this.travelMode = x.travelMode
            this.truckModeOptions = x.truckModeOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CalculateRouteMatrixRequest = CalculateRouteMatrixRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.CalculateRouteCarModeOptions] inside the given [block]
         */
        public fun carModeOptions(block: aws.sdk.kotlin.services.location.model.CalculateRouteCarModeOptions.Builder.() -> kotlin.Unit) {
            this.carModeOptions = aws.sdk.kotlin.services.location.model.CalculateRouteCarModeOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.location.model.CalculateRouteTruckModeOptions] inside the given [block]
         */
        public fun truckModeOptions(block: aws.sdk.kotlin.services.location.model.CalculateRouteTruckModeOptions.Builder.() -> kotlin.Unit) {
            this.truckModeOptions = aws.sdk.kotlin.services.location.model.CalculateRouteTruckModeOptions.invoke(block)
        }
    }
}
