// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model



/**
 * Returns the result of the route matrix calculation.
 */
public class CalculateRouteMatrixResponse private constructor(builder: Builder) {
    /**
     * The calculated route matrix containing the results for all pairs of `DeparturePositions` to `DestinationPositions`. Each row corresponds to one entry in `DeparturePositions`. Each entry in the row corresponds to the route from that entry in `DeparturePositions` to an entry in `DestinationPositions`.
     */
    public val routeMatrix: List<List<RouteMatrixEntry>>? = builder.routeMatrix
    /**
     * For routes calculated using an Esri route calculator resource, departure positions are snapped to the closest road. For Esri route calculator resources, this returns the list of departure/origin positions used for calculation of the `RouteMatrix`.
     */
    public val snappedDeparturePositions: List<List<Double>>? = builder.snappedDeparturePositions
    /**
     * The list of destination positions for the route matrix used for calculation of the `RouteMatrix`.
     */
    public val snappedDestinationPositions: List<List<Double>>? = builder.snappedDestinationPositions
    /**
     * Contains information about the route matrix, `DataSource`, `DistanceUnit`, `RouteCount` and `ErrorCount`.
     */
    public val summary: aws.sdk.kotlin.services.location.model.CalculateRouteMatrixSummary? = builder.summary

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CalculateRouteMatrixResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CalculateRouteMatrixResponse(")
        append("routeMatrix=$routeMatrix,")
        append("snappedDeparturePositions=$snappedDeparturePositions,")
        append("snappedDestinationPositions=$snappedDestinationPositions,")
        append("summary=$summary)")
    }

    override fun hashCode(): kotlin.Int {
        var result = routeMatrix?.hashCode() ?: 0
        result = 31 * result + (snappedDeparturePositions?.hashCode() ?: 0)
        result = 31 * result + (snappedDestinationPositions?.hashCode() ?: 0)
        result = 31 * result + (summary?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CalculateRouteMatrixResponse

        if (routeMatrix != other.routeMatrix) return false
        if (snappedDeparturePositions != other.snappedDeparturePositions) return false
        if (snappedDestinationPositions != other.snappedDestinationPositions) return false
        if (summary != other.summary) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CalculateRouteMatrixResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The calculated route matrix containing the results for all pairs of `DeparturePositions` to `DestinationPositions`. Each row corresponds to one entry in `DeparturePositions`. Each entry in the row corresponds to the route from that entry in `DeparturePositions` to an entry in `DestinationPositions`.
         */
        public var routeMatrix: List<List<RouteMatrixEntry>>? = null
        /**
         * For routes calculated using an Esri route calculator resource, departure positions are snapped to the closest road. For Esri route calculator resources, this returns the list of departure/origin positions used for calculation of the `RouteMatrix`.
         */
        public var snappedDeparturePositions: List<List<Double>>? = null
        /**
         * The list of destination positions for the route matrix used for calculation of the `RouteMatrix`.
         */
        public var snappedDestinationPositions: List<List<Double>>? = null
        /**
         * Contains information about the route matrix, `DataSource`, `DistanceUnit`, `RouteCount` and `ErrorCount`.
         */
        public var summary: aws.sdk.kotlin.services.location.model.CalculateRouteMatrixSummary? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CalculateRouteMatrixResponse) : this() {
            this.routeMatrix = x.routeMatrix
            this.snappedDeparturePositions = x.snappedDeparturePositions
            this.snappedDestinationPositions = x.snappedDestinationPositions
            this.summary = x.summary
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CalculateRouteMatrixResponse = CalculateRouteMatrixResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.CalculateRouteMatrixSummary] inside the given [block]
         */
        public fun summary(block: aws.sdk.kotlin.services.location.model.CalculateRouteMatrixSummary.Builder.() -> kotlin.Unit) {
            this.summary = aws.sdk.kotlin.services.location.model.CalculateRouteMatrixSummary.invoke(block)
        }
    }
}
