// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model



/**
 * Returns the result of the route calculation. Metadata includes legs and route summary.
 */
public class CalculateRouteResponse private constructor(builder: Builder) {
    /**
     * Contains details about each path between a pair of positions included along a route such as: `StartPosition`, `EndPosition`, `Distance`, `DurationSeconds`, `Geometry`, and `Steps`. The number of legs returned corresponds to one fewer than the total number of positions in the request.
     *
     * For example, a route with a departure position and destination position returns one leg with the positions [snapped to a nearby road](https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html):
     * + The `StartPosition` is the departure position.
     * + The `EndPosition` is the destination position.
     *
     * A route with a waypoint between the departure and destination position returns two legs with the positions snapped to a nearby road:
     * + Leg 1: The `StartPosition` is the departure position . The `EndPosition` is the waypoint positon.
     * + Leg 2: The `StartPosition` is the waypoint position. The `EndPosition` is the destination position.
     */
    public val legs: List<Leg>? = builder.legs
    /**
     * Contains information about the whole route, such as: `RouteBBox`, `DataSource`, `Distance`, `DistanceUnit`, and `DurationSeconds`.
     */
    public val summary: aws.sdk.kotlin.services.location.model.CalculateRouteSummary? = builder.summary

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CalculateRouteResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CalculateRouteResponse(")
        append("legs=$legs,")
        append("summary=$summary)")
    }

    override fun hashCode(): kotlin.Int {
        var result = legs?.hashCode() ?: 0
        result = 31 * result + (summary?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CalculateRouteResponse

        if (legs != other.legs) return false
        if (summary != other.summary) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CalculateRouteResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains details about each path between a pair of positions included along a route such as: `StartPosition`, `EndPosition`, `Distance`, `DurationSeconds`, `Geometry`, and `Steps`. The number of legs returned corresponds to one fewer than the total number of positions in the request.
         *
         * For example, a route with a departure position and destination position returns one leg with the positions [snapped to a nearby road](https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html):
         * + The `StartPosition` is the departure position.
         * + The `EndPosition` is the destination position.
         *
         * A route with a waypoint between the departure and destination position returns two legs with the positions snapped to a nearby road:
         * + Leg 1: The `StartPosition` is the departure position . The `EndPosition` is the waypoint positon.
         * + Leg 2: The `StartPosition` is the waypoint position. The `EndPosition` is the destination position.
         */
        public var legs: List<Leg>? = null
        /**
         * Contains information about the whole route, such as: `RouteBBox`, `DataSource`, `Distance`, `DistanceUnit`, and `DurationSeconds`.
         */
        public var summary: aws.sdk.kotlin.services.location.model.CalculateRouteSummary? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CalculateRouteResponse) : this() {
            this.legs = x.legs
            this.summary = x.summary
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CalculateRouteResponse = CalculateRouteResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.CalculateRouteSummary] inside the given [block]
         */
        public fun summary(block: aws.sdk.kotlin.services.location.model.CalculateRouteSummary.Builder.() -> kotlin.Unit) {
            this.summary = aws.sdk.kotlin.services.location.model.CalculateRouteSummary.invoke(block)
        }
    }
}
