// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model



public class CreateMapRequest private constructor(builder: Builder) {
    /**
     * Specifies the map style selected from an available data provider.
     */
    public val configuration: aws.sdk.kotlin.services.location.model.MapConfiguration? = builder.configuration
    /**
     * An optional description for the map resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name for the map resource.
     *
     * Requirements:
     * + Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
     * + Must be a unique map resource name.
     * + No spaces allowed. For example, `ExampleMap`.
     */
    public val mapName: kotlin.String? = builder.mapName
    /**
     * No longer used. If included, the only allowed value is `RequestBasedUsage`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = builder.pricingPlan
    /**
     * Applies one or more tags to the map resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.
     *
     * Format: `"key" : "value"`
     *
     * Restrictions:
     * + Maximum 50 tags per resource
     * + Each resource tag must be unique with a maximum of one value.
     * + Maximum key length: 128 Unicode characters in UTF-8
     * + Maximum value length: 256 Unicode characters in UTF-8
     * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
     * + Cannot use "aws:" as a prefix for a key.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CreateMapRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMapRequest(")
        append("configuration=$configuration,")
        append("description=$description,")
        append("mapName=$mapName,")
        append("pricingPlan=$pricingPlan,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (mapName?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMapRequest

        if (configuration != other.configuration) return false
        if (description != other.description) return false
        if (mapName != other.mapName) return false
        if (pricingPlan != other.pricingPlan) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CreateMapRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the map style selected from an available data provider.
         */
        public var configuration: aws.sdk.kotlin.services.location.model.MapConfiguration? = null
        /**
         * An optional description for the map resource.
         */
        public var description: kotlin.String? = null
        /**
         * The name for the map resource.
         *
         * Requirements:
         * + Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
         * + Must be a unique map resource name.
         * + No spaces allowed. For example, `ExampleMap`.
         */
        public var mapName: kotlin.String? = null
        /**
         * No longer used. If included, the only allowed value is `RequestBasedUsage`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = null
        /**
         * Applies one or more tags to the map resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.
         *
         * Format: `"key" : "value"`
         *
         * Restrictions:
         * + Maximum 50 tags per resource
         * + Each resource tag must be unique with a maximum of one value.
         * + Maximum key length: 128 Unicode characters in UTF-8
         * + Maximum value length: 256 Unicode characters in UTF-8
         * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
         * + Cannot use "aws:" as a prefix for a key.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CreateMapRequest) : this() {
            this.configuration = x.configuration
            this.description = x.description
            this.mapName = x.mapName
            this.pricingPlan = x.pricingPlan
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CreateMapRequest = CreateMapRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.MapConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.location.model.MapConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.location.model.MapConfiguration.invoke(block)
        }
    }
}
