// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model



public class CreatePlaceIndexRequest private constructor(builder: Builder) {
    /**
     * Specifies the geospatial data provider for the new place index.
     *
     * This field is case-sensitive. Enter the valid values as shown. For example, entering `HERE` returns an error.
     *
     * Valid values include:
     * + `Esri` – For additional information about [Esri](https://docs.aws.amazon.com/location/latest/developerguide/esri.html)'s coverage in your region of interest, see [Esri details on geocoding coverage](https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm).
     * + `Here` – For additional information about [HERE Technologies](https://docs.aws.amazon.com/location/latest/developerguide/HERE.html)' coverage in your region of interest, see [HERE details on goecoding coverage](https://developer.here.com/documentation/geocoder/dev_guide/topics/coverage-geocoder.html).If you specify HERE Technologies (`Here`) as the data provider, you may not [store results](https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html) for locations in Japan. For more information, see the [AWS Service Terms](https://aws.amazon.com/service-terms/) for Amazon Location Service.
     *
     * For additional information , see [Data providers](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html) on the *Amazon Location Service Developer Guide*.
     */
    public val dataSource: kotlin.String? = builder.dataSource
    /**
     * Specifies the data storage option requesting Places.
     */
    public val dataSourceConfiguration: aws.sdk.kotlin.services.location.model.DataSourceConfiguration? = builder.dataSourceConfiguration
    /**
     * The optional description for the place index resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the place index resource.
     *
     * Requirements:
     * + Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
     * + Must be a unique place index resource name.
     * + No spaces allowed. For example, `ExamplePlaceIndex`.
     */
    public val indexName: kotlin.String? = builder.indexName
    /**
     * No longer used. If included, the only allowed value is `RequestBasedUsage`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = builder.pricingPlan
    /**
     * Applies one or more tags to the place index resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.
     *
     * Format: `"key" : "value"`
     *
     * Restrictions:
     * + Maximum 50 tags per resource.
     * + Each tag key must be unique and must have exactly one associated value.
     * + Maximum key length: 128 Unicode characters in UTF-8.
     * + Maximum value length: 256 Unicode characters in UTF-8.
     * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @
     * + Cannot use "aws:" as a prefix for a key.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CreatePlaceIndexRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePlaceIndexRequest(")
        append("dataSource=$dataSource,")
        append("dataSourceConfiguration=$dataSourceConfiguration,")
        append("description=$description,")
        append("indexName=$indexName,")
        append("pricingPlan=$pricingPlan,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSource?.hashCode() ?: 0
        result = 31 * result + (dataSourceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (indexName?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePlaceIndexRequest

        if (dataSource != other.dataSource) return false
        if (dataSourceConfiguration != other.dataSourceConfiguration) return false
        if (description != other.description) return false
        if (indexName != other.indexName) return false
        if (pricingPlan != other.pricingPlan) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CreatePlaceIndexRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the geospatial data provider for the new place index.
         *
         * This field is case-sensitive. Enter the valid values as shown. For example, entering `HERE` returns an error.
         *
         * Valid values include:
         * + `Esri` – For additional information about [Esri](https://docs.aws.amazon.com/location/latest/developerguide/esri.html)'s coverage in your region of interest, see [Esri details on geocoding coverage](https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm).
         * + `Here` – For additional information about [HERE Technologies](https://docs.aws.amazon.com/location/latest/developerguide/HERE.html)' coverage in your region of interest, see [HERE details on goecoding coverage](https://developer.here.com/documentation/geocoder/dev_guide/topics/coverage-geocoder.html).If you specify HERE Technologies (`Here`) as the data provider, you may not [store results](https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html) for locations in Japan. For more information, see the [AWS Service Terms](https://aws.amazon.com/service-terms/) for Amazon Location Service.
         *
         * For additional information , see [Data providers](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html) on the *Amazon Location Service Developer Guide*.
         */
        public var dataSource: kotlin.String? = null
        /**
         * Specifies the data storage option requesting Places.
         */
        public var dataSourceConfiguration: aws.sdk.kotlin.services.location.model.DataSourceConfiguration? = null
        /**
         * The optional description for the place index resource.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the place index resource.
         *
         * Requirements:
         * + Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
         * + Must be a unique place index resource name.
         * + No spaces allowed. For example, `ExamplePlaceIndex`.
         */
        public var indexName: kotlin.String? = null
        /**
         * No longer used. If included, the only allowed value is `RequestBasedUsage`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = null
        /**
         * Applies one or more tags to the place index resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.
         *
         * Format: `"key" : "value"`
         *
         * Restrictions:
         * + Maximum 50 tags per resource.
         * + Each tag key must be unique and must have exactly one associated value.
         * + Maximum key length: 128 Unicode characters in UTF-8.
         * + Maximum value length: 256 Unicode characters in UTF-8.
         * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @
         * + Cannot use "aws:" as a prefix for a key.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CreatePlaceIndexRequest) : this() {
            this.dataSource = x.dataSource
            this.dataSourceConfiguration = x.dataSourceConfiguration
            this.description = x.description
            this.indexName = x.indexName
            this.pricingPlan = x.pricingPlan
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CreatePlaceIndexRequest = CreatePlaceIndexRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.DataSourceConfiguration] inside the given [block]
         */
        public fun dataSourceConfiguration(block: aws.sdk.kotlin.services.location.model.DataSourceConfiguration.Builder.() -> kotlin.Unit) {
            this.dataSourceConfiguration = aws.sdk.kotlin.services.location.model.DataSourceConfiguration.invoke(block)
        }
    }
}
