// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model



public class CreateRouteCalculatorRequest private constructor(builder: Builder) {
    /**
     * The name of the route calculator resource.
     *
     * Requirements:
     * + Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).
     * + Must be a unique Route calculator resource name.
     * + No spaces allowed. For example, `ExampleRouteCalculator`.
     */
    public val calculatorName: kotlin.String? = builder.calculatorName
    /**
     * Specifies the data provider of traffic and road network data.
     *
     * This field is case-sensitive. Enter the valid values as shown. For example, entering `HERE` returns an error. Route calculators that use Esri as a data source only calculate routes that are shorter than 400 km.
     *
     * Valid values include:
     * + `Esri` – For additional information about [Esri](https://docs.aws.amazon.com/location/latest/developerguide/esri.html)'s coverage in your region of interest, see [Esri details on street networks and traffic coverage](https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm).
     * + `Here` – For additional information about [HERE Technologies](https://docs.aws.amazon.com/location/latest/developerguide/HERE.html)' coverage in your region of interest, see [HERE car routing coverage](https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html) and [HERE truck routing coverage](https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html).
     *
     * For additional information , see [Data providers](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html) on the *Amazon Location Service Developer Guide*.
     */
    public val dataSource: kotlin.String? = builder.dataSource
    /**
     * The optional description for the route calculator resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * No longer used. If included, the only allowed value is `RequestBasedUsage`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = builder.pricingPlan
    /**
     * Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.
     * + For example: { `"tag1" : "value1"`, `"tag2" : "value2"`}
     *
     * Format: `"key" : "value"`
     *
     * Restrictions:
     * + Maximum 50 tags per resource
     * + Each resource tag must be unique with a maximum of one value.
     * + Maximum key length: 128 Unicode characters in UTF-8
     * + Maximum value length: 256 Unicode characters in UTF-8
     * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
     * + Cannot use "aws:" as a prefix for a key.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CreateRouteCalculatorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRouteCalculatorRequest(")
        append("calculatorName=$calculatorName,")
        append("dataSource=$dataSource,")
        append("description=$description,")
        append("pricingPlan=$pricingPlan,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = calculatorName?.hashCode() ?: 0
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRouteCalculatorRequest

        if (calculatorName != other.calculatorName) return false
        if (dataSource != other.dataSource) return false
        if (description != other.description) return false
        if (pricingPlan != other.pricingPlan) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CreateRouteCalculatorRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the route calculator resource.
         *
         * Requirements:
         * + Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).
         * + Must be a unique Route calculator resource name.
         * + No spaces allowed. For example, `ExampleRouteCalculator`.
         */
        public var calculatorName: kotlin.String? = null
        /**
         * Specifies the data provider of traffic and road network data.
         *
         * This field is case-sensitive. Enter the valid values as shown. For example, entering `HERE` returns an error. Route calculators that use Esri as a data source only calculate routes that are shorter than 400 km.
         *
         * Valid values include:
         * + `Esri` – For additional information about [Esri](https://docs.aws.amazon.com/location/latest/developerguide/esri.html)'s coverage in your region of interest, see [Esri details on street networks and traffic coverage](https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm).
         * + `Here` – For additional information about [HERE Technologies](https://docs.aws.amazon.com/location/latest/developerguide/HERE.html)' coverage in your region of interest, see [HERE car routing coverage](https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html) and [HERE truck routing coverage](https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html).
         *
         * For additional information , see [Data providers](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html) on the *Amazon Location Service Developer Guide*.
         */
        public var dataSource: kotlin.String? = null
        /**
         * The optional description for the route calculator resource.
         */
        public var description: kotlin.String? = null
        /**
         * No longer used. If included, the only allowed value is `RequestBasedUsage`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = null
        /**
         * Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.
         * + For example: { `"tag1" : "value1"`, `"tag2" : "value2"`}
         *
         * Format: `"key" : "value"`
         *
         * Restrictions:
         * + Maximum 50 tags per resource
         * + Each resource tag must be unique with a maximum of one value.
         * + Maximum key length: 128 Unicode characters in UTF-8
         * + Maximum value length: 256 Unicode characters in UTF-8
         * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
         * + Cannot use "aws:" as a prefix for a key.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CreateRouteCalculatorRequest) : this() {
            this.calculatorName = x.calculatorName
            this.dataSource = x.dataSource
            this.description = x.description
            this.pricingPlan = x.pricingPlan
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CreateRouteCalculatorRequest = CreateRouteCalculatorRequest(this)
    }
}
