// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model



public class CreateTrackerRequest private constructor(builder: Builder) {
    /**
     * An optional description for the tracker resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A key identifier for an [AWS KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html). Enter a key ID, key ARN, alias name, or alias ARN.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the position filtering for the tracker resource.
     *
     * Valid values:
     * + `TimeBased` - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID.
     * + `DistanceBased` - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map.
     * + `AccuracyBased` - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device trajectories on a map, and can help control your costs by reducing the number of geofence evaluations.
     *
     * This field is optional. If not specified, the default value is `TimeBased`.
     */
    public val positionFiltering: aws.sdk.kotlin.services.location.model.PositionFiltering? = builder.positionFiltering
    /**
     * No longer used. If included, the only allowed value is `RequestBasedUsage`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = builder.pricingPlan
    /**
     * This parameter is no longer used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlanDataSource: kotlin.String? = builder.pricingPlanDataSource
    /**
     * Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.
     *
     * Format: `"key" : "value"`
     *
     * Restrictions:
     * + Maximum 50 tags per resource
     * + Each resource tag must be unique with a maximum of one value.
     * + Maximum key length: 128 Unicode characters in UTF-8
     * + Maximum value length: 256 Unicode characters in UTF-8
     * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
     * + Cannot use "aws:" as a prefix for a key.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The name for the tracker resource.
     *
     * Requirements:
     * + Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
     * + Must be a unique tracker resource name.
     * + No spaces allowed. For example, `ExampleTracker`.
     */
    public val trackerName: kotlin.String? = builder.trackerName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CreateTrackerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTrackerRequest(")
        append("description=$description,")
        append("kmsKeyId=$kmsKeyId,")
        append("positionFiltering=$positionFiltering,")
        append("pricingPlan=$pricingPlan,")
        append("pricingPlanDataSource=$pricingPlanDataSource,")
        append("tags=$tags,")
        append("trackerName=$trackerName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (positionFiltering?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (pricingPlanDataSource?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trackerName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTrackerRequest

        if (description != other.description) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (positionFiltering != other.positionFiltering) return false
        if (pricingPlan != other.pricingPlan) return false
        if (pricingPlanDataSource != other.pricingPlanDataSource) return false
        if (tags != other.tags) return false
        if (trackerName != other.trackerName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CreateTrackerRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An optional description for the tracker resource.
         */
        public var description: kotlin.String? = null
        /**
         * A key identifier for an [AWS KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html). Enter a key ID, key ARN, alias name, or alias ARN.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the position filtering for the tracker resource.
         *
         * Valid values:
         * + `TimeBased` - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID.
         * + `DistanceBased` - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map.
         * + `AccuracyBased` - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device trajectories on a map, and can help control your costs by reducing the number of geofence evaluations.
         *
         * This field is optional. If not specified, the default value is `TimeBased`.
         */
        public var positionFiltering: aws.sdk.kotlin.services.location.model.PositionFiltering? = null
        /**
         * No longer used. If included, the only allowed value is `RequestBasedUsage`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = null
        /**
         * This parameter is no longer used.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlanDataSource: kotlin.String? = null
        /**
         * Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.
         *
         * Format: `"key" : "value"`
         *
         * Restrictions:
         * + Maximum 50 tags per resource
         * + Each resource tag must be unique with a maximum of one value.
         * + Maximum key length: 128 Unicode characters in UTF-8
         * + Maximum value length: 256 Unicode characters in UTF-8
         * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
         * + Cannot use "aws:" as a prefix for a key.
         */
        public var tags: Map<String, String>? = null
        /**
         * The name for the tracker resource.
         *
         * Requirements:
         * + Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
         * + Must be a unique tracker resource name.
         * + No spaces allowed. For example, `ExampleTracker`.
         */
        public var trackerName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CreateTrackerRequest) : this() {
            this.description = x.description
            this.kmsKeyId = x.kmsKeyId
            this.positionFiltering = x.positionFiltering
            this.pricingPlan = x.pricingPlan
            this.pricingPlanDataSource = x.pricingPlanDataSource
            this.tags = x.tags
            this.trackerName = x.trackerName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CreateTrackerRequest = CreateTrackerRequest(this)
    }
}
