// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeGeofenceCollectionResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS.
     * + Format example: `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection`
     */
    public val collectionArn: kotlin.String? = builder.collectionArn
    /**
     * The name of the geofence collection.
     */
    public val collectionName: kotlin.String? = builder.collectionName
    /**
     * The timestamp for when the geofence resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The optional description for the geofence collection.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A key identifier for an [AWS KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html) assigned to the Amazon Location resource
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * No longer used. Always returns `RequestBasedUsage`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = builder.pricingPlan
    /**
     * No longer used. Always returns an empty string.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlanDataSource: kotlin.String? = builder.pricingPlanDataSource
    /**
     * Displays the key, value pairs of tags associated with this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The timestamp for when the geofence collection was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.DescribeGeofenceCollectionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeGeofenceCollectionResponse(")
        append("collectionArn=$collectionArn,")
        append("collectionName=$collectionName,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("kmsKeyId=$kmsKeyId,")
        append("pricingPlan=$pricingPlan,")
        append("pricingPlanDataSource=$pricingPlanDataSource,")
        append("tags=$tags,")
        append("updateTime=$updateTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionArn?.hashCode() ?: 0
        result = 31 * result + (collectionName?.hashCode() ?: 0)
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (pricingPlanDataSource?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeGeofenceCollectionResponse

        if (collectionArn != other.collectionArn) return false
        if (collectionName != other.collectionName) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (pricingPlan != other.pricingPlan) return false
        if (pricingPlanDataSource != other.pricingPlanDataSource) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.DescribeGeofenceCollectionResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS.
         * + Format example: `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection`
         */
        public var collectionArn: kotlin.String? = null
        /**
         * The name of the geofence collection.
         */
        public var collectionName: kotlin.String? = null
        /**
         * The timestamp for when the geofence resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The optional description for the geofence collection.
         */
        public var description: kotlin.String? = null
        /**
         * A key identifier for an [AWS KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html) assigned to the Amazon Location resource
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * No longer used. Always returns `RequestBasedUsage`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = null
        /**
         * No longer used. Always returns an empty string.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlanDataSource: kotlin.String? = null
        /**
         * Displays the key, value pairs of tags associated with this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The timestamp for when the geofence collection was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.DescribeGeofenceCollectionResponse) : this() {
            this.collectionArn = x.collectionArn
            this.collectionName = x.collectionName
            this.createTime = x.createTime
            this.description = x.description
            this.kmsKeyId = x.kmsKeyId
            this.pricingPlan = x.pricingPlan
            this.pricingPlanDataSource = x.pricingPlanDataSource
            this.tags = x.tags
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.DescribeGeofenceCollectionResponse = DescribeGeofenceCollectionResponse(this)
    }
}
