// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeMapResponse private constructor(builder: Builder) {
    /**
     * Specifies the map tile style selected from a partner data provider.
     */
    public val configuration: aws.sdk.kotlin.services.location.model.MapConfiguration? = builder.configuration
    /**
     * The timestamp for when the map resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * Specifies the data provider for the associated map tiles.
     */
    public val dataSource: kotlin.String? = builder.dataSource
    /**
     * The optional description for the map resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.
     * + Format example: `arn:aws:geo:region:account-id:maps/ExampleMap`
     */
    public val mapArn: kotlin.String? = builder.mapArn
    /**
     * The map style selected from an available provider.
     */
    public val mapName: kotlin.String? = builder.mapName
    /**
     * No longer used. Always returns `RequestBasedUsage`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = builder.pricingPlan
    /**
     * Tags associated with the map resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The timestamp for when the map resource was last update in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.DescribeMapResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeMapResponse(")
        append("configuration=$configuration,")
        append("createTime=$createTime,")
        append("dataSource=$dataSource,")
        append("description=$description,")
        append("mapArn=$mapArn,")
        append("mapName=$mapName,")
        append("pricingPlan=$pricingPlan,")
        append("tags=$tags,")
        append("updateTime=$updateTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (mapArn?.hashCode() ?: 0)
        result = 31 * result + (mapName?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeMapResponse

        if (configuration != other.configuration) return false
        if (createTime != other.createTime) return false
        if (dataSource != other.dataSource) return false
        if (description != other.description) return false
        if (mapArn != other.mapArn) return false
        if (mapName != other.mapName) return false
        if (pricingPlan != other.pricingPlan) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.DescribeMapResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the map tile style selected from a partner data provider.
         */
        public var configuration: aws.sdk.kotlin.services.location.model.MapConfiguration? = null
        /**
         * The timestamp for when the map resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the data provider for the associated map tiles.
         */
        public var dataSource: kotlin.String? = null
        /**
         * The optional description for the map resource.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.
         * + Format example: `arn:aws:geo:region:account-id:maps/ExampleMap`
         */
        public var mapArn: kotlin.String? = null
        /**
         * The map style selected from an available provider.
         */
        public var mapName: kotlin.String? = null
        /**
         * No longer used. Always returns `RequestBasedUsage`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = null
        /**
         * Tags associated with the map resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The timestamp for when the map resource was last update in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.DescribeMapResponse) : this() {
            this.configuration = x.configuration
            this.createTime = x.createTime
            this.dataSource = x.dataSource
            this.description = x.description
            this.mapArn = x.mapArn
            this.mapName = x.mapName
            this.pricingPlan = x.pricingPlan
            this.tags = x.tags
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.DescribeMapResponse = DescribeMapResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.MapConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.location.model.MapConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.location.model.MapConfiguration.invoke(block)
        }
    }
}
