// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribePlaceIndexResponse private constructor(builder: Builder) {
    /**
     * The timestamp for when the place index resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The data provider of geospatial data. Values can be one of the following:
     * + `Esri`
     * + `Here`
     *
     * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
     */
    public val dataSource: kotlin.String? = builder.dataSource
    /**
     * The specified data storage option for requesting Places.
     */
    public val dataSourceConfiguration: aws.sdk.kotlin.services.location.model.DataSourceConfiguration? = builder.dataSourceConfiguration
    /**
     * The optional description for the place index resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS.
     * + Format example: `arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex`
     */
    public val indexArn: kotlin.String? = builder.indexArn
    /**
     * The name of the place index resource being described.
     */
    public val indexName: kotlin.String? = builder.indexName
    /**
     * No longer used. Always returns `RequestBasedUsage`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = builder.pricingPlan
    /**
     * Tags associated with place index resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The timestamp for when the place index resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.DescribePlaceIndexResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribePlaceIndexResponse(")
        append("createTime=$createTime,")
        append("dataSource=$dataSource,")
        append("dataSourceConfiguration=$dataSourceConfiguration,")
        append("description=$description,")
        append("indexArn=$indexArn,")
        append("indexName=$indexName,")
        append("pricingPlan=$pricingPlan,")
        append("tags=$tags,")
        append("updateTime=$updateTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime?.hashCode() ?: 0
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (dataSourceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (indexArn?.hashCode() ?: 0)
        result = 31 * result + (indexName?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribePlaceIndexResponse

        if (createTime != other.createTime) return false
        if (dataSource != other.dataSource) return false
        if (dataSourceConfiguration != other.dataSourceConfiguration) return false
        if (description != other.description) return false
        if (indexArn != other.indexArn) return false
        if (indexName != other.indexName) return false
        if (pricingPlan != other.pricingPlan) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.DescribePlaceIndexResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp for when the place index resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The data provider of geospatial data. Values can be one of the following:
         * + `Esri`
         * + `Here`
         *
         * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
         */
        public var dataSource: kotlin.String? = null
        /**
         * The specified data storage option for requesting Places.
         */
        public var dataSourceConfiguration: aws.sdk.kotlin.services.location.model.DataSourceConfiguration? = null
        /**
         * The optional description for the place index resource.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS.
         * + Format example: `arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex`
         */
        public var indexArn: kotlin.String? = null
        /**
         * The name of the place index resource being described.
         */
        public var indexName: kotlin.String? = null
        /**
         * No longer used. Always returns `RequestBasedUsage`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = null
        /**
         * Tags associated with place index resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The timestamp for when the place index resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.DescribePlaceIndexResponse) : this() {
            this.createTime = x.createTime
            this.dataSource = x.dataSource
            this.dataSourceConfiguration = x.dataSourceConfiguration
            this.description = x.description
            this.indexArn = x.indexArn
            this.indexName = x.indexName
            this.pricingPlan = x.pricingPlan
            this.tags = x.tags
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.DescribePlaceIndexResponse = DescribePlaceIndexResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.DataSourceConfiguration] inside the given [block]
         */
        public fun dataSourceConfiguration(block: aws.sdk.kotlin.services.location.model.DataSourceConfiguration.Builder.() -> kotlin.Unit) {
            this.dataSourceConfiguration = aws.sdk.kotlin.services.location.model.DataSourceConfiguration.invoke(block)
        }
    }
}
