// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeRouteCalculatorResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the Route calculator resource. Use the ARN when you specify a resource across AWS.
     * + Format example: `arn:aws:geo:region:account-id:route-calculator/ExampleCalculator`
     */
    public val calculatorArn: kotlin.String? = builder.calculatorArn
    /**
     * The name of the route calculator resource being described.
     */
    public val calculatorName: kotlin.String? = builder.calculatorName
    /**
     * The timestamp when the route calculator resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     * + For example, `2020–07-2T12:15:20.000Z+01:00`
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The data provider of traffic and road network data. Indicates one of the available providers:
     * + `Esri`
     * + `Here`
     *
     * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
     */
    public val dataSource: kotlin.String? = builder.dataSource
    /**
     * The optional description of the route calculator resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Always returns `RequestBasedUsage`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = builder.pricingPlan
    /**
     * Tags associated with route calculator resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The timestamp when the route calculator resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     * + For example, `2020–07-2T12:15:20.000Z+01:00`
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.DescribeRouteCalculatorResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeRouteCalculatorResponse(")
        append("calculatorArn=$calculatorArn,")
        append("calculatorName=$calculatorName,")
        append("createTime=$createTime,")
        append("dataSource=$dataSource,")
        append("description=$description,")
        append("pricingPlan=$pricingPlan,")
        append("tags=$tags,")
        append("updateTime=$updateTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = calculatorArn?.hashCode() ?: 0
        result = 31 * result + (calculatorName?.hashCode() ?: 0)
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeRouteCalculatorResponse

        if (calculatorArn != other.calculatorArn) return false
        if (calculatorName != other.calculatorName) return false
        if (createTime != other.createTime) return false
        if (dataSource != other.dataSource) return false
        if (description != other.description) return false
        if (pricingPlan != other.pricingPlan) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.DescribeRouteCalculatorResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the Route calculator resource. Use the ARN when you specify a resource across AWS.
         * + Format example: `arn:aws:geo:region:account-id:route-calculator/ExampleCalculator`
         */
        public var calculatorArn: kotlin.String? = null
        /**
         * The name of the route calculator resource being described.
         */
        public var calculatorName: kotlin.String? = null
        /**
         * The timestamp when the route calculator resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         * + For example, `2020–07-2T12:15:20.000Z+01:00`
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The data provider of traffic and road network data. Indicates one of the available providers:
         * + `Esri`
         * + `Here`
         *
         * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
         */
        public var dataSource: kotlin.String? = null
        /**
         * The optional description of the route calculator resource.
         */
        public var description: kotlin.String? = null
        /**
         * Always returns `RequestBasedUsage`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = null
        /**
         * Tags associated with route calculator resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The timestamp when the route calculator resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         * + For example, `2020–07-2T12:15:20.000Z+01:00`
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.DescribeRouteCalculatorResponse) : this() {
            this.calculatorArn = x.calculatorArn
            this.calculatorName = x.calculatorName
            this.createTime = x.createTime
            this.dataSource = x.dataSource
            this.description = x.description
            this.pricingPlan = x.pricingPlan
            this.tags = x.tags
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.DescribeRouteCalculatorResponse = DescribeRouteCalculatorResponse(this)
    }
}
