// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeTrackerResponse private constructor(builder: Builder) {
    /**
     * The timestamp for when the tracker resource was created in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The optional description for the tracker resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A key identifier for an [AWS KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html) assigned to the Amazon Location resource.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The position filtering method of the tracker resource.
     */
    public val positionFiltering: aws.sdk.kotlin.services.location.model.PositionFiltering? = builder.positionFiltering
    /**
     * Always returns `RequestBasedUsage`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = builder.pricingPlan
    /**
     * No longer used. Always returns an empty string.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlanDataSource: kotlin.String? = builder.pricingPlanDataSource
    /**
     * The tags associated with the tracker resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.
     * + Format example: `arn:aws:geo:region:account-id:tracker/ExampleTracker`
     */
    public val trackerArn: kotlin.String? = builder.trackerArn
    /**
     * The name of the tracker resource.
     */
    public val trackerName: kotlin.String? = builder.trackerName
    /**
     * The timestamp for when the tracker resource was last updated in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.DescribeTrackerResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTrackerResponse(")
        append("createTime=$createTime,")
        append("description=$description,")
        append("kmsKeyId=$kmsKeyId,")
        append("positionFiltering=$positionFiltering,")
        append("pricingPlan=$pricingPlan,")
        append("pricingPlanDataSource=$pricingPlanDataSource,")
        append("tags=$tags,")
        append("trackerArn=$trackerArn,")
        append("trackerName=$trackerName,")
        append("updateTime=$updateTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (positionFiltering?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (pricingPlanDataSource?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trackerArn?.hashCode() ?: 0)
        result = 31 * result + (trackerName?.hashCode() ?: 0)
        result = 31 * result + (updateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTrackerResponse

        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (positionFiltering != other.positionFiltering) return false
        if (pricingPlan != other.pricingPlan) return false
        if (pricingPlanDataSource != other.pricingPlanDataSource) return false
        if (tags != other.tags) return false
        if (trackerArn != other.trackerArn) return false
        if (trackerName != other.trackerName) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.DescribeTrackerResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp for when the tracker resource was created in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The optional description for the tracker resource.
         */
        public var description: kotlin.String? = null
        /**
         * A key identifier for an [AWS KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html) assigned to the Amazon Location resource.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The position filtering method of the tracker resource.
         */
        public var positionFiltering: aws.sdk.kotlin.services.location.model.PositionFiltering? = null
        /**
         * Always returns `RequestBasedUsage`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = null
        /**
         * No longer used. Always returns an empty string.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlanDataSource: kotlin.String? = null
        /**
         * The tags associated with the tracker resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.
         * + Format example: `arn:aws:geo:region:account-id:tracker/ExampleTracker`
         */
        public var trackerArn: kotlin.String? = null
        /**
         * The name of the tracker resource.
         */
        public var trackerName: kotlin.String? = null
        /**
         * The timestamp for when the tracker resource was last updated in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.DescribeTrackerResponse) : this() {
            this.createTime = x.createTime
            this.description = x.description
            this.kmsKeyId = x.kmsKeyId
            this.positionFiltering = x.positionFiltering
            this.pricingPlan = x.pricingPlan
            this.pricingPlanDataSource = x.pricingPlanDataSource
            this.tags = x.tags
            this.trackerArn = x.trackerArn
            this.trackerName = x.trackerName
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.DescribeTrackerResponse = DescribeTrackerResponse(this)
    }
}
