// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetDevicePositionHistoryRequest private constructor(builder: Builder) {
    /**
     * The device whose position history you want to retrieve.
     */
    public val deviceId: kotlin.String? = requireNotNull(builder.deviceId) { "A non-null value must be provided for deviceId" }
    /**
     * Specify the end time for the position history in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`. By default, the value will be the time that the request is made.
     *
     * Requirement:
     * + The time specified for `EndTimeExclusive` must be after the time for `StartTimeInclusive`.
     */
    public val endTimeExclusive: aws.smithy.kotlin.runtime.time.Instant? = builder.endTimeExclusive
    /**
     * An optional limit for the number of device positions returned in a single call.
     *
     * Default value: `100`
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.
     *
     * Default value: `null`
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Specify the start time for the position history in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`. By default, the value will be 24 hours prior to the time that the request is made.
     *
     * Requirement:
     * + The time specified for `StartTimeInclusive` must be before `EndTimeExclusive`.
     */
    public val startTimeInclusive: aws.smithy.kotlin.runtime.time.Instant? = builder.startTimeInclusive
    /**
     * The tracker resource receiving the request for the device position history.
     */
    public val trackerName: kotlin.String? = requireNotNull(builder.trackerName) { "A non-null value must be provided for trackerName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.GetDevicePositionHistoryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDevicePositionHistoryRequest(")
        append("deviceId=$deviceId,")
        append("endTimeExclusive=$endTimeExclusive,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("startTimeInclusive=$startTimeInclusive,")
        append("trackerName=$trackerName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceId?.hashCode() ?: 0
        result = 31 * result + (endTimeExclusive?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (startTimeInclusive?.hashCode() ?: 0)
        result = 31 * result + (trackerName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDevicePositionHistoryRequest

        if (deviceId != other.deviceId) return false
        if (endTimeExclusive != other.endTimeExclusive) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (startTimeInclusive != other.startTimeInclusive) return false
        if (trackerName != other.trackerName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.GetDevicePositionHistoryRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The device whose position history you want to retrieve.
         */
        public var deviceId: kotlin.String? = null
        /**
         * Specify the end time for the position history in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`. By default, the value will be the time that the request is made.
         *
         * Requirement:
         * + The time specified for `EndTimeExclusive` must be after the time for `StartTimeInclusive`.
         */
        public var endTimeExclusive: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional limit for the number of device positions returned in a single call.
         *
         * Default value: `100`
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.
         *
         * Default value: `null`
         */
        public var nextToken: kotlin.String? = null
        /**
         * Specify the start time for the position history in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`. By default, the value will be 24 hours prior to the time that the request is made.
         *
         * Requirement:
         * + The time specified for `StartTimeInclusive` must be before `EndTimeExclusive`.
         */
        public var startTimeInclusive: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The tracker resource receiving the request for the device position history.
         */
        public var trackerName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.GetDevicePositionHistoryRequest) : this() {
            this.deviceId = x.deviceId
            this.endTimeExclusive = x.endTimeExclusive
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.startTimeInclusive = x.startTimeInclusive
            this.trackerName = x.trackerName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.GetDevicePositionHistoryRequest = GetDevicePositionHistoryRequest(this)
    }
}
