// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model



/**
 * Contains the calculated route's details for each path between a pair of positions. The number of legs returned corresponds to one fewer than the total number of positions in the request.
 *
 * For example, a route with a departure position and destination position returns one leg with the positions [snapped to a nearby road](https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html):
 * + The `StartPosition` is the departure position.
 * + The `EndPosition` is the destination position.
 *
 * A route with a waypoint between the departure and destination position returns two legs with the positions snapped to a nearby road:
 * + Leg 1: The `StartPosition` is the departure position . The `EndPosition` is the waypoint positon.
 * + Leg 2: The `StartPosition` is the waypoint position. The `EndPosition` is the destination position.
 */
public class Leg private constructor(builder: Builder) {
    /**
     * The distance between the leg's `StartPosition` and `EndPosition` along a calculated route.
     * + The default measurement is `Kilometers` unless the request specifies a `DistanceUnit` of `Miles`.
     */
    public val distance: kotlin.Double? = builder.distance
    /**
     * The estimated travel time between the leg's `StartPosition` and `EndPosition`. The travel mode and departure time that you specify in the request determines the calculated time.
     */
    public val durationSeconds: kotlin.Double? = builder.durationSeconds
    /**
     * The terminating position of the leg. Follows the format `[longitude,latitude]`.
     *
     * If the `EndPosition` isn't located on a road, it's [snapped to a nearby road](https://docs.aws.amazon.com/location/latest/developerguide/nap-to-nearby-road.html).
     */
    public val endPosition: List<Double>? = builder.endPosition
    /**
     * Contains the calculated route's path as a linestring geometry.
     */
    public val geometry: aws.sdk.kotlin.services.location.model.LegGeometry? = builder.geometry
    /**
     * The starting position of the leg. Follows the format `[longitude,latitude]`.
     *
     * If the `StartPosition` isn't located on a road, it's [snapped to a nearby road](https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html).
     */
    public val startPosition: List<Double>? = builder.startPosition
    /**
     * Contains a list of steps, which represent subsections of a leg. Each step provides instructions for how to move to the next step in the leg such as the step's start position, end position, travel distance, travel duration, and geometry offset.
     */
    public val steps: List<Step>? = builder.steps

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.Leg = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Leg(")
        append("distance=$distance,")
        append("durationSeconds=$durationSeconds,")
        append("endPosition=*** Sensitive Data Redacted ***,")
        append("geometry=$geometry,")
        append("startPosition=*** Sensitive Data Redacted ***,")
        append("steps=$steps)")
    }

    override fun hashCode(): kotlin.Int {
        var result = distance?.hashCode() ?: 0
        result = 31 * result + (durationSeconds?.hashCode() ?: 0)
        result = 31 * result + (endPosition?.hashCode() ?: 0)
        result = 31 * result + (geometry?.hashCode() ?: 0)
        result = 31 * result + (startPosition?.hashCode() ?: 0)
        result = 31 * result + (steps?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Leg

        if (distance != other.distance) return false
        if (durationSeconds != other.durationSeconds) return false
        if (endPosition != other.endPosition) return false
        if (geometry != other.geometry) return false
        if (startPosition != other.startPosition) return false
        if (steps != other.steps) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.Leg = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The distance between the leg's `StartPosition` and `EndPosition` along a calculated route.
         * + The default measurement is `Kilometers` unless the request specifies a `DistanceUnit` of `Miles`.
         */
        public var distance: kotlin.Double? = null
        /**
         * The estimated travel time between the leg's `StartPosition` and `EndPosition`. The travel mode and departure time that you specify in the request determines the calculated time.
         */
        public var durationSeconds: kotlin.Double? = null
        /**
         * The terminating position of the leg. Follows the format `[longitude,latitude]`.
         *
         * If the `EndPosition` isn't located on a road, it's [snapped to a nearby road](https://docs.aws.amazon.com/location/latest/developerguide/nap-to-nearby-road.html).
         */
        public var endPosition: List<Double>? = null
        /**
         * Contains the calculated route's path as a linestring geometry.
         */
        public var geometry: aws.sdk.kotlin.services.location.model.LegGeometry? = null
        /**
         * The starting position of the leg. Follows the format `[longitude,latitude]`.
         *
         * If the `StartPosition` isn't located on a road, it's [snapped to a nearby road](https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html).
         */
        public var startPosition: List<Double>? = null
        /**
         * Contains a list of steps, which represent subsections of a leg. Each step provides instructions for how to move to the next step in the leg such as the step's start position, end position, travel distance, travel duration, and geometry offset.
         */
        public var steps: List<Step>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.Leg) : this() {
            this.distance = x.distance
            this.durationSeconds = x.durationSeconds
            this.endPosition = x.endPosition
            this.geometry = x.geometry
            this.startPosition = x.startPosition
            this.steps = x.steps
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.Leg = Leg(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.LegGeometry] inside the given [block]
         */
        public fun geometry(block: aws.sdk.kotlin.services.location.model.LegGeometry.Builder.() -> kotlin.Unit) {
            this.geometry = aws.sdk.kotlin.services.location.model.LegGeometry.invoke(block)
        }
    }
}
