// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the geofence collection details.
 */
public class ListGeofenceCollectionsResponseEntry private constructor(builder: Builder) {
    /**
     * The name of the geofence collection.
     */
    public val collectionName: kotlin.String? = builder.collectionName
    /**
     * The timestamp for when the geofence collection was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The description for the geofence collection
     */
    public val description: kotlin.String? = builder.description
    /**
     * No longer used. Always returns `RequestBasedUsage`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = builder.pricingPlan
    /**
     * No longer used. Always returns an empty string.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlanDataSource: kotlin.String? = builder.pricingPlanDataSource
    /**
     * Specifies a timestamp for when the resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.ListGeofenceCollectionsResponseEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListGeofenceCollectionsResponseEntry(")
        append("collectionName=$collectionName,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("pricingPlan=$pricingPlan,")
        append("pricingPlanDataSource=$pricingPlanDataSource,")
        append("updateTime=$updateTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionName?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (pricingPlanDataSource?.hashCode() ?: 0)
        result = 31 * result + (updateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListGeofenceCollectionsResponseEntry

        if (collectionName != other.collectionName) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (pricingPlan != other.pricingPlan) return false
        if (pricingPlanDataSource != other.pricingPlanDataSource) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.ListGeofenceCollectionsResponseEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the geofence collection.
         */
        public var collectionName: kotlin.String? = null
        /**
         * The timestamp for when the geofence collection was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for the geofence collection
         */
        public var description: kotlin.String? = null
        /**
         * No longer used. Always returns `RequestBasedUsage`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = null
        /**
         * No longer used. Always returns an empty string.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlanDataSource: kotlin.String? = null
        /**
         * Specifies a timestamp for when the resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.ListGeofenceCollectionsResponseEntry) : this() {
            this.collectionName = x.collectionName
            this.createTime = x.createTime
            this.description = x.description
            this.pricingPlan = x.pricingPlan
            this.pricingPlanDataSource = x.pricingPlanDataSource
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.ListGeofenceCollectionsResponseEntry = ListGeofenceCollectionsResponseEntry(this)
    }
}
